/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegion
implements ISeedReader {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final List<IChunk> field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_217380_e;
    private final ServerWorld field_201689_f;
    private final long field_201690_g;
    private final IWorldInfo field_201692_i;
    private final Random field_201693_j;
    private final DimensionType field_241159_j_;
    private final ITickList<Block> field_205336_m = new WorldGenTickList(p_205335_1_ -> this.func_217349_x((BlockPos)p_205335_1_).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList(p_205334_1_ -> this.func_217349_x((BlockPos)p_205334_1_).func_212247_j());
    private final BiomeManager field_229862_o_;
    private final ChunkPos field_241160_n_;
    private final ChunkPos field_241161_o_;
    private final StructureManager field_244530_p;

    public WorldGenRegion(ServerWorld p_i50698_1_, List<IChunk> p_i50698_2_) {
        int i = MathHelper.func_76128_c((double)Math.sqrt(p_i50698_2_.size()));
        if (i * i != p_i50698_2_.size()) {
            throw (IllegalStateException)Util.func_229757_c_((Throwable)new IllegalStateException("Cache size is not a square."));
        }
        ChunkPos chunkpos = p_i50698_2_.get(p_i50698_2_.size() / 2).func_76632_l();
        this.field_201684_a = p_i50698_2_;
        this.field_201685_b = chunkpos.field_77276_a;
        this.field_201686_c = chunkpos.field_77275_b;
        this.field_217380_e = i;
        this.field_201689_f = p_i50698_1_;
        this.field_201690_g = p_i50698_1_.func_72905_C();
        this.field_201692_i = p_i50698_1_.func_72912_H();
        this.field_201693_j = p_i50698_1_.func_201674_k();
        this.field_241159_j_ = p_i50698_1_.func_230315_m_();
        this.field_229862_o_ = new BiomeManager((BiomeManager.IBiomeReader)this, BiomeManager.func_235200_a_((long)this.field_201690_g), p_i50698_1_.func_230315_m_().func_227176_e_());
        this.field_241160_n_ = p_i50698_2_.get(0).func_76632_l();
        this.field_241161_o_ = p_i50698_2_.get(p_i50698_2_.size() - 1).func_76632_l();
        this.field_244530_p = p_i50698_1_.func_241112_a_().func_241464_a_(this);
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.func_217348_a(chunkX, chunkZ, ChunkStatus.field_223226_a_);
    }

    @Nullable
    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        IChunk ichunk;
        if (this.func_217354_b(x, z)) {
            int i = x - this.field_241160_n_.field_77276_a;
            int j = z - this.field_241160_n_.field_77275_b;
            ichunk = this.field_201684_a.get(i + j * this.field_217380_e);
            if (ichunk.func_201589_g().func_209003_a(requiredStatus)) {
                return ichunk;
            }
        } else {
            ichunk = null;
        }
        if (!nonnull) {
            return null;
        }
        field_208303_a.error("Requested chunk : {} {}", (Object)x, (Object)z);
        field_208303_a.error("Region bounds : {} {} | {} {}", (Object)this.field_241160_n_.field_77276_a, (Object)this.field_241160_n_.field_77275_b, (Object)this.field_241161_o_.field_77276_a, (Object)this.field_241161_o_.field_77275_b);
        if (ichunk != null) {
            throw (RuntimeException)Util.func_229757_c_((Throwable)new RuntimeException(String.format("Chunk is not of correct status. Expecting %s, got %s | %s %s", new Object[]{requiredStatus, ichunk.func_201589_g(), x, z})));
        }
        throw (RuntimeException)Util.func_229757_c_((Throwable)new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", x, z)));
    }

    public boolean func_217354_b(int chunkX, int chunkZ) {
        return chunkX >= this.field_241160_n_.field_77276_a && chunkX <= this.field_241161_o_.field_77276_a && chunkZ >= this.field_241160_n_.field_77275_b && chunkZ <= this.field_241161_o_.field_77275_b;
    }

    public BlockState func_180495_p(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_180495_p(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.func_217349_x(pos).func_204610_c(pos);
    }

    @Nullable
    public PlayerEntity func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        return null;
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return this.field_229862_o_;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return this.field_201689_f.func_225604_a_(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public WorldLightManager func_225524_e_() {
        return this.field_201689_f.func_225524_e_();
    }

    public boolean func_241212_a_(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        BlockState blockstate = this.func_180495_p(pos);
        if (blockstate.isAir((IBlockReader)((Object)this), pos)) {
            return false;
        }
        if (dropBlock) {
            TileEntity tileentity = blockstate.hasTileEntity() ? this.func_175625_s(pos) : null;
            Block.func_220054_a(blockstate, this.field_201689_f, pos, tileentity, entity, ItemStack.field_190927_a);
        }
        return this.func_241211_a_(pos, Blocks.field_150350_a.func_176223_P(), 3, recursionLeft);
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        IChunk ichunk = this.func_217349_x(pos);
        TileEntity tileentity = ichunk.func_175625_s(pos);
        if (tileentity != null) {
            return tileentity;
        }
        CompoundNBT compoundnbt = ichunk.func_201579_g(pos);
        BlockState blockstate = ichunk.func_180495_p(pos);
        if (compoundnbt != null) {
            if ("DUMMY".equals(compoundnbt.func_74779_i("id"))) {
                Block block = blockstate.func_177230_c();
                if (!blockstate.hasTileEntity()) {
                    return null;
                }
                tileentity = blockstate.createTileEntity((IBlockReader)((Object)this.field_201689_f));
            } else {
                tileentity = TileEntity.func_235657_b_(blockstate, compoundnbt);
            }
            if (tileentity != null) {
                ichunk.func_177426_a(pos, tileentity);
                return tileentity;
            }
        }
        if (blockstate.hasTileEntity()) {
            field_208303_a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    public boolean func_241211_a_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        IChunk ichunk = this.func_217349_x(pos);
        BlockState blockstate = ichunk.func_177436_a(pos, state, false);
        if (blockstate != null) {
            this.field_201689_f.func_217393_a(pos, blockstate, state);
        }
        Block block = state.func_177230_c();
        if (state.hasTileEntity()) {
            if (ichunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                ichunk.func_177426_a(pos, state.createTileEntity((IBlockReader)((Object)this)));
            } else {
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_74768_a("x", pos.func_177958_n());
                compoundnbt.func_74768_a("y", pos.func_177956_o());
                compoundnbt.func_74768_a("z", pos.func_177952_p());
                compoundnbt.func_74778_a("id", "DUMMY");
                ichunk.func_201591_a(compoundnbt);
            }
        } else if (blockstate != null && blockstate.hasTileEntity()) {
            ichunk.func_177425_e(pos);
        }
        if (state.func_202065_c((IBlockReader)((Object)this), pos)) {
            this.func_201683_l(pos);
        }
        return true;
    }

    private void func_201683_l(BlockPos pos) {
        this.func_217349_x(pos).func_201594_d(pos);
    }

    public boolean func_217376_c(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)(entityIn.func_226277_ct_() / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.func_226281_cx_() / 16.0));
        this.func_212866_a_(i, j).func_76612_a(entityIn);
        return true;
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        return this.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    public boolean func_201670_d() {
        return false;
    }

    @Deprecated
    public ServerWorld func_201672_e() {
        return this.field_201689_f;
    }

    public DynamicRegistries func_241828_r() {
        return this.field_201689_f.func_241828_r();
    }

    public IWorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        if (!this.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_242413_ae());
    }

    public AbstractChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    public long func_72905_C() {
        return this.field_201690_g;
    }

    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    public int func_181545_F() {
        return this.field_201689_f.func_181545_F();
    }

    public Random func_201674_k() {
        return this.field_201693_j;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.func_212866_a_(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1;
    }

    public void func_184133_a(@Nullable PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217378_a(@Nullable PlayerEntity player, int type, BlockPos pos, int data) {
    }

    public DimensionType func_230315_m_() {
        return this.field_241159_j_;
    }

    public boolean func_217375_a(BlockPos pos, Predicate<BlockState> state) {
        return state.test(this.func_180495_p(pos));
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        return Collections.emptyList();
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<PlayerEntity> func_217369_A() {
        return Collections.emptyList();
    }

    public Stream<? extends StructureStart<?>> func_241827_a(SectionPos p_241827_1_, Structure<?> p_241827_2_) {
        return this.field_244530_p.func_235011_a_(p_241827_1_, p_241827_2_);
    }
}

