/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

public class Java9BackportUtils {
    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return Collector.of(downstream.supplier(), (r, t) -> {
            try (Stream result = (Stream)mapper.apply(t);){
                if (result != null) {
                    ((Stream)result.sequential()).forEach(u -> downstreamAccumulator.accept(r, u));
                }
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics().toArray(new Collector.Characteristics[0]));
    }

    public static <T> void ifPresentOrElse(Optional<T> optional, Consumer<? super T> action, Runnable emptyAction) {
        if (optional.isPresent()) {
            action.accept(optional.get());
        } else {
            emptyAction.run();
        }
    }

    public static <T> Stream<T> toStream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }
}

