/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.brain;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class BrainUtil {
    public static void func_220618_a(LivingEntity livingEntity, LivingEntity livingEntity2, float f) {
        BrainUtil.func_220616_b(livingEntity, livingEntity2);
        BrainUtil.func_220626_d(livingEntity, livingEntity2, f);
    }

    public static boolean func_220619_a(Brain<?> brain, LivingEntity livingEntity) {
        return brain.func_218207_c(MemoryModuleType.field_220946_g).filter(list -> list.contains(livingEntity)).isPresent();
    }

    public static boolean func_220623_a(Brain<?> brain, MemoryModuleType<? extends LivingEntity> memoryModuleType, EntityType<?> entityType) {
        return BrainUtil.func_233870_a_(brain, memoryModuleType, livingEntity -> livingEntity.func_200600_R() == entityType);
    }

    private static boolean func_233870_a_(Brain<?> brain, MemoryModuleType<? extends LivingEntity> memoryModuleType, Predicate<LivingEntity> predicate) {
        return brain.func_218207_c(memoryModuleType).filter(predicate).filter(LivingEntity::func_70089_S).filter(livingEntity -> BrainUtil.func_220619_a(brain, livingEntity)).isPresent();
    }

    private static void func_220616_b(LivingEntity livingEntity, LivingEntity livingEntity2) {
        BrainUtil.func_220625_c(livingEntity, livingEntity2);
        BrainUtil.func_220625_c(livingEntity2, livingEntity);
    }

    public static void func_220625_c(LivingEntity livingEntity, LivingEntity livingEntity2) {
        livingEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, new EntityPosWrapper(livingEntity2, true));
    }

    private static void func_220626_d(LivingEntity livingEntity, LivingEntity livingEntity2, float f) {
        int n = 2;
        BrainUtil.func_233860_a_(livingEntity, livingEntity2, f, 2);
        BrainUtil.func_233860_a_(livingEntity2, livingEntity, f, 2);
    }

    public static void func_233860_a_(LivingEntity livingEntity, Entity entity, float f, int n) {
        WalkTarget walkTarget = new WalkTarget(new EntityPosWrapper(entity, false), f, n);
        livingEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, new EntityPosWrapper(entity, true));
        livingEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, walkTarget);
    }

    public static void func_233866_a_(LivingEntity livingEntity, BlockPos blockPos, float f, int n) {
        WalkTarget walkTarget = new WalkTarget(new BlockPosWrapper(blockPos), f, n);
        livingEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, new BlockPosWrapper(blockPos));
        livingEntity.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, walkTarget);
    }

    public static void func_233865_a_(LivingEntity livingEntity, ItemStack itemStack, Vector3d vector3d) {
        double d = livingEntity.func_226280_cw_() - (double)0.3f;
        ItemEntity \u26032 = new ItemEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), d, livingEntity.func_226281_cx_(), itemStack);
        float \u26033 = 0.3f;
        Vector3d \u26034 = vector3d.func_178788_d(livingEntity.func_213303_ch());
        \u26034 = \u26034.func_72432_b().func_186678_a(0.3f);
        \u26032.func_213317_d(\u26034);
        \u26032.func_174869_p();
        livingEntity.field_70170_p.func_217376_c(\u26032);
    }

    public static SectionPos func_220617_a(ServerWorld serverWorld, SectionPos sectionPos2, int n) {
        \u2603 = serverWorld.func_217486_a(sectionPos2);
        return SectionPos.func_218158_a(sectionPos2, n).filter(sectionPos -> serverWorld.func_217486_a((SectionPos)sectionPos) < \u2603).min(Comparator.comparingInt(serverWorld::func_217486_a)).orElse(sectionPos2);
    }

    public static boolean func_233869_a_(MobEntity mobEntity2, LivingEntity livingEntity, int n) {
        MobEntity mobEntity2;
        Item item = mobEntity2.func_184614_ca().func_77973_b();
        if (item instanceof ShootableItem && mobEntity2.func_230280_a_((ShootableItem)item)) {
            int n2 = ((ShootableItem)item).func_230305_d_() - n;
            return mobEntity2.func_233562_a_(livingEntity, n2);
        }
        return BrainUtil.func_233874_b_(mobEntity2, livingEntity);
    }

    public static boolean func_233874_b_(LivingEntity livingEntity, LivingEntity livingEntity2) {
        double d = livingEntity.func_70092_e(livingEntity2.func_226277_ct_(), livingEntity2.func_226278_cu_(), livingEntity2.func_226281_cx_());
        return d <= (\u2603 = (double)(livingEntity.func_213311_cf() * 2.0f * (livingEntity.func_213311_cf() * 2.0f) + livingEntity2.func_213311_cf()));
    }

    public static boolean func_233861_a_(LivingEntity livingEntity, LivingEntity livingEntity2, double d) {
        Optional<LivingEntity> optional = livingEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        if (!optional.isPresent()) {
            return false;
        }
        double \u26032 = livingEntity.func_195048_a(optional.get().func_213303_ch());
        double \u26033 = livingEntity.func_195048_a(livingEntity2.func_213303_ch());
        return \u26033 > \u26032 + d * d;
    }

    public static boolean func_233876_c_(LivingEntity livingEntity, LivingEntity livingEntity2) {
        Brain<List<LivingEntity>> brain = livingEntity.func_213375_cj();
        if (!brain.func_218191_a(MemoryModuleType.field_220946_g)) {
            return false;
        }
        return brain.func_218207_c(MemoryModuleType.field_220946_g).get().contains(livingEntity2);
    }

    public static LivingEntity func_233867_a_(LivingEntity livingEntity, Optional<LivingEntity> optional, LivingEntity livingEntity2) {
        if (!optional.isPresent()) {
            return livingEntity2;
        }
        return BrainUtil.func_233863_a_(livingEntity, optional.get(), livingEntity2);
    }

    public static LivingEntity func_233863_a_(LivingEntity livingEntity, LivingEntity livingEntity2, LivingEntity livingEntity3) {
        Vector3d vector3d = livingEntity2.func_213303_ch();
        \u2603 = livingEntity3.func_213303_ch();
        return livingEntity.func_195048_a(vector3d) < livingEntity.func_195048_a(\u2603) ? livingEntity2 : livingEntity3;
    }

    public static Optional<LivingEntity> func_233864_a_(LivingEntity livingEntity, MemoryModuleType<UUID> memoryModuleType) {
        Optional<UUID> optional = livingEntity.func_213375_cj().func_218207_c(memoryModuleType);
        return optional.map(uUID -> (LivingEntity)((ServerWorld)livingEntity.field_70170_p).func_217461_a((UUID)uUID));
    }

    public static Stream<VillagerEntity> func_233872_a_(VillagerEntity villagerEntity, Predicate<VillagerEntity> predicate) {
        return villagerEntity.func_213375_cj().func_218207_c(MemoryModuleType.field_220945_f).map(list -> list.stream().filter(livingEntity -> livingEntity instanceof VillagerEntity && livingEntity != villagerEntity).map(livingEntity -> (VillagerEntity)livingEntity).filter(LivingEntity::func_70089_S).filter(predicate)).orElseGet(Stream::empty);
    }
}

