/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;

public class NBTDynamicOps
implements DynamicOps<INBT> {
    public static final NBTDynamicOps field_210820_a = new NBTDynamicOps();

    protected NBTDynamicOps() {
    }

    public INBT empty() {
        return EndNBT.field_229686_b_;
    }

    public <U> U convertTo(DynamicOps<U> dynamicOps, INBT iNBT) {
        switch (iNBT.func_74732_a()) {
            case 0: {
                return (U)dynamicOps.empty();
            }
            case 1: {
                return (U)dynamicOps.createByte(((NumberNBT)iNBT).func_150290_f());
            }
            case 2: {
                return (U)dynamicOps.createShort(((NumberNBT)iNBT).func_150289_e());
            }
            case 3: {
                return (U)dynamicOps.createInt(((NumberNBT)iNBT).func_150287_d());
            }
            case 4: {
                return (U)dynamicOps.createLong(((NumberNBT)iNBT).func_150291_c());
            }
            case 5: {
                return (U)dynamicOps.createFloat(((NumberNBT)iNBT).func_150288_h());
            }
            case 6: {
                return (U)dynamicOps.createDouble(((NumberNBT)iNBT).func_150286_g());
            }
            case 7: {
                return (U)dynamicOps.createByteList(ByteBuffer.wrap(((ByteArrayNBT)iNBT).func_150292_c()));
            }
            case 8: {
                return (U)dynamicOps.createString(iNBT.func_150285_a_());
            }
            case 9: {
                return (U)this.convertList(dynamicOps, iNBT);
            }
            case 10: {
                return (U)this.convertMap(dynamicOps, iNBT);
            }
            case 11: {
                return (U)dynamicOps.createIntList(Arrays.stream(((IntArrayNBT)iNBT).func_150302_c()));
            }
            case 12: {
                return (U)dynamicOps.createLongList(Arrays.stream(((LongArrayNBT)iNBT).func_197652_h()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + iNBT);
    }

    public DataResult<Number> getNumberValue(INBT iNBT) {
        if (iNBT instanceof NumberNBT) {
            return DataResult.success((Object)((NumberNBT)iNBT).func_209908_j());
        }
        return DataResult.error((String)"Not a number");
    }

    public INBT createNumeric(Number number) {
        return DoubleNBT.func_229684_a_(number.doubleValue());
    }

    public INBT createByte(byte by) {
        return ByteNBT.func_229671_a_(by);
    }

    public INBT createShort(short s) {
        return ShortNBT.func_229701_a_(s);
    }

    public INBT createInt(int n) {
        return IntNBT.func_229692_a_(n);
    }

    public INBT createLong(long l) {
        return LongNBT.func_229698_a_(l);
    }

    public INBT createFloat(float f) {
        return FloatNBT.func_229689_a_(f);
    }

    public INBT createDouble(double d) {
        return DoubleNBT.func_229684_a_(d);
    }

    public INBT createBoolean(boolean bl) {
        return ByteNBT.func_229672_a_(bl);
    }

    public DataResult<String> getStringValue(INBT iNBT) {
        if (iNBT instanceof StringNBT) {
            return DataResult.success((Object)iNBT.func_150285_a_());
        }
        return DataResult.error((String)"Not a string");
    }

    public INBT createString(String string) {
        return StringNBT.func_229705_a_(string);
    }

    private static CollectionNBT<?> func_240602_a_(byte by, byte by2) {
        if (NBTDynamicOps.func_240603_a_(by, by2, (byte)4)) {
            return new LongArrayNBT(new long[0]);
        }
        if (NBTDynamicOps.func_240603_a_(by, by2, (byte)1)) {
            return new ByteArrayNBT(new byte[0]);
        }
        if (NBTDynamicOps.func_240603_a_(by, by2, (byte)3)) {
            return new IntArrayNBT(new int[0]);
        }
        return new ListNBT();
    }

    private static boolean func_240603_a_(byte by, byte by2, byte by3) {
        return by == by3 && (by2 == by3 || by2 == 0);
    }

    private static <T extends INBT> void func_240609_a_(CollectionNBT<T> collectionNBT2, INBT iNBT2, INBT iNBT3) {
        CollectionNBT collectionNBT2;
        if (iNBT2 instanceof CollectionNBT) {
            CollectionNBT collectionNBT3 = (CollectionNBT)iNBT2;
            collectionNBT3.forEach(iNBT -> collectionNBT2.add(iNBT));
        }
        collectionNBT2.add(iNBT3);
    }

    private static <T extends INBT> void func_240608_a_(CollectionNBT<T> collectionNBT, INBT iNBT2, List<INBT> list2) {
        List<INBT> list2;
        if (iNBT2 instanceof CollectionNBT) {
            CollectionNBT collectionNBT2 = (CollectionNBT)iNBT2;
            collectionNBT2.forEach(iNBT -> collectionNBT.add(iNBT));
        }
        list2.forEach(iNBT -> collectionNBT.add(iNBT));
    }

    public DataResult<INBT> mergeToList(INBT iNBT, INBT iNBT2) {
        if (!(iNBT instanceof CollectionNBT) && !(iNBT instanceof EndNBT)) {
            return DataResult.error((String)("mergeToList called with not a list: " + iNBT), (Object)iNBT);
        }
        CollectionNBT<?> collectionNBT = NBTDynamicOps.func_240602_a_(iNBT instanceof CollectionNBT ? ((CollectionNBT)iNBT).func_230528_d__() : (byte)0, iNBT2.func_74732_a());
        NBTDynamicOps.func_240609_a_(collectionNBT, iNBT, iNBT2);
        return DataResult.success(collectionNBT);
    }

    public DataResult<INBT> mergeToList(INBT iNBT, List<INBT> list) {
        if (!(iNBT instanceof CollectionNBT) && !(iNBT instanceof EndNBT)) {
            return DataResult.error((String)("mergeToList called with not a list: " + iNBT), (Object)iNBT);
        }
        CollectionNBT<?> collectionNBT = NBTDynamicOps.func_240602_a_(iNBT instanceof CollectionNBT ? ((CollectionNBT)iNBT).func_230528_d__() : (byte)0, list.stream().findFirst().map(INBT::func_74732_a).orElse((byte)0));
        NBTDynamicOps.func_240608_a_(collectionNBT, iNBT, list);
        return DataResult.success(collectionNBT);
    }

    public DataResult<INBT> mergeToMap(INBT iNBT, INBT iNBT2, INBT iNBT3) {
        if (!(iNBT instanceof CompoundNBT) && !(iNBT instanceof EndNBT)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + iNBT), (Object)iNBT);
        }
        if (!(iNBT2 instanceof StringNBT)) {
            return DataResult.error((String)("key is not a string: " + iNBT2), (Object)iNBT);
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        if (iNBT instanceof CompoundNBT) {
            \u2603 = (CompoundNBT)iNBT;
            \u2603.func_150296_c().forEach(string -> compoundNBT.func_218657_a((String)string, \u2603.func_74781_a((String)string)));
        }
        compoundNBT.func_218657_a(iNBT2.func_150285_a_(), iNBT3);
        return DataResult.success((Object)compoundNBT);
    }

    public DataResult<INBT> mergeToMap(INBT iNBT, MapLike<INBT> mapLike) {
        Object object;
        if (!(iNBT instanceof CompoundNBT) && !(iNBT instanceof EndNBT)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + iNBT), (Object)iNBT);
        }
        CompoundNBT compoundNBT = new CompoundNBT();
        if (iNBT instanceof CompoundNBT) {
            object = (CompoundNBT)iNBT;
            ((CompoundNBT)object).func_150296_c().forEach(arg_0 -> NBTDynamicOps.func_240615_b_(compoundNBT, (CompoundNBT)object, arg_0));
        }
        object = Lists.newArrayList();
        mapLike.entries().forEach(arg_0 -> NBTDynamicOps.func_240605_a_((List)object, compoundNBT, arg_0));
        if (!object.isEmpty()) {
            return DataResult.error((String)("some keys are not strings: " + object), (Object)compoundNBT);
        }
        return DataResult.success((Object)compoundNBT);
    }

    public DataResult<Stream<Pair<INBT, INBT>>> getMapValues(INBT iNBT) {
        if (!(iNBT instanceof CompoundNBT)) {
            return DataResult.error((String)("Not a map: " + iNBT));
        }
        CompoundNBT compoundNBT = (CompoundNBT)iNBT;
        return DataResult.success(compoundNBT.func_150296_c().stream().map(string -> Pair.of((Object)this.createString((String)string), (Object)compoundNBT.func_74781_a((String)string))));
    }

    public DataResult<Consumer<BiConsumer<INBT, INBT>>> getMapEntries(INBT iNBT) {
        if (!(iNBT instanceof CompoundNBT)) {
            return DataResult.error((String)("Not a map: " + iNBT));
        }
        CompoundNBT compoundNBT = (CompoundNBT)iNBT;
        return DataResult.success(biConsumer -> compoundNBT.func_150296_c().forEach(string -> biConsumer.accept(this.createString((String)string), compoundNBT.func_74781_a((String)string))));
    }

    public DataResult<MapLike<INBT>> getMap(INBT iNBT) {
        if (!(iNBT instanceof CompoundNBT)) {
            return DataResult.error((String)("Not a map: " + iNBT));
        }
        final CompoundNBT compoundNBT = (CompoundNBT)iNBT;
        return DataResult.success((Object)new MapLike<INBT>(){

            @Nullable
            public INBT get(INBT iNBT) {
                return compoundNBT.func_74781_a(iNBT.func_150285_a_());
            }

            @Nullable
            public INBT get(String string) {
                return compoundNBT.func_74781_a(string);
            }

            public Stream<Pair<INBT, INBT>> entries() {
                return compoundNBT.func_150296_c().stream().map(string -> Pair.of((Object)NBTDynamicOps.this.createString((String)string), (Object)compoundNBT.func_74781_a((String)string)));
            }

            public String toString() {
                return "MapLike[" + compoundNBT + "]";
            }

            @Nullable
            public /* synthetic */ Object get(String string) {
                return this.get(string);
            }

            @Nullable
            public /* synthetic */ Object get(Object object) {
                return this.get((INBT)object);
            }
        });
    }

    public INBT createMap(Stream<Pair<INBT, INBT>> stream) {
        CompoundNBT compoundNBT = new CompoundNBT();
        stream.forEach(pair -> compoundNBT.func_218657_a(((INBT)pair.getFirst()).func_150285_a_(), (INBT)pair.getSecond()));
        return compoundNBT;
    }

    public DataResult<Stream<INBT>> getStream(INBT iNBT2) {
        if (iNBT2 instanceof CollectionNBT) {
            return DataResult.success(((CollectionNBT)iNBT2).stream().map(iNBT -> iNBT));
        }
        return DataResult.error((String)"Not a list");
    }

    public DataResult<Consumer<Consumer<INBT>>> getList(INBT iNBT2) {
        INBT iNBT2;
        if (iNBT2 instanceof CollectionNBT) {
            CollectionNBT collectionNBT = (CollectionNBT)iNBT2;
            return DataResult.success(collectionNBT::forEach);
        }
        return DataResult.error((String)("Not a list: " + iNBT2));
    }

    public DataResult<ByteBuffer> getByteBuffer(INBT iNBT) {
        if (iNBT instanceof ByteArrayNBT) {
            return DataResult.success((Object)ByteBuffer.wrap(((ByteArrayNBT)iNBT).func_150292_c()));
        }
        return super.getByteBuffer((Object)iNBT);
    }

    public INBT createByteList(ByteBuffer byteBuffer) {
        return new ByteArrayNBT(DataFixUtils.toArray((ByteBuffer)byteBuffer));
    }

    public DataResult<IntStream> getIntStream(INBT iNBT) {
        if (iNBT instanceof IntArrayNBT) {
            return DataResult.success((Object)Arrays.stream(((IntArrayNBT)iNBT).func_150302_c()));
        }
        return super.getIntStream((Object)iNBT);
    }

    public INBT createIntList(IntStream intStream) {
        return new IntArrayNBT(intStream.toArray());
    }

    public DataResult<LongStream> getLongStream(INBT iNBT) {
        if (iNBT instanceof LongArrayNBT) {
            return DataResult.success((Object)Arrays.stream(((LongArrayNBT)iNBT).func_197652_h()));
        }
        return super.getLongStream((Object)iNBT);
    }

    public INBT createLongList(LongStream longStream) {
        return new LongArrayNBT(longStream.toArray());
    }

    public INBT createList(Stream<INBT> stream) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(stream.iterator());
        if (!peekingIterator.hasNext()) {
            return new ListNBT();
        }
        INBT \u26032 = (INBT)peekingIterator.peek();
        if (\u26032 instanceof ByteNBT) {
            ArrayList arrayList = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((ByteNBT)iNBT).func_150290_f()));
            return new ByteArrayNBT(arrayList);
        }
        if (\u26032 instanceof IntNBT) {
            ArrayList \u26033 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((IntNBT)iNBT).func_150287_d()));
            return new IntArrayNBT(\u26033);
        }
        if (\u26032 instanceof LongNBT) {
            ArrayList \u26034 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, iNBT -> ((LongNBT)iNBT).func_150291_c()));
            return new LongArrayNBT(\u26034);
        }
        ListNBT listNBT = new ListNBT();
        while (peekingIterator.hasNext()) {
            INBT iNBT2 = (INBT)peekingIterator.next();
            if (iNBT2 instanceof EndNBT) continue;
            listNBT.add(iNBT2);
        }
        return listNBT;
    }

    public INBT remove(INBT iNBT2, String string3) {
        INBT iNBT2;
        if (iNBT2 instanceof CompoundNBT) {
            CompoundNBT compoundNBT = (CompoundNBT)iNBT2;
            \u2603 = new CompoundNBT();
            compoundNBT.func_150296_c().stream().filter(string2 -> !Objects.equals(string2, string3)).forEach(string -> \u2603.func_218657_a((String)string, compoundNBT.func_74781_a((String)string)));
            return \u2603;
        }
        return iNBT2;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<INBT> mapBuilder() {
        return new NBTRecordBuilder();
    }

    public /* synthetic */ Object remove(Object object, String string) {
        return this.remove((INBT)object, string);
    }

    public /* synthetic */ Object createLongList(LongStream longStream) {
        return this.createLongList(longStream);
    }

    public /* synthetic */ DataResult getLongStream(Object object) {
        return this.getLongStream((INBT)object);
    }

    public /* synthetic */ Object createIntList(IntStream intStream) {
        return this.createIntList(intStream);
    }

    public /* synthetic */ DataResult getIntStream(Object object) {
        return this.getIntStream((INBT)object);
    }

    public /* synthetic */ Object createByteList(ByteBuffer byteBuffer) {
        return this.createByteList(byteBuffer);
    }

    public /* synthetic */ DataResult getByteBuffer(Object object) {
        return this.getByteBuffer((INBT)object);
    }

    public /* synthetic */ Object createList(Stream stream) {
        return this.createList(stream);
    }

    public /* synthetic */ DataResult getList(Object object) {
        return this.getList((INBT)object);
    }

    public /* synthetic */ DataResult getStream(Object object) {
        return this.getStream((INBT)object);
    }

    public /* synthetic */ DataResult getMap(Object object) {
        return this.getMap((INBT)object);
    }

    public /* synthetic */ Object createMap(Stream stream) {
        return this.createMap(stream);
    }

    public /* synthetic */ DataResult getMapEntries(Object object) {
        return this.getMapEntries((INBT)object);
    }

    public /* synthetic */ DataResult getMapValues(Object object) {
        return this.getMapValues((INBT)object);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, MapLike mapLike) {
        return this.mergeToMap((INBT)object, (MapLike<INBT>)mapLike);
    }

    public /* synthetic */ DataResult mergeToMap(Object object, Object object2, Object object3) {
        return this.mergeToMap((INBT)object, (INBT)object2, (INBT)object3);
    }

    public /* synthetic */ DataResult mergeToList(Object object, List list) {
        return this.mergeToList((INBT)object, (List<INBT>)list);
    }

    public /* synthetic */ DataResult mergeToList(Object object, Object object2) {
        return this.mergeToList((INBT)object, (INBT)object2);
    }

    public /* synthetic */ Object createString(String string) {
        return this.createString(string);
    }

    public /* synthetic */ DataResult getStringValue(Object object) {
        return this.getStringValue((INBT)object);
    }

    public /* synthetic */ Object createBoolean(boolean bl) {
        return this.createBoolean(bl);
    }

    public /* synthetic */ Object createDouble(double d) {
        return this.createDouble(d);
    }

    public /* synthetic */ Object createFloat(float f) {
        return this.createFloat(f);
    }

    public /* synthetic */ Object createLong(long l) {
        return this.createLong(l);
    }

    public /* synthetic */ Object createInt(int n) {
        return this.createInt(n);
    }

    public /* synthetic */ Object createShort(short s) {
        return this.createShort(s);
    }

    public /* synthetic */ Object createByte(byte by) {
        return this.createByte(by);
    }

    public /* synthetic */ Object createNumeric(Number number) {
        return this.createNumeric(number);
    }

    public /* synthetic */ DataResult getNumberValue(Object object) {
        return this.getNumberValue((INBT)object);
    }

    public /* synthetic */ Object convertTo(DynamicOps dynamicOps, Object object) {
        return this.convertTo(dynamicOps, (INBT)object);
    }

    public /* synthetic */ Object empty() {
        return this.empty();
    }

    private static /* synthetic */ void func_240605_a_(List list, CompoundNBT compoundNBT, Pair pair) {
        INBT iNBT = (INBT)pair.getFirst();
        if (!(iNBT instanceof StringNBT)) {
            list.add(iNBT);
            return;
        }
        compoundNBT.func_218657_a(iNBT.func_150285_a_(), (INBT)pair.getSecond());
    }

    private static /* synthetic */ void func_240615_b_(CompoundNBT compoundNBT, CompoundNBT compoundNBT2, String string) {
        compoundNBT.func_218657_a(string, compoundNBT2.func_74781_a(string));
    }

    class NBTRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<INBT, CompoundNBT> {
        protected NBTRecordBuilder() {
            super((DynamicOps)NBTDynamicOps.this);
        }

        protected CompoundNBT initBuilder() {
            return new CompoundNBT();
        }

        protected CompoundNBT append(String string, INBT iNBT, CompoundNBT compoundNBT) {
            compoundNBT.func_218657_a(string, iNBT);
            return compoundNBT;
        }

        protected DataResult<INBT> build(CompoundNBT compoundNBT, INBT iNBT2) {
            INBT iNBT2;
            if (iNBT2 == null || iNBT2 == EndNBT.field_229686_b_) {
                return DataResult.success((Object)compoundNBT);
            }
            if (iNBT2 instanceof CompoundNBT) {
                CompoundNBT compoundNBT2 = new CompoundNBT(Maps.newHashMap(((CompoundNBT)iNBT2).func_240600_h_()));
                for (Map.Entry<String, INBT> entry : compoundNBT.func_240600_h_().entrySet()) {
                    compoundNBT2.func_218657_a(entry.getKey(), entry.getValue());
                }
                return DataResult.success((Object)compoundNBT2);
            }
            return DataResult.error((String)("mergeToMap called with not a map: " + iNBT2), (Object)iNBT2);
        }

        protected /* synthetic */ Object append(String string, Object object, Object object2) {
            return this.append(string, (INBT)object, (CompoundNBT)object2);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.build((CompoundNBT)object, (INBT)object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.initBuilder();
        }
    }
}

