/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SortedArraySet<T>
extends AbstractSet<T> {
    private final Comparator<T> field_226169_a_;
    private T[] field_226170_b_;
    private int field_226171_c_;

    private SortedArraySet(int n, Comparator<T> comparator) {
        this.field_226169_a_ = comparator;
        if (n < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n + ") is negative");
        }
        this.field_226170_b_ = SortedArraySet.func_226177_a_(new Object[n]);
    }

    public static <T extends Comparable<T>> SortedArraySet<T> func_226172_a_(int n) {
        return new SortedArraySet(n, Comparator.naturalOrder());
    }

    private static <T> T[] func_226177_a_(Object[] objectArray) {
        return objectArray;
    }

    private int func_226182_c_(T t) {
        return Arrays.binarySearch(this.field_226170_b_, 0, this.field_226171_c_, t, this.field_226169_a_);
    }

    private static int func_226179_b_(int n) {
        return -n - 1;
    }

    @Override
    public boolean add(T t) {
        int n = this.func_226182_c_(t);
        if (n >= 0) {
            return false;
        }
        \u2603 = SortedArraySet.func_226179_b_(n);
        this.func_226176_a_(t, \u2603);
        return true;
    }

    private void func_226181_c_(int n) {
        if (n <= this.field_226170_b_.length) {
            return;
        }
        if (this.field_226170_b_ != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
            n = (int)Math.max(Math.min((long)this.field_226170_b_.length + (long)(this.field_226170_b_.length >> 1), 0x7FFFFFF7L), (long)n);
        } else if (n < 10) {
            n = 10;
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.field_226170_b_, 0, objectArray, 0, this.field_226171_c_);
        this.field_226170_b_ = SortedArraySet.func_226177_a_(objectArray);
    }

    private void func_226176_a_(T t, int n) {
        this.func_226181_c_(this.field_226171_c_ + 1);
        if (n != this.field_226171_c_) {
            System.arraycopy(this.field_226170_b_, n, this.field_226170_b_, n + 1, this.field_226171_c_ - n);
        }
        this.field_226170_b_[n] = t;
        ++this.field_226171_c_;
    }

    private void func_226183_d_(int n) {
        --this.field_226171_c_;
        if (n != this.field_226171_c_) {
            System.arraycopy(this.field_226170_b_, n + 1, this.field_226170_b_, n, this.field_226171_c_ - n);
        }
        this.field_226170_b_[this.field_226171_c_] = null;
    }

    private T func_226184_e_(int n) {
        return this.field_226170_b_[n];
    }

    public T func_226175_a_(T t) {
        int n = this.func_226182_c_(t);
        if (n >= 0) {
            return this.func_226184_e_(n);
        }
        this.func_226176_a_(t, SortedArraySet.func_226179_b_(n));
        return t;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.func_226182_c_(object);
        if (n >= 0) {
            this.func_226183_d_(n);
            return true;
        }
        return false;
    }

    public T func_226178_b_() {
        return this.func_226184_e_(0);
    }

    @Override
    public boolean contains(Object object) {
        int n = this.func_226182_c_(object);
        return n >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.field_226171_c_;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.field_226170_b_.clone();
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        if (UArray.length < this.field_226171_c_) {
            return Arrays.copyOf(this.field_226170_b_, this.field_226171_c_, UArray.getClass());
        }
        System.arraycopy(this.field_226170_b_, 0, UArray, 0, this.field_226171_c_);
        if (UArray.length > this.field_226171_c_) {
            UArray[this.field_226171_c_] = null;
        }
        return UArray;
    }

    @Override
    public void clear() {
        Arrays.fill(this.field_226170_b_, 0, this.field_226171_c_, null);
        this.field_226171_c_ = 0;
    }

    @Override
    public boolean equals(Object object2) {
        Object object2;
        if (this == object2) {
            return true;
        }
        if (object2 instanceof SortedArraySet) {
            SortedArraySet sortedArraySet = (SortedArraySet)object2;
            if (this.field_226169_a_.equals(sortedArraySet.field_226169_a_)) {
                return this.field_226171_c_ == sortedArraySet.field_226171_c_ && Arrays.equals(this.field_226170_b_, sortedArraySet.field_226170_b_);
            }
        }
        return super.equals(object2);
    }

    class Itr
    implements Iterator<T> {
        private int field_226186_b_;
        private int field_226187_c_ = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.field_226186_b_ < SortedArraySet.this.field_226171_c_;
        }

        @Override
        public T next() {
            if (this.field_226186_b_ >= SortedArraySet.this.field_226171_c_) {
                throw new NoSuchElementException();
            }
            this.field_226187_c_ = this.field_226186_b_++;
            return SortedArraySet.this.field_226170_b_[this.field_226187_c_];
        }

        @Override
        public void remove() {
            if (this.field_226187_c_ == -1) {
                throw new IllegalStateException();
            }
            SortedArraySet.this.func_226183_d_(this.field_226187_c_);
            --this.field_226186_b_;
            this.field_226187_c_ = -1;
        }
    }
}

