/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators.loaders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class OBJLoaderBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private ResourceLocation modelLocation;
    private Boolean detectCullableFaces;
    private Boolean diffuseLighting;
    private Boolean flipV;
    private Boolean ambientToFullbright;
    private ResourceLocation materialLibraryOverrideLocation;

    public static <T extends ModelBuilder<T>> OBJLoaderBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new OBJLoaderBuilder<T>(parent, existingFileHelper);
    }

    protected OBJLoaderBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:obj"), parent, existingFileHelper);
    }

    public OBJLoaderBuilder<T> modelLocation(ResourceLocation modelLocation) {
        Preconditions.checkNotNull((Object)modelLocation, (Object)"modelLocation must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(modelLocation, ResourcePackType.CLIENT_RESOURCES), (String)"OBJ Model %s does not exist in any known resource pack", (Object)modelLocation);
        this.modelLocation = modelLocation;
        return this;
    }

    public OBJLoaderBuilder<T> detectCullableFaces(boolean detectCullableFaces) {
        this.detectCullableFaces = detectCullableFaces;
        return this;
    }

    public OBJLoaderBuilder<T> diffuseLighting(boolean diffuseLighting) {
        this.diffuseLighting = diffuseLighting;
        return this;
    }

    public OBJLoaderBuilder<T> flipV(boolean flipV) {
        this.flipV = flipV;
        return this;
    }

    public OBJLoaderBuilder<T> ambientToFullbright(boolean ambientToFullbright) {
        this.ambientToFullbright = ambientToFullbright;
        return this;
    }

    public OBJLoaderBuilder<T> overrideMaterialLibrary(ResourceLocation materialLibraryOverrideLocation) {
        Preconditions.checkNotNull((Object)materialLibraryOverrideLocation, (Object)"materialLibraryOverrideLocation must not be null");
        Preconditions.checkArgument((boolean)this.existingFileHelper.exists(materialLibraryOverrideLocation, ResourcePackType.CLIENT_RESOURCES), (String)"OBJ Model %s does not exist in any known resource pack", (Object)materialLibraryOverrideLocation);
        this.materialLibraryOverrideLocation = materialLibraryOverrideLocation;
        return this;
    }

    @Override
    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        Preconditions.checkNotNull((Object)this.modelLocation, (Object)"modelLocation must not be null");
        json.addProperty("model", this.modelLocation.toString());
        if (this.detectCullableFaces != null) {
            json.addProperty("detectCullableFaces", this.detectCullableFaces);
        }
        if (this.diffuseLighting != null) {
            json.addProperty("diffuseLighting", this.diffuseLighting);
        }
        if (this.flipV != null) {
            json.addProperty("flip-v", this.flipV);
        }
        if (this.ambientToFullbright != null) {
            json.addProperty("ambientToFullbright", this.ambientToFullbright);
        }
        if (this.materialLibraryOverrideLocation != null) {
            json.addProperty("materialLibraryOverrideLocation", this.materialLibraryOverrideLocation.toString());
        }
        return json;
    }
}

