/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        currentBiomes[BiomeType.DESERT_LEGACY.ordinal()] = new TrackedList((Object[])new BiomeEntry[]{new BiomeEntry((RegistryKey<Biome>)Biomes.field_76769_d, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76767_f, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76770_e, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76780_h, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76772_c, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76768_g, 10)});
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList((Object[])new BiomeEntry[]{new BiomeEntry((RegistryKey<Biome>)Biomes.field_76769_d, 30), new BiomeEntry((RegistryKey<Biome>)Biomes.field_150588_X, 20), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76772_c, 10)});
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList((Object[])new BiomeEntry[]{new BiomeEntry((RegistryKey<Biome>)Biomes.field_76767_f, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_150585_R, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76770_e, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76772_c, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_150583_P, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76780_h, 10)});
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList((Object[])new BiomeEntry[]{new BiomeEntry((RegistryKey<Biome>)Biomes.field_76767_f, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76770_e, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76768_g, 10), new BiomeEntry((RegistryKey<Biome>)Biomes.field_76772_c, 10)});
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList((Object[])new BiomeEntry[]{new BiomeEntry((RegistryKey<Biome>)Biomes.field_76774_n, 30), new BiomeEntry((RegistryKey<Biome>)Biomes.field_150584_S, 10)});
        return currentBiomes;
    }

    public static boolean addBiome(BiomeType type, BiomeEntry entry) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        return list == null ? false : list.add(entry);
    }

    public static boolean removeBiome(BiomeType type, BiomeEntry entry) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        return list == null ? false : list.remove((Object)entry);
    }

    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx >= biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : ImmutableList.of();
    }

    public static boolean isTypeListModded(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx > biomes.length ? null : biomes[idx];
        return list == null ? false : list.isModded();
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean isModded = false;

        @SafeVarargs
        private <T extends E> TrackedList(T ... c) {
            super(Arrays.asList(c));
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e) {
            this.isModded = true;
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.isModded = true;
            return super.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.isModded = true;
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.isModded = true;
            return super.retainAll(c);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends WeightedRandom.Item {
        private final RegistryKey<Biome> key;

        public BiomeEntry(RegistryKey<Biome> key, int weight) {
            super(weight);
            this.key = key;
        }

        public RegistryKey<Biome> getKey() {
            return this.key;
        }
    }

    public static enum BiomeType {
        DESERT,
        DESERT_LEGACY,
        WARM,
        COOL,
        ICY;

    }
}

