/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SCommandListPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.network.CommandTreeCleaner;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaConnectionNetworkFilter
extends MessageToMessageEncoder<IPacket<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<? extends IPacket<?>>, Function<IPacket<?>, ? extends IPacket<?>>> handlers = ImmutableMap.builder().put(VanillaConnectionNetworkFilter.handler(SEntityPropertiesPacket.class, VanillaConnectionNetworkFilter::filterEntityProperties)).put(VanillaConnectionNetworkFilter.handler(SCommandListPacket.class, VanillaConnectionNetworkFilter::filterCommandList)).build();

    public static void injectIfNecessary(NetworkManager manager) {
        if (NetworkHooks.isVanillaConnection(manager)) {
            manager.channel().pipeline().addBefore("packet_handler", "forge:vanilla_filter", (ChannelHandler)new VanillaConnectionNetworkFilter());
            LOGGER.debug("Injected into {}", (Object)manager);
        }
    }

    @Nonnull
    private static <T extends IPacket<?>> Map.Entry<Class<? extends IPacket<?>>, Function<IPacket<?>, ? extends IPacket<?>>> handler(Class<T> cls, Function<T, ? extends IPacket<?>> function) {
        return new AbstractMap.SimpleEntry(cls, function.compose(cls::cast));
    }

    @Nonnull
    private static SEntityPropertiesPacket filterEntityProperties(SEntityPropertiesPacket msg) {
        SEntityPropertiesPacket newPacket = new SEntityPropertiesPacket(msg.func_149442_c(), Collections.emptyList());
        msg.func_149441_d().stream().filter(snapshot -> {
            ResourceLocation key = ForgeRegistries.ATTRIBUTES.getKey(snapshot.func_240834_a_());
            return key != null && key.func_110624_b().equals("minecraft");
        }).forEach(snapshot -> newPacket.func_149441_d().add(snapshot));
        return newPacket;
    }

    @Nonnull
    private static SCommandListPacket filterCommandList(SCommandListPacket packet) {
        RootCommandNode root = packet.func_197693_a();
        RootCommandNode newRoot = CommandTreeCleaner.cleanArgumentTypes(root, argType -> {
            ResourceLocation id = ArgumentTypes.getId((ArgumentType)argType);
            return id != null && (id.func_110624_b().equals("minecraft") || id.func_110624_b().equals("brigadier"));
        });
        return new SCommandListPacket(newRoot);
    }

    protected void encode(ChannelHandlerContext ctx, IPacket<?> msg, List<Object> out) {
        Function<IPacket<?>, IPacket<?>> function = handlers.getOrDefault(msg.getClass(), Function.identity());
        out.add(function.apply(msg));
    }
}

