/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.ArrayUtils;

public class HeaderIndex {
    private String[] positionToHeader = new String[0];
    private MultiValuedMap<String, Integer> headerToPosition = new ArrayListValuedHashMap();

    public void clear() {
        this.positionToHeader = new String[0];
        this.headerToPosition.clear();
    }

    public int findMaxIndex() {
        return this.positionToHeader.length - 1;
    }

    public void initializeHeaderIndex(String[] header) {
        this.positionToHeader = header != null ? (String[])ArrayUtils.clone((Object[])header) : new String[]{};
        this.headerToPosition.clear();
        for (int i = 0; i < this.positionToHeader.length; ++i) {
            this.headerToPosition.put((Object)header[i], (Object)i);
        }
    }

    public boolean isEmpty() {
        return this.positionToHeader.length == 0;
    }

    public int[] getByName(String headerName) {
        Collection positions = this.headerToPosition.get((Object)headerName);
        if (positions != null) {
            return ArrayUtils.toPrimitive((Integer[])positions.toArray(new Integer[positions.size()]));
        }
        return new int[0];
    }

    public String getByPosition(int i) {
        if (i < this.positionToHeader.length) {
            return this.positionToHeader[i];
        }
        return null;
    }

    public String[] getHeaderIndex() {
        return (String[])ArrayUtils.clone((Object[])this.positionToHeader);
    }

    public int getHeaderIndexLength() {
        return this.positionToHeader.length;
    }

    public void put(int k, String v) {
        if (k >= this.positionToHeader.length) {
            this.positionToHeader = Arrays.copyOf(this.positionToHeader, k + 1);
            this.positionToHeader[k] = v;
        }
        this.headerToPosition.put((Object)v, (Object)k);
    }
}

