/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.javafmlmod;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.forgespi.language.ILifecycleEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class FMLJavaModLanguageProvider
implements IModLanguageProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Type MODANNOTATION = Type.getType((String)"Lnet/minecraftforge/fml/common/Mod;");

    public String name() {
        return "javafml";
    }

    public Consumer<ModFileScanData> getFileVisitor() {
        return scanResult -> {
            Map modTargetMap = scanResult.getAnnotations().stream().filter(ad -> ad.getAnnotationType().equals((Object)MODANNOTATION)).peek(ad -> LOGGER.debug(Logging.SCAN, "Found @Mod class {} with id {}", (Object)ad.getClassType().getClassName(), ad.getAnnotationData().get("value"))).map(ad -> new FMLModTarget(ad.getClassType().getClassName(), (String)ad.getAnnotationData().get("value"))).collect(Collectors.toMap(FMLModTarget::getModId, Function.identity(), (a, b) -> a));
            scanResult.addLanguageLoader(modTargetMap);
        };
    }

    public <R extends ILifecycleEvent<R>> void consumeLifecycleEvent(Supplier<R> consumeEvent) {
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    private static class FMLModTarget
    implements IModLanguageProvider.IModLanguageLoader {
        private static final Logger LOGGER = FMLJavaModLanguageProvider.access$000();
        private final String className;
        private final String modId;

        private FMLModTarget(String className, String modId) {
            this.className = className;
            this.modId = modId;
        }

        public String getModId() {
            return this.modId;
        }

        public <T> T loadMod(IModInfo info, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
            try {
                Class<?> fmlContainer = Class.forName("net.minecraftforge.fml.javafmlmod.FMLModContainer", true, Thread.currentThread().getContextClassLoader());
                LOGGER.debug(Logging.LOADING, "Loading FMLModContainer from classloader {} - got {}", (Object)Thread.currentThread().getContextClassLoader(), (Object)fmlContainer.getClassLoader());
                Constructor<?> constructor = fmlContainer.getConstructor(IModInfo.class, String.class, ClassLoader.class, ModFileScanData.class);
                return (T)constructor.newInstance(info, this.className, modClassLoader, modFileScanResults);
            }
            catch (InvocationTargetException e) {
                LOGGER.fatal(Logging.LOADING, "Failed to build mod", (Throwable)e);
                Class mle = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingException", true, Thread.currentThread().getContextClassLoader()));
                if (mle.isInstance(e.getTargetException())) {
                    throw (RuntimeException)mle.cast(e.getTargetException());
                }
                Class mls = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingStage", true, Thread.currentThread().getContextClassLoader()));
                throw (RuntimeException)LamdbaExceptionUtils.uncheck(() -> (RuntimeException)((Constructor)LamdbaExceptionUtils.uncheck(() -> mle.getConstructor(IModInfo.class, mls, String.class, Throwable.class))).newInstance(info, Enum.valueOf(mls, "CONSTRUCT"), "fml.modloading.failedtoloadmodclass", e));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                LOGGER.fatal(Logging.LOADING, "Unable to load FMLModContainer, wut?", (Throwable)e);
                Class mle = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingException", true, Thread.currentThread().getContextClassLoader()));
                Class mls = (Class)LamdbaExceptionUtils.uncheck(() -> Class.forName("net.minecraftforge.fml.ModLoadingStage", true, Thread.currentThread().getContextClassLoader()));
                throw (RuntimeException)LamdbaExceptionUtils.uncheck(() -> (RuntimeException)((Constructor)LamdbaExceptionUtils.uncheck(() -> mle.getConstructor(IModInfo.class, mls, String.class, Throwable.class))).newInstance(info, Enum.valueOf(mls, "CONSTRUCT"), "fml.modloading.failedtoloadmodclass", e));
            }
        }
    }
}

