/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.inventory.IClearable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType field_198689_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.setblock.failed"));

    public static void func_198684_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("setblock").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a("pos", BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("block", BlockStateArgument.func_197239_a()).executes(commandContext -> SetBlockCommand.func_198683_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, null))).then(Commands.func_197057_a("destroy").executes(commandContext -> SetBlockCommand.func_198683_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.DESTROY, null)))).then(Commands.func_197057_a("keep").executes(commandContext -> SetBlockCommand.func_198683_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, cachedBlockInfo -> cachedBlockInfo.func_196960_c().func_175623_d(cachedBlockInfo.func_177508_d()))))).then(Commands.func_197057_a("replace").executes(commandContext -> SetBlockCommand.func_198683_a((CommandSource)commandContext.getSource(), BlockPosArgument.func_197273_a((CommandContext<CommandSource>)commandContext, "pos"), BlockStateArgument.func_197238_a((CommandContext<CommandSource>)commandContext, "block"), Mode.REPLACE, null))))));
    }

    private static int func_198683_a(CommandSource commandSource, BlockPos blockPos, BlockStateInput blockStateInput, Mode mode, @Nullable Predicate<CachedBlockInfo> predicate) throws CommandSyntaxException {
        boolean \u26033;
        ServerWorld serverWorld = commandSource.func_197023_e();
        if (predicate != null && !predicate.test(new CachedBlockInfo(serverWorld, blockPos, true))) {
            throw field_198689_a.create();
        }
        if (mode == Mode.DESTROY) {
            serverWorld.func_175655_b(blockPos, true);
            \u26033 = !blockStateInput.func_197231_a().func_196958_f() || !serverWorld.func_180495_p(blockPos).func_196958_f();
        } else {
            TileEntity \u26032 = serverWorld.func_175625_s(blockPos);
            IClearable.func_213131_a(\u26032);
            \u26033 = true;
        }
        if (\u26033 && !blockStateInput.func_197230_a(serverWorld, blockPos, 2)) {
            throw field_198689_a.create();
        }
        serverWorld.func_230547_a_(blockPos, blockStateInput.func_197231_a().func_177230_c());
        commandSource.func_197030_a(new TranslationTextComponent("commands.setblock.success", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), true);
        return 1;
    }

    public static interface IFilter {
        @Nullable
        public BlockStateInput filter(MutableBoundingBox var1, BlockPos var2, BlockStateInput var3, ServerWorld var4);
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }
}

