/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import java.util.Set;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExplorationMap
extends LootFunction {
    private static final Logger field_204317_a = LogManager.getLogger();
    public static final Structure<?> field_237425_a_ = Structure.field_236380_p_;
    public static final MapDecoration.Type field_215910_a = MapDecoration.Type.MANSION;
    private final Structure<?> field_204318_b;
    private final MapDecoration.Type field_204319_c;
    private final byte field_204320_d;
    private final int field_204321_e;
    private final boolean field_212428_f;

    private ExplorationMap(ILootCondition[] iLootConditionArray, Structure<?> structure, MapDecoration.Type type, byte by, int n, boolean bl) {
        super(iLootConditionArray);
        this.field_204318_b = structure;
        this.field_204319_c = type;
        this.field_204320_d = by;
        this.field_204321_e = n;
        this.field_212428_f = bl;
    }

    @Override
    public LootFunctionType func_230425_b_() {
        return LootFunctionManager.field_237438_k_;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_237457_g_);
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack2, LootContext lootContext) {
        ItemStack itemStack2;
        if (itemStack2.func_77973_b() != Items.field_151148_bJ) {
            return itemStack2;
        }
        Vector3d vector3d = lootContext.func_216031_c(LootParameters.field_237457_g_);
        if (vector3d != null && (\u2603 = (\u2603 = lootContext.func_202879_g()).func_241117_a_(this.field_204318_b, new BlockPos(vector3d), this.field_204321_e, this.field_212428_f)) != null) {
            ItemStack itemStack3 = FilledMapItem.func_195952_a(\u2603, \u2603.func_177958_n(), \u2603.func_177952_p(), this.field_204320_d, true, true);
            FilledMapItem.func_226642_a_(\u2603, itemStack3);
            MapData.func_191094_a(itemStack3, \u2603, "+", this.field_204319_c);
            itemStack3.func_200302_a(new TranslationTextComponent("filled_map." + this.field_204318_b.func_143025_a().toLowerCase(Locale.ROOT)));
            return itemStack3;
        }
        return itemStack2;
    }

    public static Builder func_215903_b() {
        return new Builder();
    }

    public static class Serializer
    extends LootFunction.Serializer<ExplorationMap> {
        @Override
        public void func_230424_a_(JsonObject jsonObject, ExplorationMap explorationMap, JsonSerializationContext jsonSerializationContext) {
            super.func_230424_a_(jsonObject, explorationMap, jsonSerializationContext);
            if (!explorationMap.field_204318_b.equals(field_237425_a_)) {
                jsonObject.add("destination", jsonSerializationContext.serialize((Object)explorationMap.field_204318_b.func_143025_a()));
            }
            if (explorationMap.field_204319_c != field_215910_a) {
                jsonObject.add("decoration", jsonSerializationContext.serialize((Object)explorationMap.field_204319_c.toString().toLowerCase(Locale.ROOT)));
            }
            if (explorationMap.field_204320_d != 2) {
                jsonObject.addProperty("zoom", (Number)explorationMap.field_204320_d);
            }
            if (explorationMap.field_204321_e != 50) {
                jsonObject.addProperty("search_radius", (Number)explorationMap.field_204321_e);
            }
            if (!explorationMap.field_212428_f) {
                jsonObject.addProperty("skip_existing_chunks", Boolean.valueOf(explorationMap.field_212428_f));
            }
        }

        @Override
        public ExplorationMap func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            Structure<?> structure = Serializer.func_237428_a_(jsonObject);
            String \u26032 = jsonObject.has("decoration") ? JSONUtils.func_151200_h(jsonObject, "decoration") : "mansion";
            MapDecoration.Type \u26033 = field_215910_a;
            try {
                \u26033 = MapDecoration.Type.valueOf(\u26032.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException \u26034) {
                field_204317_a.error("Error while parsing loot table decoration entry. Found {}. Defaulting to " + (Object)((Object)field_215910_a), (Object)\u26032);
            }
            byte \u26035 = JSONUtils.func_219795_a(jsonObject, "zoom", (byte)2);
            int \u26036 = JSONUtils.func_151208_a(jsonObject, "search_radius", 50);
            boolean \u26037 = JSONUtils.func_151209_a(jsonObject, "skip_existing_chunks", true);
            return new ExplorationMap(iLootConditionArray, structure, \u26033, \u26035, \u26036, \u26037);
        }

        private static Structure<?> func_237428_a_(JsonObject jsonObject) {
            if (jsonObject.has("destination") && (\u2603 = (Structure)Structure.field_236365_a_.get((Object)(\u2603 = JSONUtils.func_151200_h(jsonObject, "destination")).toLowerCase(Locale.ROOT))) != null) {
                return \u2603;
            }
            return field_237425_a_;
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private Structure<?> field_216066_a = field_237425_a_;
        private MapDecoration.Type field_216067_b = field_215910_a;
        private byte field_216068_c = (byte)2;
        private int field_216069_d = 50;
        private boolean field_216070_e = true;

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_237427_a_(Structure<?> structure) {
            this.field_216066_a = structure;
            return this;
        }

        public Builder func_216064_a(MapDecoration.Type type) {
            this.field_216067_b = type;
            return this;
        }

        public Builder func_216062_a(byte by) {
            this.field_216068_c = by;
            return this;
        }

        public Builder func_216063_a(boolean bl) {
            this.field_216070_e = bl;
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new ExplorationMap(this.func_216053_g(), this.field_216066_a, this.field_216067_b, this.field_216068_c, this.field_216069_d, this.field_216070_e);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }
}

