/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum TextFormatting {
    BLACK("BLACK", '0', 0, 0),
    DARK_BLUE("DARK_BLUE", '1', 1, 170),
    DARK_GREEN("DARK_GREEN", '2', 2, 43520),
    DARK_AQUA("DARK_AQUA", '3', 3, 43690),
    DARK_RED("DARK_RED", '4', 4, 0xAA0000),
    DARK_PURPLE("DARK_PURPLE", '5', 5, 0xAA00AA),
    GOLD("GOLD", '6', 6, 0xFFAA00),
    GRAY("GRAY", '7', 7, 0xAAAAAA),
    DARK_GRAY("DARK_GRAY", '8', 8, 0x555555),
    BLUE("BLUE", '9', 9, 0x5555FF),
    GREEN("GREEN", 'a', 10, 0x55FF55),
    AQUA("AQUA", 'b', 11, 0x55FFFF),
    RED("RED", 'c', 12, 0xFF5555),
    LIGHT_PURPLE("LIGHT_PURPLE", 'd', 13, 0xFF55FF),
    YELLOW("YELLOW", 'e', 14, 0xFFFF55),
    WHITE("WHITE", 'f', 15, 0xFFFFFF),
    OBFUSCATED("OBFUSCATED", 'k', true),
    BOLD("BOLD", 'l', true),
    STRIKETHROUGH("STRIKETHROUGH", 'm', true),
    UNDERLINE("UNDERLINE", 'n', true),
    ITALIC("ITALIC", 'o', true),
    RESET("RESET", 'r', -1, null);

    private static final Map<String, TextFormatting> field_96331_x;
    private static final Pattern field_96330_y;
    private final String field_175748_y;
    private final char field_96329_z;
    private final boolean field_96303_A;
    private final String field_96304_B;
    private final int field_175747_C;
    @Nullable
    private final Integer field_211167_D;

    private static String func_175745_c(String string) {
        return string.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private TextFormatting(String string2, char c, int n2, @Nullable Integer n3) {
        this(string2, c, false, n2, n3);
    }

    private TextFormatting(String string2, char c, boolean bl) {
        this(string2, c, bl, -1, null);
    }

    private TextFormatting(String string2, char c, boolean bl, int n2, @Nullable Integer n3) {
        this.field_175748_y = string2;
        this.field_96329_z = c;
        this.field_96303_A = bl;
        this.field_175747_C = n2;
        this.field_211167_D = n3;
        this.field_96304_B = "\u00a7" + c;
    }

    public int func_175746_b() {
        return this.field_175747_C;
    }

    public boolean func_96301_b() {
        return this.field_96303_A;
    }

    public boolean func_96302_c() {
        return !this.field_96303_A && this != RESET;
    }

    @Nullable
    public Integer func_211163_e() {
        return this.field_211167_D;
    }

    public String func_96297_d() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.field_96304_B;
    }

    @Nullable
    public static String func_110646_a(@Nullable String string) {
        return string == null ? null : field_96330_y.matcher(string).replaceAll("");
    }

    @Nullable
    public static TextFormatting func_96300_b(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return field_96331_x.get(TextFormatting.func_175745_c(string));
    }

    @Nullable
    public static TextFormatting func_175744_a(int n) {
        if (n < 0) {
            return RESET;
        }
        for (TextFormatting textFormatting : TextFormatting.values()) {
            if (textFormatting.func_175746_b() != n) continue;
            return textFormatting;
        }
        return null;
    }

    public static Collection<String> func_96296_a(boolean bl, boolean bl2) {
        ArrayList arrayList = Lists.newArrayList();
        for (TextFormatting textFormatting : TextFormatting.values()) {
            if (textFormatting.func_96302_c() && !bl || textFormatting.func_96301_b() && !bl2) continue;
            arrayList.add(textFormatting.func_96297_d());
        }
        return arrayList;
    }

    static {
        field_96331_x = Arrays.stream(TextFormatting.values()).collect(Collectors.toMap(textFormatting -> TextFormatting.func_175745_c(textFormatting.field_175748_y), textFormatting -> textFormatting));
        field_96330_y = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

