/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.gen.feature.structure.Structure;

public abstract class BiomeProvider
implements BiomeManager.IBiomeReader {
    public static final Codec<BiomeProvider> field_235202_a_;
    protected final Map<Structure<?>, Boolean> field_205005_a = Maps.newHashMap();
    protected final Set<BlockState> field_205707_b = Sets.newHashSet();
    protected final List<Biome> field_226837_c_;

    protected BiomeProvider(Stream<Supplier<Biome>> stream) {
        this((List)stream.map(Supplier::get).collect(ImmutableList.toImmutableList()));
    }

    protected BiomeProvider(List<Biome> list) {
        this.field_226837_c_ = list;
    }

    protected abstract Codec<? extends BiomeProvider> func_230319_a_();

    public List<Biome> func_235203_c_() {
        return this.field_226837_c_;
    }

    public Set<Biome> func_225530_a_(int n, int n2, int n3, int n4) {
        \u2603 = n - n4 >> 2;
        \u2603 = n2 - n4 >> 2;
        \u2603 = n3 - n4 >> 2;
        \u2603 = n + n4 >> 2;
        \u2603 = n2 + n4 >> 2;
        \u2603 = n3 + n4 >> 2;
        \u2603 = \u2603 - \u2603 + 1;
        \u2603 = \u2603 - \u2603 + 1;
        \u2603 = \u2603 - \u2603 + 1;
        HashSet hashSet = Sets.newHashSet();
        for (int i = 0; i < \u2603; ++i) {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                    \u2603 = \u2603 + \u2603;
                    \u2603 = \u2603 + \u2603;
                    \u2603 = \u2603 + i;
                    hashSet.add(this.func_225526_b_(\u2603, \u2603, \u2603));
                }
            }
        }
        return hashSet;
    }

    @Nullable
    public BlockPos func_225531_a_(int n, int n2, int n3, int n4, Predicate<Biome> predicate, Random random) {
        return this.func_230321_a_(n, n2, n3, n4, 1, predicate, random, false);
    }

    @Nullable
    public BlockPos func_230321_a_(int n, int n2, int n3, int n4, int n5, Predicate<Biome> predicate, Random random, boolean bl) {
        int n6 = n >> 2;
        \u2603 = n3 >> 2;
        \u2603 = n4 >> 2;
        \u2603 = n2 >> 2;
        BlockPos \u26032 = null;
        \u2603 = 0;
        for (\u2603 = \u2603 = bl ? 0 : \u2603; \u2603 <= \u2603; \u2603 += n5) {
            for (\u2603 = -\u2603; \u2603 <= \u2603; \u2603 += n5) {
                boolean bl2 = Math.abs(\u2603) == \u2603;
                for (int i = -\u2603; i <= \u2603; i += n5) {
                    if (bl) {
                        int n7 = \u2603 = Math.abs(i) == \u2603 ? 1 : 0;
                        if (\u2603 == 0 && !bl2) continue;
                    }
                    if (!predicate.test(this.func_225526_b_(\u2603 = n6 + i, \u2603, \u2603 = \u2603 + \u2603))) continue;
                    if (\u26032 == null || random.nextInt(\u2603 + 1) == 0) {
                        \u26032 = new BlockPos(\u2603 << 2, n2, \u2603 << 2);
                        if (bl) {
                            return \u26032;
                        }
                    }
                    ++\u2603;
                }
            }
        }
        return \u26032;
    }

    public boolean func_205004_a(Structure<?> structure2) {
        return this.field_205005_a.computeIfAbsent(structure2, structure -> this.field_226837_c_.stream().anyMatch(biome -> biome.func_242440_e().func_242493_a((Structure<?>)structure)));
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.field_226837_c_) {
                this.field_205707_b.add(biome.func_242440_e().func_242502_e().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    static {
        Registry.func_218325_a(Registry.field_239689_aA_, "fixed", SingleBiomeProvider.field_235260_e_);
        Registry.func_218325_a(Registry.field_239689_aA_, "multi_noise", NetherBiomeProvider.field_235263_f_);
        Registry.func_218325_a(Registry.field_239689_aA_, "checkerboard", CheckerboardBiomeProvider.field_235255_e_);
        Registry.func_218325_a(Registry.field_239689_aA_, "vanilla_layered", OverworldBiomeProvider.field_235297_e_);
        Registry.func_218325_a(Registry.field_239689_aA_, "the_end", EndBiomeProvider.field_235314_e_);
        field_235202_a_ = Registry.field_239689_aA_.dispatchStable(BiomeProvider::func_230319_a_, Function.identity());
    }
}

