/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.state.BooleanProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlackStoneReplacementProcessor;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.BlockMosinessProcessor;
import net.minecraft.world.gen.feature.template.LavaSubmergingProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final Logger field_237003_d_ = LogManager.getLogger();
    private final ResourceLocation field_237004_e_;
    private final Rotation field_237005_f_;
    private final Mirror field_237006_g_;
    private final Location field_237007_h_;
    private final Serializer field_237008_i_;

    public RuinedPortalPiece(BlockPos blockPos, Location location, Serializer serializer, ResourceLocation resourceLocation, Template template, Rotation rotation, Mirror mirror, BlockPos blockPos2) {
        super(IStructurePieceType.field_236399_L_, 0);
        this.field_186178_c = blockPos;
        this.field_237004_e_ = resourceLocation;
        this.field_237005_f_ = rotation;
        this.field_237006_g_ = mirror;
        this.field_237007_h_ = location;
        this.field_237008_i_ = serializer;
        this.func_237014_a_(template, blockPos2);
    }

    public RuinedPortalPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(IStructurePieceType.field_236399_L_, compoundNBT);
        this.field_237004_e_ = new ResourceLocation(compoundNBT.func_74779_i("Template"));
        this.field_237005_f_ = Rotation.valueOf(compoundNBT.func_74779_i("Rotation"));
        this.field_237006_g_ = Mirror.valueOf(compoundNBT.func_74779_i("Mirror"));
        this.field_237007_h_ = Location.func_237042_a_(compoundNBT.func_74779_i("VerticalPlacement"));
        this.field_237008_i_ = (Serializer)Serializer.field_237024_a_.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT.func_74781_a("Properties"))).getOrThrow(true, arg_0 -> ((Logger)field_237003_d_).error(arg_0));
        Template template = templateManager.func_200220_a(this.field_237004_e_);
        this.func_237014_a_(template, new BlockPos(template.func_186259_a().func_177958_n() / 2, 0, template.func_186259_a().func_177952_p() / 2));
    }

    @Override
    protected void func_143011_b(CompoundNBT compoundNBT) {
        super.func_143011_b(compoundNBT);
        compoundNBT.func_74778_a("Template", this.field_237004_e_.toString());
        compoundNBT.func_74778_a("Rotation", this.field_237005_f_.name());
        compoundNBT.func_74778_a("Mirror", this.field_237006_g_.name());
        compoundNBT.func_74778_a("VerticalPlacement", this.field_237007_h_.func_237040_a_());
        Serializer.field_237024_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_237008_i_).resultOrPartial(arg_0 -> ((Logger)field_237003_d_).error(arg_0)).ifPresent(iNBT -> compoundNBT.func_218657_a("Properties", (INBT)iNBT));
    }

    private void func_237014_a_(Template template, BlockPos blockPos) {
        BlockIgnoreStructureProcessor blockIgnoreStructureProcessor = this.field_237008_i_.field_237027_d_ ? BlockIgnoreStructureProcessor.field_215204_a : BlockIgnoreStructureProcessor.field_215206_c;
        ArrayList \u26032 = Lists.newArrayList();
        \u26032.add(RuinedPortalPiece.func_237011_a_(Blocks.field_150340_R, 0.3f, Blocks.field_150350_a));
        \u26032.add(this.func_237021_c_());
        if (!this.field_237008_i_.field_237025_b_) {
            \u26032.add(RuinedPortalPiece.func_237011_a_(Blocks.field_150424_aL, 0.07f, Blocks.field_196814_hQ));
        }
        PlacementSettings \u26033 = new PlacementSettings().func_186220_a(this.field_237005_f_).func_186214_a(this.field_237006_g_).func_207665_a(blockPos).func_215222_a(blockIgnoreStructureProcessor).func_215222_a(new RuleStructureProcessor(\u26032)).func_215222_a(new BlockMosinessProcessor(this.field_237008_i_.field_237026_c_)).func_215222_a(new LavaSubmergingProcessor());
        if (this.field_237008_i_.field_237030_g_) {
            \u26033.func_215222_a(BlackStoneReplacementProcessor.field_237058_b_);
        }
        this.func_186173_a(template, this.field_186178_c, \u26033);
    }

    private RuleEntry func_237021_c_() {
        if (this.field_237007_h_ == Location.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.func_237012_a_(Blocks.field_150353_l, Blocks.field_196814_hQ);
        }
        if (this.field_237008_i_.field_237025_b_) {
            return RuinedPortalPiece.func_237012_a_(Blocks.field_150353_l, Blocks.field_150424_aL);
        }
        return RuinedPortalPiece.func_237011_a_(Blocks.field_150353_l, 0.2f, Blocks.field_196814_hQ);
    }

    @Override
    public boolean func_230383_a_(ISeedReader iSeedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos, BlockPos blockPos2) {
        if (!mutableBoundingBox.func_175898_b(this.field_186178_c)) {
            return true;
        }
        mutableBoundingBox.func_78888_b(this.field_186176_a.func_215388_b(this.field_186177_b, this.field_186178_c));
        boolean bl = super.func_230383_a_(iSeedReader, structureManager, chunkGenerator, random, mutableBoundingBox, chunkPos, blockPos2);
        this.func_237019_b_(random, iSeedReader);
        this.func_237015_a_(random, iSeedReader);
        if (this.field_237008_i_.field_237029_f_ || this.field_237008_i_.field_237028_e_) {
            BlockPos.func_229383_a_(this.func_74874_b()).forEach(blockPos -> {
                if (this.field_237008_i_.field_237029_f_) {
                    this.func_237016_a_(random, iSeedReader, (BlockPos)blockPos);
                }
                if (this.field_237008_i_.field_237028_e_) {
                    this.func_237020_b_(random, iSeedReader, (BlockPos)blockPos);
                }
            });
        }
        return bl;
    }

    @Override
    protected void func_186175_a(String string, BlockPos blockPos, IServerWorld iServerWorld, Random random, MutableBoundingBox mutableBoundingBox) {
    }

    private void func_237016_a_(Random random, IWorld iWorld, BlockPos blockPos) {
        BlockState blockState = iWorld.func_180495_p(blockPos);
        if (blockState.func_196958_f() || blockState.func_203425_a(Blocks.field_150395_bd)) {
            return;
        }
        Direction \u26032 = Direction.Plane.HORIZONTAL.func_179518_a(random);
        BlockPos \u26033 = blockPos.func_177972_a(\u26032);
        \u2603 = iWorld.func_180495_p(\u26033);
        if (!\u2603.func_196958_f()) {
            return;
        }
        if (!Block.func_208061_a(blockState.func_196952_d(iWorld, blockPos), \u26032)) {
            return;
        }
        BooleanProperty \u26034 = VineBlock.func_176267_a(\u26032.func_176734_d());
        iWorld.func_180501_a(\u26033, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a(\u26034, true), 3);
    }

    private void func_237020_b_(Random random, IWorld iWorld, BlockPos blockPos) {
        if (random.nextFloat() < 0.5f && iWorld.func_180495_p(blockPos).func_203425_a(Blocks.field_150424_aL) && iWorld.func_180495_p(blockPos.func_177984_a()).func_196958_f()) {
            iWorld.func_180501_a(blockPos.func_177984_a(), (BlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a(LeavesBlock.field_208495_b, true), 3);
        }
    }

    private void func_237015_a_(Random random, IWorld iWorld) {
        for (int i = this.field_74887_e.field_78897_a + 1; i < this.field_74887_e.field_78893_d; ++i) {
            for (\u2603 = this.field_74887_e.field_78896_c + 1; \u2603 < this.field_74887_e.field_78892_f; ++\u2603) {
                BlockPos blockPos = new BlockPos(i, this.field_74887_e.field_78895_b, \u2603);
                if (!iWorld.func_180495_p(blockPos).func_203425_a(Blocks.field_150424_aL)) continue;
                this.func_237022_c_(random, iWorld, blockPos.func_177977_b());
            }
        }
    }

    private void func_237022_c_(Random random, IWorld iWorld, BlockPos blockPos) {
        BlockPos.Mutable mutable = blockPos.func_239590_i_();
        this.func_237023_d_(random, iWorld, mutable);
        for (int i = 8; i > 0 && random.nextFloat() < 0.5f; --i) {
            mutable.func_189536_c(Direction.DOWN);
            this.func_237023_d_(random, iWorld, mutable);
        }
    }

    private void func_237019_b_(Random random, IWorld iWorld) {
        boolean bl = this.field_237007_h_ == Location.ON_LAND_SURFACE || this.field_237007_h_ == Location.ON_OCEAN_FLOOR;
        Vector3i \u26032 = this.field_74887_e.func_215126_f();
        int \u26033 = \u26032.func_177958_n();
        int \u26034 = \u26032.func_177952_p();
        float[] \u26035 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int \u26036 = \u26035.length;
        int \u26037 = (this.field_74887_e.func_78883_b() + this.field_74887_e.func_78880_d()) / 2;
        int \u26038 = random.nextInt(Math.max(1, 8 - \u26037 / 2));
        int \u26039 = 3;
        BlockPos.Mutable \u260310 = BlockPos.field_177992_a.func_239590_i_();
        for (int i = \u26033 - \u26036; i <= \u26033 + \u26036; ++i) {
            for (\u2603 = \u26034 - \u26036; \u2603 <= \u26034 + \u26036; ++\u2603) {
                \u2603 = Math.abs(i - \u26033) + Math.abs(\u2603 - \u26034);
                \u2603 = Math.max(0, \u2603 + \u26038);
                if (\u2603 >= \u26036) continue;
                float f = \u26035[\u2603];
                if (!(random.nextDouble() < (double)f)) continue;
                int \u260311 = RuinedPortalPiece.func_237009_a_(iWorld, i, \u2603, this.field_237007_h_);
                int \u260312 = bl ? \u260311 : Math.min(this.field_74887_e.field_78895_b, \u260311);
                \u260310.func_181079_c(i, \u260312, \u2603);
                if (Math.abs(\u260312 - this.field_74887_e.field_78895_b) > 3 || !this.func_237010_a_(iWorld, \u260310)) continue;
                this.func_237023_d_(random, iWorld, \u260310);
                if (this.field_237008_i_.field_237028_e_) {
                    this.func_237020_b_(random, iWorld, \u260310);
                }
                this.func_237022_c_(random, iWorld, (BlockPos)\u260310.func_177977_b());
            }
        }
    }

    private boolean func_237010_a_(IWorld iWorld, BlockPos blockPos) {
        BlockState blockState = iWorld.func_180495_p(blockPos);
        return !blockState.func_203425_a(Blocks.field_150350_a) && !blockState.func_203425_a(Blocks.field_150343_Z) && !blockState.func_203425_a(Blocks.field_150486_ae) && (this.field_237007_h_ == Location.IN_NETHER || !blockState.func_203425_a(Blocks.field_150353_l));
    }

    private void func_237023_d_(Random random, IWorld iWorld, BlockPos blockPos) {
        if (!this.field_237008_i_.field_237025_b_ && random.nextFloat() < 0.07f) {
            iWorld.func_180501_a(blockPos, Blocks.field_196814_hQ.func_176223_P(), 3);
        } else {
            iWorld.func_180501_a(blockPos, Blocks.field_150424_aL.func_176223_P(), 3);
        }
    }

    private static int func_237009_a_(IWorld iWorld, int n, int n2, Location location) {
        return iWorld.func_201676_a(RuinedPortalPiece.func_237013_a_(location), n, n2) - 1;
    }

    public static Heightmap.Type func_237013_a_(Location location) {
        return location == Location.ON_OCEAN_FLOOR ? Heightmap.Type.OCEAN_FLOOR_WG : Heightmap.Type.WORLD_SURFACE_WG;
    }

    private static RuleEntry func_237011_a_(Block block, float f, Block block2) {
        return new RuleEntry(new RandomBlockMatchRuleTest(block, f), AlwaysTrueRuleTest.field_215190_a, block2.func_176223_P());
    }

    private static RuleEntry func_237012_a_(Block block, Block block2) {
        return new RuleEntry(new BlockMatchRuleTest(block), AlwaysTrueRuleTest.field_215190_a, block2.func_176223_P());
    }

    public static enum Location {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor"),
        IN_MOUNTAIN("in_mountain"),
        UNDERGROUND("underground"),
        IN_NETHER("in_nether");

        private static final Map<String, Location> field_237038_g_;
        private final String field_237039_h_;

        private Location(String string2) {
            this.field_237039_h_ = string2;
        }

        public String func_237040_a_() {
            return this.field_237039_h_;
        }

        public static Location func_237042_a_(String string) {
            return field_237038_g_.get(string);
        }

        static {
            field_237038_g_ = Arrays.stream(Location.values()).collect(Collectors.toMap(Location::func_237040_a_, location -> location));
        }
    }

    public static class Serializer {
        public static final Codec<Serializer> field_237024_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cold").forGetter(serializer -> serializer.field_237025_b_), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(serializer -> Float.valueOf(serializer.field_237026_c_)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(serializer -> serializer.field_237027_d_), (App)Codec.BOOL.fieldOf("overgrown").forGetter(serializer -> serializer.field_237028_e_), (App)Codec.BOOL.fieldOf("vines").forGetter(serializer -> serializer.field_237029_f_), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(serializer -> serializer.field_237030_g_)).apply((Applicative)instance, Serializer::new));
        public boolean field_237025_b_;
        public float field_237026_c_ = 0.2f;
        public boolean field_237027_d_;
        public boolean field_237028_e_;
        public boolean field_237029_f_;
        public boolean field_237030_g_;

        public Serializer() {
        }

        public <T> Serializer(boolean bl, float f, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.field_237025_b_ = bl;
            this.field_237026_c_ = f;
            this.field_237027_d_ = bl2;
            this.field_237028_e_ = bl3;
            this.field_237029_f_ = bl4;
            this.field_237030_g_ = bl5;
        }
    }
}

