/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import cpw.mods.gross.Java9ClassLoaderUtil;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.loading.ModSorter;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.BackgroundScanHandler;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModsFolderLocator;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ModDiscoverer {
    private static final Path INVALID_PATH = Paths.get("This", "Path", "Should", "Never", "Exist", "Because", "That", "Would", "Be", "Stupid", "CON", "AUX", "/dev/null");
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServiceLoader<IModLocator> locators;
    private final List<IModLocator> locatorList;
    private final LocatorClassLoader locatorClassLoader;

    public ModDiscoverer(Map<String, ?> arguments) {
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODFOLDERFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODDIRECTORYFACTORY.get(), v -> ModsFolderLocator::new);
        Launcher.INSTANCE.environment().computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.PROGRESSMESSAGE.get(), v -> StartupMessageManager.locatorConsumer().orElseGet(() -> s -> {}));
        this.locatorClassLoader = new LocatorClassLoader();
        Launcher.INSTANCE.environment().computePropertyIfAbsent(FMLEnvironment.Keys.LOCATORCLASSLOADER.get(), v -> this.locatorClassLoader);
        ModDirTransformerDiscoverer.getExtraLocators().stream().map(LamdbaExceptionUtils.rethrowFunction(p -> p.toUri().toURL())).forEach(this.locatorClassLoader::addURL);
        this.locators = ServiceLoader.load(IModLocator.class, this.locatorClassLoader);
        this.locatorList = ServiceLoaderStreamUtils.toList(this.locators);
        this.locatorList.forEach(l -> l.initArguments(arguments));
        this.locatorList.add(new MinecraftLocator());
        LOGGER.debug(LogMarkers.CORE, "Found Mod Locators : {}", new Supplier[]{() -> this.locatorList.stream().map(iModLocator -> "(" + iModLocator.name() + ":" + iModLocator.getClass().getPackage().getImplementationVersion() + ")").collect(Collectors.joining(","))});
    }

    ModDiscoverer(List<IModLocator> locatorList) {
        this.locatorList = locatorList;
        this.locatorClassLoader = null;
        this.locators = null;
    }

    public BackgroundScanHandler discoverMods() {
        LOGGER.debug(LogMarkers.SCAN, "Scanning for mods and other resources to load. We know {} ways to find mods", (Object)this.locatorList.size());
        Map<IModFile.Type, List<ModFile>> modFiles = this.locatorList.stream().peek(loc -> LOGGER.debug(LogMarkers.SCAN, "Trying locator {}", loc)).map(IModLocator::scanMods).flatMap(Collection::stream).peek(mf -> LOGGER.debug(LogMarkers.SCAN, "Found mod file {} of type {} with locator {}", (Object)mf.getFileName(), (Object)mf.getType(), (Object)mf.getLocator())).peek(mf -> StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Found mod file " + mf.getFileName() + " of type " + mf.getType()))).map(ModFile.class::cast).collect(Collectors.groupingBy(IModFile::getType));
        FMLLoader.getLanguageLoadingProvider().addAdditionalLanguages(modFiles.get(IModFile.Type.LANGPROVIDER));
        BackgroundScanHandler backgroundScanHandler = new BackgroundScanHandler(modFiles);
        List<ModFile> mods = modFiles.getOrDefault(IModFile.Type.MOD, Collections.emptyList());
        ArrayList<ModFile> brokenFiles = new ArrayList<ModFile>();
        Iterator iterator = mods.iterator();
        while (iterator.hasNext()) {
            ModFile mod = (ModFile)iterator.next();
            if (mod.getLocator().isValid((IModFile)mod) && mod.identifyMods()) continue;
            LOGGER.warn(LogMarkers.SCAN, "File {} has been ignored - it is invalid", (Object)mod.getFilePath());
            iterator.remove();
            brokenFiles.add(mod);
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = mods::size;
        supplierArray[1] = () -> mods.stream().mapToInt(mf -> mf.getModInfos().size()).sum();
        LOGGER.debug(LogMarkers.SCAN, "Found {} mod files with {} mods", supplierArray);
        StartupMessageManager.modLoaderConsumer().ifPresent(c -> c.accept("Found " + mods.size() + " modfiles to load"));
        LoadingModList loadingModList = ModSorter.sort(mods);
        loadingModList.addCoreMods();
        loadingModList.addAccessTransformers();
        loadingModList.addForScanning(backgroundScanHandler);
        loadingModList.setBrokenFiles(brokenFiles);
        return backgroundScanHandler;
    }

    private static class MinecraftLocator
    implements IModLocator {
        private final Path mcJar = FMLLoader.getMCPaths()[0];
        private final FileSystem fileSystem;

        MinecraftLocator() {
            if (!Files.isDirectory(this.mcJar, new LinkOption[0])) {
                try {
                    this.fileSystem = FileSystems.newFileSystem(this.mcJar, this.getClass().getClassLoader());
                }
                catch (IOException | ZipError e) {
                    LOGGER.fatal(LogMarkers.SCAN, "Invalid Minecraft JAR file - no filesystem created");
                    throw new RuntimeException(e);
                }
            } else {
                this.fileSystem = null;
            }
        }

        public List<IModFile> scanMods() {
            return Collections.singletonList(ModFile.newFMLInstance(this.mcJar, this));
        }

        public String name() {
            return "minecraft";
        }

        public Path findPath(IModFile modFile, String ... path) {
            if (path.length == 2 && Objects.equals(path[0], "META-INF")) {
                if (Objects.equals(path[1], "mods.toml")) {
                    URI jarFileURI;
                    try {
                        jarFileURI = this.getClass().getClassLoader().getResource("minecraftmod.toml").toURI();
                        if (Objects.equals(jarFileURI.getScheme(), "jar")) {
                            FileSystems.newFileSystem(jarFileURI, new HashMap());
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.fatal(LogMarkers.SCAN, "Unable to read minecraft default mod");
                        throw new RuntimeException(e);
                    }
                    return Paths.get(jarFileURI);
                }
                if (Objects.equals(path[1], "coremods.json")) {
                    return INVALID_PATH;
                }
            }
            if (Files.isDirectory(this.mcJar, new LinkOption[0])) {
                return this.findPathDirectory(modFile, path);
            }
            return this.findPathJar(modFile, path);
        }

        private Path findPathDirectory(IModFile modFile, String ... path) {
            if (path.length < 1) {
                throw new IllegalArgumentException("Missing path");
            }
            Path target = Paths.get(path[0], Arrays.copyOfRange(path, 1, path.length));
            return this.mcJar.resolve(target);
        }

        private Path findPathJar(IModFile modFile, String ... path) {
            return this.fileSystem.getPath(path[0], Arrays.copyOfRange(path, 1, path.length));
        }

        public void scanFile(IModFile modFile, Consumer<Path> pathConsumer) {
            LOGGER.debug(LogMarkers.SCAN, "Scan started: {}", (Object)modFile);
            Path path = Files.isDirectory(this.mcJar, new LinkOption[0]) ? this.mcJar : this.fileSystem.getPath("/", new String[0]);
            try (Stream<Path> files = Files.find(path, Integer.MAX_VALUE, (p, a) -> p.getNameCount() > 0 && p.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);){
                files.forEach(pathConsumer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LOGGER.debug(LogMarkers.SCAN, "Scan finished: {}", (Object)modFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Pair<Optional<Manifest>, Optional<CodeSigner[]>> findManifestAndSigners(Path file) {
            if (Files.isDirectory(this.mcJar, new LinkOption[0])) {
                return Pair.of(Optional.empty(), Optional.empty());
            }
            try (JarFile jf = new JarFile(this.mcJar.toFile());){
                Manifest manifest = jf.getManifest();
                if (manifest == null) return Pair.of(Optional.empty(), Optional.empty());
                JarEntry jarEntry = jf.getJarEntry("META-INF/MANIFEST.MF");
                LamdbaExceptionUtils.uncheck(() -> AbstractJarFileLocator.ENSURE_INIT.invoke((Object)jf, new Object[0]));
                Pair pair = Pair.of(Optional.of(manifest), Optional.ofNullable(jarEntry.getCodeSigners()));
                return pair;
            }
            catch (IOException ioe) {
                return Pair.of(Optional.empty(), Optional.empty());
            }
        }

        public Optional<Manifest> findManifest(Path file) {
            return Optional.empty();
        }

        public void initArguments(Map<String, ?> arguments) {
        }

        public boolean isValid(IModFile modFile) {
            return true;
        }
    }

    private static class LocatorClassLoader
    extends URLClassLoader {
        LocatorClassLoader() {
            super(Java9ClassLoaderUtil.getSystemClassPathURLs(), LocatorClassLoader.getSystemClassLoader());
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }
    }
}

