/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Enchantment
extends ForgeRegistryEntry<Enchantment> {
    private final ReverseTagWrapper<Enchantment> reverseTags = new ReverseTagWrapper((Object)this, () -> TagCollectionManager.func_242178_a().getCustomTypeCollection(ForgeRegistries.ENCHANTMENTS));
    private final EquipmentSlotType[] field_185263_a;
    private final Rarity field_77333_a;
    public final EnchantmentType field_77351_y;
    @Nullable
    protected String field_77350_z;

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Enchantment func_185262_c(int p_185262_0_) {
        return (Enchantment)((Object)Registry.field_212628_q.func_148745_a(p_185262_0_));
    }

    protected Enchantment(Rarity p_i46731_1_, EnchantmentType p_i46731_2_, EquipmentSlotType[] p_i46731_3_) {
        this.field_77333_a = p_i46731_1_;
        this.field_77351_y = p_i46731_2_;
        this.field_185263_a = p_i46731_3_;
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public boolean isIn(ITag<Enchantment> tag) {
        return tag.func_230235_a_(this);
    }

    public Map<EquipmentSlotType, ItemStack> func_222181_a(LivingEntity p_222181_1_) {
        EnumMap map = Maps.newEnumMap(EquipmentSlotType.class);
        for (EquipmentSlotType equipmentslottype : this.field_185263_a) {
            ItemStack itemstack = p_222181_1_.func_184582_a(equipmentslottype);
            if (itemstack.func_190926_b()) continue;
            map.put(equipmentslottype, itemstack);
        }
        return map;
    }

    public Rarity func_77324_c() {
        return this.field_77333_a;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int p_77321_1_) {
        return 1 + p_77321_1_ * 10;
    }

    public int func_223551_b(int p_223551_1_) {
        return this.func_77321_a(p_223551_1_) + 5;
    }

    public int func_77318_a(int p_77318_1_, DamageSource p_77318_2_) {
        return 0;
    }

    public float func_152376_a(int p_152376_1_, CreatureAttribute p_152376_2_) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment p_191560_1_) {
        return this.func_77326_a(p_191560_1_) && p_191560_1_.func_77326_a(this);
    }

    protected boolean func_77326_a(Enchantment p_77326_1_) {
        return this != p_77326_1_;
    }

    protected String func_210771_f() {
        if (this.field_77350_z == null) {
            this.field_77350_z = Util.func_200697_a("enchantment", Registry.field_212628_q.func_177774_c(this));
        }
        return this.field_77350_z;
    }

    public String func_77320_a() {
        return this.func_210771_f();
    }

    public ITextComponent func_200305_d(int p_200305_1_) {
        TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(this.func_77320_a());
        if (this.func_190936_d()) {
            iformattabletextcomponent.func_240699_a_(TextFormatting.RED);
        } else {
            iformattabletextcomponent.func_240699_a_(TextFormatting.GRAY);
        }
        if (p_200305_1_ != 1 || this.func_77325_b() != 1) {
            iformattabletextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + p_200305_1_));
        }
        return iformattabletextcomponent;
    }

    public boolean func_92089_a(ItemStack p_92089_1_) {
        return this.canApplyAtEnchantingTable(p_92089_1_);
    }

    public void func_151368_a(LivingEntity p_151368_1_, Entity p_151368_2_, int p_151368_3_) {
    }

    public void func_151367_b(LivingEntity p_151367_1_, Entity p_151367_2_, int p_151367_3_) {
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_190936_d() {
        return false;
    }

    public boolean func_230309_h_() {
        return true;
    }

    public boolean func_230310_i_() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.canApplyAtEnchantingTable(this);
    }

    public boolean isAllowedOnBooks() {
        return true;
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int field_185275_e;

        private Rarity(int p_i47026_3_) {
            this.field_185275_e = p_i47026_3_;
        }

        public int func_185270_a() {
            return this.field_185275_e;
        }
    }
}

