/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EvokerFangsEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class EvokerEntity
extends SpellcastingIllagerEntity {
    private SheepEntity field_190763_bw;

    public EvokerEntity(EntityType<? extends EvokerEntity> p_i50207_1_, World p_i50207_2_) {
        super(p_i50207_1_, p_i50207_2_);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonSpellGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackSpellGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WololoSpellGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)((Object)this), MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute func_234289_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 12.0).func_233815_a_(Attributes.field_233818_a_, 24.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (p_184191_1_ == null) {
            return false;
        }
        if (p_184191_1_ == this) {
            return true;
        }
        if (super.func_184191_r(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof VexEntity) {
            return this.func_184191_r(((VexEntity)p_184191_1_).func_190645_o());
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && p_184191_1_.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_191246_bp;
    }

    private void func_190748_a(@Nullable SheepEntity p_190748_1_) {
        this.field_190763_bw = p_190748_1_;
    }

    @Nullable
    private SheepEntity func_190751_dj() {
        return this.field_190763_bw;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public class WololoSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private final EntityPredicate field_220845_e;

        public WololoSpellGoal() {
            super((SpellcastingIllagerEntity)EvokerEntity.this);
            this.field_220845_e = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221012_a(p_220844_0_ -> ((SheepEntity)((Object)p_220844_0_)).func_175509_cj() == DyeColor.BLUE);
        }

        public boolean func_75250_a() {
            if (EvokerEntity.this.func_70638_az() != null) {
                return false;
            }
            if (EvokerEntity.this.func_193082_dl()) {
                return false;
            }
            if (EvokerEntity.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)EvokerEntity.this.field_70170_p, (Entity)((Object)EvokerEntity.this))) {
                return false;
            }
            List list = EvokerEntity.this.field_70170_p.func_217374_a(SheepEntity.class, this.field_220845_e, (LivingEntity)((Object)EvokerEntity.this), EvokerEntity.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            EvokerEntity.this.func_190748_a((SheepEntity)list.get(EvokerEntity.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        public boolean func_75253_b() {
            return EvokerEntity.this.func_190751_dj() != null && this.field_193321_c > 0;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EvokerEntity.this.func_190748_a(null);
        }

        protected void func_190868_j() {
            SheepEntity sheepentity = EvokerEntity.this.func_190751_dj();
            if (sheepentity != null && sheepentity.func_70089_S()) {
                sheepentity.func_175512_b(DyeColor.RED);
            }
        }

        protected int func_190867_m() {
            return 40;
        }

        protected int func_190869_f() {
            return 60;
        }

        protected int func_190872_i() {
            return 140;
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.WOLOLO;
        }
    }

    class SummonSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private final EntityPredicate field_220843_e;

        private SummonSpellGoal() {
            super((SpellcastingIllagerEntity)EvokerEntity.this);
            this.field_220843_e = new EntityPredicate().func_221013_a(16.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int i = EvokerEntity.this.field_70170_p.func_217374_a(VexEntity.class, this.field_220843_e, (LivingEntity)((Object)EvokerEntity.this), EvokerEntity.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EvokerEntity.this.field_70146_Z.nextInt(8) + 1 > i;
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            ServerWorld serverworld = (ServerWorld)EvokerEntity.this.field_70170_p;
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = EvokerEntity.this.func_233580_cy_().func_177982_a(-2 + EvokerEntity.this.field_70146_Z.nextInt(5), 1, -2 + EvokerEntity.this.field_70146_Z.nextInt(5));
                VexEntity vexentity = EntityType.field_200755_au.func_200721_a(EvokerEntity.this.field_70170_p);
                vexentity.func_174828_a(blockpos, 0.0f, 0.0f);
                vexentity.func_213386_a((IServerWorld)serverworld, EvokerEntity.this.field_70170_p.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
                vexentity.func_190658_a((MobEntity)((Object)EvokerEntity.this));
                vexentity.func_190651_g(blockpos);
                vexentity.func_190653_a(20 * (30 + EvokerEntity.this.field_70146_Z.nextInt(90)));
                serverworld.func_242417_l((Entity)vexentity);
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191248_br;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)EvokerEntity.this);
        }

        public void func_75246_d() {
            if (EvokerEntity.this.func_70638_az() != null) {
                EvokerEntity.this.func_70671_ap().func_75651_a((Entity)EvokerEntity.this.func_70638_az(), (float)EvokerEntity.this.func_184649_cE(), (float)EvokerEntity.this.func_70646_bf());
            } else if (EvokerEntity.this.func_190751_dj() != null) {
                EvokerEntity.this.func_70671_ap().func_75651_a((Entity)((Object)EvokerEntity.this.func_190751_dj()), (float)EvokerEntity.this.func_184649_cE(), (float)EvokerEntity.this.func_70646_bf());
            }
        }
    }

    class AttackSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private AttackSpellGoal() {
            super((SpellcastingIllagerEntity)EvokerEntity.this);
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            LivingEntity livingentity = EvokerEntity.this.func_70638_az();
            double d0 = Math.min(livingentity.func_226278_cu_(), EvokerEntity.this.func_226278_cu_());
            double d1 = Math.max(livingentity.func_226278_cu_(), EvokerEntity.this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - EvokerEntity.this.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - EvokerEntity.this.func_226277_ct_()));
            if (EvokerEntity.this.func_70068_e(livingentity) < 9.0) {
                for (int i = 0; i < 5; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 0.4f;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f1) * 1.5, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
                }
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f2) * 2.5, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = 1 * l;
                    this.func_190876_a(EvokerEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, EvokerEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
            }
        }

        private void func_190876_a(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = EvokerEntity.this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)((Object)EvokerEntity.this.field_70170_p), blockpos1, Direction.UP)) continue;
                if (!EvokerEntity.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = EvokerEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)((Object)EvokerEntity.this.field_70170_p), blockpos)).func_197766_b()) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                EvokerEntity.this.field_70170_p.func_217376_c((Entity)new EvokerFangsEntity(EvokerEntity.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)((Object)EvokerEntity.this)));
            }
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191247_bq;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }
}

