/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;

public class BiomeLayer
implements IC0Transformer {
    private static final int[] field_202743_q = new int[]{2, 4, 3, 6, 1, 5};
    private static final int[] field_202744_r = new int[]{2, 2, 2, 35, 35, 1};
    private static final int[] field_202745_s = new int[]{4, 29, 3, 1, 27, 6};
    private static final int[] field_202746_t = new int[]{4, 3, 5, 1};
    private static final int[] field_202747_u = new int[]{12, 12, 12, 30};
    private int[] field_151623_c = field_202744_r;
    private final boolean legacyDesert;
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];

    public BiomeLayer(boolean p_i232147_1_) {
        this.legacyDesert = p_i232147_1_;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            this.biomes[type.ordinal()] = new ArrayList<BiomeManager.BiomeEntry>((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)type));
        }
    }

    public int func_202726_a(INoiseRandom p_202726_1_, int p_202726_2_) {
        int i = (p_202726_2_ & 0xF00) >> 8;
        if (!LayerUtil.func_202827_a((int)(p_202726_2_ &= 0xFFFFF0FF)) && p_202726_2_ != 14) {
            switch (p_202726_2_) {
                case 1: {
                    if (i > 0) {
                        return p_202726_1_.func_202696_a(3) == 0 ? 39 : 38;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.DESERT, p_202726_1_);
                }
                case 2: {
                    if (i > 0) {
                        return 21;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.WARM, p_202726_1_);
                }
                case 3: {
                    if (i > 0) {
                        return 32;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.COOL, p_202726_1_);
                }
                case 4: {
                    return this.getBiomeId(BiomeManager.BiomeType.ICY, p_202726_1_);
                }
            }
            return 14;
        }
        return p_202726_2_;
    }

    private int getBiomeId(BiomeManager.BiomeType type, INoiseRandom context) {
        return WorldGenRegistries.field_243657_i.func_148757_b(WorldGenRegistries.field_243657_i.func_230516_a_(this.getBiome(type, context)));
    }

    protected RegistryKey<Biome> getBiome(BiomeManager.BiomeType type, INoiseRandom context) {
        if (type == BiomeManager.BiomeType.DESERT && this.legacyDesert) {
            type = BiomeManager.BiomeType.DESERT_LEGACY;
        }
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return ((BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight)).getKey();
    }
}

