/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraftforge.common.ForgeDummyContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    @SideOnly(value=Side.CLIENT)
    protected mp stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected mp flowingIcon;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected int blockID = -1;

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlockID(int blockID) {
        if (this.blockID == -1 || this.blockID == blockID) {
            this.blockID = blockID;
        } else if (!ForgeDummyContainer.forceDuplicateFluidBlockCrash) {
            FMLLog.warning("A mod has attempted to assign BlockID " + blockID + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.blockID + ". Configure your mods to prevent this from happening.", new Object[0]);
        } else {
            FMLLog.severe("A mod has attempted to assign BlockID " + blockID + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.blockID + ". Configure your mods to prevent this from happening.", new Object[0]);
            throw new LoaderException(new RuntimeException("A mod has attempted to assign BlockID " + blockID + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.blockID + ". Configure your mods to prevent this from happening."));
        }
        return this;
    }

    public Fluid setBlockID(aqs block) {
        return this.setBlockID(block.cF);
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final int getBlockID() {
        return this.blockID;
    }

    public final boolean canBePlacedInWorld() {
        return this.blockID != -1;
    }

    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : bt.a((String)s);
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public int getLuminosity(abr world, int x, int y, int z) {
        return this.getLuminosity();
    }

    public int getDensity(abr world, int x, int y, int z) {
        return this.getDensity();
    }

    public int getViscosity(abr world, int x, int y, int z) {
        return this.getViscosity();
    }

    public boolean isGaseous(abr world, int x, int y, int z) {
        return this.isGaseous();
    }

    public int getColor(abr world, int x, int y, int z) {
        return this.getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setStillIcon(mp stillIcon) {
        this.stillIcon = stillIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setFlowingIcon(mp flowingIcon) {
        this.flowingIcon = flowingIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setIcons(mp stillIcon, mp flowingIcon) {
        this.stillIcon = stillIcon;
        this.flowingIcon = flowingIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setIcons(mp commonIcon) {
        this.stillIcon = commonIcon;
        this.flowingIcon = commonIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public mp getIcon() {
        return this.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public mp getIcon(FluidStack stack) {
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public mp getIcon(abr world, int x, int y, int z) {
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public mp getStillIcon() {
        return this.stillIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public mp getFlowingIcon() {
        return this.flowingIcon;
    }
}

