/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Map;
import net.minecraftforge.common.network.ForgePacket;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidIdMapPacket
extends ForgePacket {
    private BiMap<String, Integer> fluidIds = HashBiMap.create();

    @Override
    public byte[] generatePacket() {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        dat.writeInt(FluidRegistry.maxID);
        for (Map.Entry entry : FluidRegistry.fluidIDs.entrySet()) {
            dat.writeUTF((String)entry.getKey());
            dat.writeInt(((Integer)entry.getValue()).intValue());
        }
        return dat.toByteArray();
    }

    @Override
    public ForgePacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        int listSize = dat.readInt();
        for (int i = 0; i < listSize; ++i) {
            String fluidName = dat.readUTF();
            int fluidId = dat.readInt();
            this.fluidIds.put((Object)fluidName, (Object)fluidId);
        }
        return this;
    }

    @Override
    public void execute(cl network, ua player) {
        FluidRegistry.initFluidIDs(this.fluidIds);
    }
}

