/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidStack {
    public int fluidID;
    public int amount;
    public bx tag;

    public FluidStack(Fluid fluid, int amount) {
        this.fluidID = fluid.getID();
        this.amount = amount;
    }

    public FluidStack(int fluidID, int amount) {
        this.fluidID = fluidID;
        this.amount = amount;
    }

    public FluidStack(int fluidID, int amount, bx nbt) {
        this(fluidID, amount);
        if (nbt != null) {
            this.tag = (bx)nbt.b();
        }
    }

    public FluidStack(FluidStack stack, int amount) {
        this(stack.fluidID, amount, stack.tag);
    }

    public static FluidStack loadFluidStackFromNBT(bx nbt) {
        if (nbt == null || FluidRegistry.getFluid(nbt.i("FluidName")) == null) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.getFluidID(nbt.i("FluidName")), nbt.e("Amount"));
        if (nbt.b("Tag")) {
            stack.tag = nbt.l("Tag");
        }
        return stack;
    }

    public bx writeToNBT(bx nbt) {
        nbt.a("FluidName", FluidRegistry.getFluidName(this.fluidID));
        nbt.a("Amount", this.amount);
        if (this.tag != null) {
            nbt.a("Tag", (ck)this.tag);
        }
        return nbt;
    }

    public final Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidID);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluidID, this.amount, this.tag);
    }

    public boolean isFluidEqual(FluidStack other) {
        return other != null && this.fluidID == other.fluidID && this.isFluidStackTagEqual(other);
    }

    private boolean isFluidStackTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : (other.tag == null ? false : this.tag.equals((Object)other.tag));
    }

    public static boolean areFluidStackTagsEqual(FluidStack stack1, FluidStack stack2) {
        return stack1 == null && stack2 == null ? true : (stack1 == null || stack2 == null ? false : stack1.isFluidStackTagEqual(stack2));
    }

    public boolean containsFluid(FluidStack other) {
        return this.isFluidEqual(other) && this.amount >= other.amount;
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        return this.isFluidEqual(other) && this.amount == other.amount;
    }

    public boolean isFluidEqual(xz other) {
        if (other == null) {
            return false;
        }
        if (other.b() instanceof IFluidContainerItem) {
            return this.isFluidEqual(((IFluidContainerItem)other.b()).getFluid(other));
        }
        return this.isFluidEqual(FluidContainerRegistry.getFluidForFilledItem(other));
    }

    public final int hashCode() {
        return this.fluidID;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidEqual((FluidStack)o);
    }
}

