/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.liquids.LiquidStack;

@Deprecated
public abstract class LiquidDictionary {
    private static BiMap<String, LiquidStack> liquids = HashBiMap.create();

    public static LiquidStack getOrCreateLiquid(String name, LiquidStack liquid) {
        if (liquid == null) {
            throw new NullPointerException("You cannot register a null LiquidStack");
        }
        LiquidStack existing = (LiquidStack)liquids.get((Object)name);
        if (existing != null) {
            return existing.copy();
        }
        liquids.put((Object)name, (Object)liquid.copy());
        MinecraftForge.EVENT_BUS.post(new LiquidRegisterEvent(name, liquid));
        return liquid;
    }

    public static LiquidStack getLiquid(String name, int amount) {
        LiquidStack liquid = (LiquidStack)liquids.get((Object)name);
        if (liquid == null) {
            return null;
        }
        liquid = liquid.copy();
        liquid.amount = amount;
        return liquid;
    }

    public static LiquidStack getCanonicalLiquid(String name) {
        return (LiquidStack)liquids.get((Object)name);
    }

    public static Map<String, LiquidStack> getLiquids() {
        return ImmutableMap.copyOf(liquids);
    }

    public static String findLiquidName(LiquidStack reference) {
        if (reference != null) {
            return (String)liquids.inverse().get((Object)reference);
        }
        return null;
    }

    public static LiquidStack getCanonicalLiquid(LiquidStack liquidStack) {
        return (LiquidStack)liquids.get(liquids.inverse().get((Object)liquidStack));
    }

    static {
        LiquidDictionary.getOrCreateLiquid("Water", new LiquidStack(aqs.G, 1000));
        LiquidDictionary.getOrCreateLiquid("Lava", new LiquidStack(aqs.I, 1000));
    }

    public static class LiquidRegisterEvent
    extends Event {
        public final String Name;
        public final LiquidStack Liquid;

        public LiquidRegisterEvent(String name, LiquidStack liquid) {
            this.Name = name;
            this.Liquid = liquid.copy();
        }
    }
}

