/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class CharSequenceUtils {
    public static CharSequence subSequence(CharSequence cs, int start) {
        return cs == null ? null : cs.subSequence(start, cs.length());
    }

    static int indexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        int sz2 = cs.length();
        if (start < 0) {
            start = 0;
        }
        for (int i2 = start; i2 < sz2; ++i2) {
            if (cs.charAt(i2) != searchChar) continue;
            return i2;
        }
        return -1;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return ((Object)cs).toString().indexOf(((Object)searchChar).toString(), start);
    }

    static int lastIndexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start);
        }
        int sz2 = cs.length();
        if (start < 0) {
            return -1;
        }
        if (start >= sz2) {
            start = sz2 - 1;
        }
        for (int i2 = start; i2 >= 0; --i2) {
            if (cs.charAt(i2) != searchChar) continue;
            return i2;
        }
        return -1;
    }

    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        return ((Object)cs).toString().lastIndexOf(((Object)searchChar).toString(), start);
    }

    static char[] toCharArray(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).toCharArray();
        }
        int sz2 = cs.length();
        char[] array = new char[cs.length()];
        for (int i2 = 0; i2 < sz2; ++i2) {
            array[i2] = cs.charAt(i2);
        }
        return array;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        return ((Object)cs).toString().regionMatches(ignoreCase, thisStart, ((Object)substring).toString(), start, length);
    }
}

