/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class MarkerTransformer
implements IClassTransformer {
    private ListMultimap<String, String> markers = ArrayListMultimap.create();

    public MarkerTransformer() throws IOException {
        this("fml_marker.cfg");
    }

    protected MarkerTransformer(String rulesFile) throws IOException {
        this.readMapFile(rulesFile);
    }

    private void readMapFile(String rulesFile) throws IOException {
        File file = new File(rulesFile);
        URL rulesResource = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        Resources.readLines((URL)rulesResource, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Void>(){

            public Void getResult() {
                return null;
            }

            public boolean processLine(String input) throws IOException {
                String line = ((String)Iterables.getFirst((Iterable)Splitter.on((char)'#').limit(2).split((CharSequence)input), (Object)"")).trim();
                if (line.length() == 0) {
                    return true;
                }
                ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)" ").trimResults().split((CharSequence)line));
                if (parts.size() != 2) {
                    throw new RuntimeException("Invalid config file line " + input);
                }
                ArrayList markerInterfaces = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)parts.get(1)));
                for (String marker : markerInterfaces) {
                    MarkerTransformer.this.markers.put(parts.get(0), (Object)marker);
                }
                return true;
            }
        });
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!this.markers.containsKey((Object)name)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (String marker : this.markers.get((Object)name)) {
            classNode.interfaces.add(marker);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: MarkerTransformer <JarPath> <MapFile> [MapFile2]... ");
            return;
        }
        boolean hasTransformer = false;
        MarkerTransformer[] trans = new MarkerTransformer[args.length - 1];
        for (int x2 = 1; x2 < args.length; ++x2) {
            try {
                trans[x2 - 1] = new MarkerTransformer(args[x2]);
                hasTransformer = true;
                continue;
            }
            catch (IOException e) {
                System.out.println("Could not read Transformer Map: " + args[x2]);
                e.printStackTrace();
            }
        }
        if (!hasTransformer) {
            System.out.println("Culd not find a valid transformer to perform");
            return;
        }
        File orig = new File(args[0]);
        File temp = new File(args[0] + ".ATBack");
        if (!orig.exists() && !temp.exists()) {
            System.out.println("Could not find target jar: " + orig);
            return;
        }
        if (!orig.renameTo(temp)) {
            System.out.println("Could not rename file: " + orig + " -> " + temp);
            return;
        }
        try {
            MarkerTransformer.processJar(temp, orig, trans);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!temp.delete()) {
            System.out.println("Could not delete temp file: " + temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(File inFile, File outFile, MarkerTransformer[] transformers) throws IOException {
        ZipInputStream inJar = null;
        ZipOutputStream outJar = null;
        try {
            ZipEntry entry;
            try {
                inJar = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open input file: " + e.getMessage());
            }
            try {
                outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("Could not open output file: " + e.getMessage());
            }
            while ((entry = inJar.getNextEntry()) != null) {
                int len;
                if (entry.isDirectory()) {
                    outJar.putNextEntry(entry);
                    continue;
                }
                byte[] data = new byte[4096];
                ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
                do {
                    if ((len = inJar.read(data)) <= 0) continue;
                    entryBuffer.write(data, 0, len);
                } while (len != -1);
                byte[] entryData = entryBuffer.toByteArray();
                String entryName = entry.getName();
                if (entryName.endsWith(".class") && !entryName.startsWith(".")) {
                    ClassNode cls = new ClassNode();
                    ClassReader rdr = new ClassReader(entryData);
                    rdr.accept((ClassVisitor)cls, 0);
                    String name = cls.name.replace('/', '.').replace('\\', '.');
                    for (MarkerTransformer trans : transformers) {
                        entryData = trans.transform(name, name, entryData);
                    }
                }
                ZipEntry newEntry = new ZipEntry(entryName);
                outJar.putNextEntry(newEntry);
                outJar.write(entryData);
            }
        }
        finally {
            if (outJar != null) {
                try {
                    outJar.close();
                }
                catch (IOException e) {}
            }
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

