/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    ArrayList<mk> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, agh.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, ahl.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, ahm.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, ahm.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, ahw.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, aia.a, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, aif.b, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, aji.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, js.T, 10, 10);
        ChestGenHooks.addInfo(DUNGEON_CHEST, afp.a, 8, 8);
        ye book = new ye((yc)yc.bY, 1, 0);
        mk tmp = new mk(book, 1, 1, 1);
        ChestGenHooks.getInfo(MINESHAFT_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_DESERT_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(PYRAMID_JUNGLE_CHEST).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_CORRIDOR).addItem(tmp);
        ChestGenHooks.getInfo(STRONGHOLD_LIBRARY).addItem(new mk(book, 1, 5, 2));
        ChestGenHooks.getInfo(STRONGHOLD_CROSSING).addItem(tmp);
        ChestGenHooks.getInfo(DUNGEON_CHEST).addItem(tmp);
    }

    static void addDungeonLoot(ChestGenHooks dungeon, ye item, int weight, int min, int max) {
        dungeon.addItem(new mk(item, min, max, weight));
    }

    private static void addInfo(String category, mk[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static ye[] generateStacks(Random rand, ye source, int min, int max) {
        ye[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new ye[]{};
        } else if (count > source.b().m()) {
            ret = new ye[count];
            for (int x2 = 0; x2 < count; ++x2) {
                ret[x2] = source.m();
                ret[x2].b = 1;
            }
        } else {
            ret = new ye[]{source.m()};
            ret[0].b = count;
        }
        return ret;
    }

    public static mk[] getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, mk item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, ye item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static ye getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, mk[] items, int min, int max) {
        this(category);
        for (mk item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(mk item) {
        this.contents.add(item);
    }

    public void removeItem(ye item) {
        Iterator<mk> itr = this.contents.iterator();
        while (itr.hasNext()) {
            mk cont = itr.next();
            if (!item.a(cont.b) && (item.k() != Short.MAX_VALUE || item.d != cont.b.d)) continue;
            itr.remove();
        }
    }

    public mk[] getItems(Random rnd) {
        ArrayList<mk> ret = new ArrayList<mk>();
        for (mk orig : this.contents) {
            mk n;
            yc item = orig.b.b();
            if (item == null || (n = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret.toArray(new mk[ret.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public ye getOneItem(Random rand) {
        mk[] items = this.getItems(rand);
        mk item = (mk)mi.a((Random)rand, (mj[])items);
        ye[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

