/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.CertificateHelper;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.common.patcher.ClassPatchManager;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class FMLSanityChecker
implements IFMLCallHook {
    private static final String FMLFINGERPRINT = "51:0A:FB:4C:AF:A4:A0:F2:F5:CF:C5:0E:B4:CC:3C:30:24:4A:E3:8E".toLowerCase().replace(":", "");
    private static final String FORGEFINGERPRINT = "E3:C3:D5:0C:7C:98:6D:F7:4C:64:5C:0A:C5:46:39:74:1C:90:A5:57".toLowerCase().replace(":", "");
    private static final String MCFINGERPRINT = "CD:99:95:96:56:F7:53:DC:28:D8:63:B4:67:69:F7:F8:FB:AE:FC:FC".toLowerCase().replace(":", "");
    private LaunchClassLoader cl;
    public static File fmlLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Void call() throws Exception {
        codeSource = this.getClass().getProtectionDomain().getCodeSource();
        goodFML = false;
        fmlIsJar = false;
        if (codeSource.getLocation().getProtocol().equals("jar")) {
            fmlIsJar = true;
            certificates = codeSource.getCertificates();
            if (certificates != null) {
                for (Certificate cert : certificates) {
                    fingerprint = CertificateHelper.getFingerprint(cert);
                    if (fingerprint.equals(FMLSanityChecker.FMLFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for FML. Certificate fingerprint %s", new Object[]{fingerprint});
                        goodFML = true;
                        continue;
                    }
                    if (fingerprint.equals(FMLSanityChecker.FORGEFINGERPRINT)) {
                        FMLRelaunchLog.info("Found valid fingerprint for Minecraft Forge. Certificate fingerprint %s", new Object[]{fingerprint});
                        goodFML = true;
                        continue;
                    }
                    FMLRelaunchLog.severe("Found invalid fingerprint for FML: %s", new Object[]{fingerprint});
                }
            }
        } else {
            goodFML = true;
        }
        goodMC = FMLLaunchHandler.side() == Side.SERVER;
        certCount = 0;
        try {
            cbr = Class.forName("net.minecraft.client.ClientBrandRetriever", false, (ClassLoader)this.cl);
            codeSource = cbr.getProtectionDomain().getCodeSource();
        }
        catch (Exception e) {
            goodMC = true;
        }
        mcJarFile = null;
        if (fmlIsJar && !goodMC && codeSource.getLocation().getProtocol().equals("jar")) {
            try {
                mcPath = codeSource.getLocation().getPath().substring(5);
                mcPath = mcPath.substring(0, mcPath.lastIndexOf(33));
                mcPath = URLDecoder.decode(mcPath, Charsets.UTF_8.name());
                mcJarFile = new JarFile(mcPath, true);
                mcJarFile.getManifest();
                cbrEntry = mcJarFile.getJarEntry("net/minecraft/client/ClientBrandRetriever.class");
                ByteStreams.toByteArray((InputStream)mcJarFile.getInputStream(cbrEntry));
                certificates = cbrEntry.getCertificates();
                v0 = certCount = certificates != null ? certificates.length : 0;
                if (certificates == null) ** GOTO lbl63
                for (Certificate cert : certificates) {
                    fingerprint = CertificateHelper.getFingerprint(cert);
                    if (!fingerprint.equals(FMLSanityChecker.MCFINGERPRINT)) continue;
                    FMLRelaunchLog.info("Found valid fingerprint for Minecraft. Certificate fingerprint %s", new Object[]{fingerprint});
                    goodMC = true;
                }
            }
            catch (Throwable e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "A critical error occurred trying to read the minecraft jar file", new Object[0]);
            }
            finally {
                if (mcJarFile != null) {
                    try {
                        mcJarFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        } else {
            goodMC = true;
        }
lbl63:
        // 4 sources

        if (!goodMC) {
            FMLRelaunchLog.severe("The minecraft jar %s appears to be corrupt! There has been CRITICAL TAMPERING WITH MINECRAFT, it is highly unlikely minecraft will work! STOP NOW, get a clean copy and try again!", new Object[]{codeSource.getLocation().getFile()});
            if (!Boolean.parseBoolean(System.getProperty("fml.ignoreInvalidMinecraftCertificates", "false"))) {
                FMLRelaunchLog.severe("For your safety, FML will not launch minecraft. You will need to fetch a clean version of the minecraft jar file", new Object[0]);
                FMLRelaunchLog.severe("Technical information: The class net.minecraft.client.ClientBrandRetriever should have been associated with the minecraft jar file, and should have returned us a valid, intact minecraft jar location. This did not work. Either you have modified the minecraft jar file (if so run the forge installer again), or you are using a base editing jar that is changing this class (and likely others too). If you REALLY want to run minecraft in this configuration, add the flag -Dfml.ignoreInvalidMinecraftCertificates=true to the 'JVM settings' in your launcher profile.", new Object[0]);
                System.exit(1);
            } else {
                FMLRelaunchLog.severe("FML has been ordered to ignore the invalid or missing minecraft certificate. This is very likely to cause a problem!", new Object[0]);
                FMLRelaunchLog.severe("Technical information: ClientBrandRetriever was at %s, there were %d certificates for it", new Object[]{codeSource.getLocation(), certCount});
            }
        }
        if (!goodFML) {
            FMLRelaunchLog.severe("FML appears to be missing any signature data. This is not a good thing", new Object[0]);
        }
        if ((mlClass = this.cl.getClassBytes("ModLoader")) == null) {
            return null;
        }
        mlTester = new MLDetectorClassVisitor();
        cr = new ClassReader(mlClass);
        cr.accept((ClassVisitor)mlTester, 1);
        if (!MLDetectorClassVisitor.access$100(mlTester)) {
            JOptionPane.showMessageDialog(null, "<html>CRITICAL ERROR<br/>ModLoader was detected in this environment<br/>ForgeModLoader cannot be installed alongside ModLoader<br/>All mods should work without ModLoader being installed<br/>Because ForgeModLoader is 100% compatible with ModLoader<br/>Re-install Minecraft Forge or Forge ModLoader into a clean<br/>jar and try again.", "ForgeModLoader critical error", 0);
            throw new RuntimeException("Invalid ModLoader class detected");
        }
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        this.cl = (LaunchClassLoader)data.get("classLoader");
        File mcDir = (File)data.get("mcLocation");
        fmlLocation = (File)data.get("coremodLocation");
        ClassPatchManager.INSTANCE.setup(FMLLaunchHandler.side());
        FMLDeobfuscatingRemapper.INSTANCE.setup(mcDir, this.cl, (String)data.get("deobfuscationFileName"));
    }

    static class MLDetectorClassVisitor
    extends ClassVisitor {
        private boolean foundMarker = false;

        private MLDetectorClassVisitor() {
            super(262144);
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            if ("fmlMarker".equals(arg1)) {
                this.foundMarker = true;
            }
            return null;
        }

        static /* synthetic */ boolean access$100(MLDetectorClassVisitor x0) {
            return x0.foundMarker;
        }
    }
}

