/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.FMLLogFormatter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraft.launchwrapper.LogWrapper;

public class FMLRelaunchLog {
    public static FMLRelaunchLog log = new FMLRelaunchLog();
    static File minecraftHome;
    private static boolean configured;
    private static Thread consoleLogThread;
    private static PrintStream errCache;
    private Logger myLog;
    private static FileHandler fileHandler;
    private static FMLLogFormatter formatter;
    static String logFileNamePattern;

    private FMLRelaunchLog() {
    }

    private static void configureLogging() {
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
        FMLRelaunchLog.log.myLog = Logger.getLogger("ForgeModLoader");
        LogWrapper.retarget((Logger)FMLRelaunchLog.log.myLog);
        Logger stdOut = Logger.getLogger("STDOUT");
        stdOut.setParent(FMLRelaunchLog.log.myLog);
        Logger stdErr = Logger.getLogger("STDERR");
        stdErr.setParent(FMLRelaunchLog.log.myLog);
        FMLRelaunchLog.log.myLog.setLevel(Level.ALL);
        FMLRelaunchLog.log.myLog.setUseParentHandlers(false);
        consoleLogThread = new Thread(new ConsoleLogThread());
        consoleLogThread.setDaemon(true);
        consoleLogThread.start();
        formatter = new FMLLogFormatter();
        try {
            File logPath = new File(minecraftHome, logFileNamePattern);
            fileHandler = new FileHandler(logPath.getPath(), 0, 3){

                @Override
                public synchronized void close() throws SecurityException {
                }
            };
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
        FMLRelaunchLog.resetLoggingHandlers();
        errCache = System.err;
        System.setOut(new PrintStream(new LoggingOutStream(stdOut), true));
        System.setErr(new PrintStream(new LoggingOutStream(stdErr), true));
        configured = true;
    }

    private static void resetLoggingHandlers() {
        ConsoleLogThread.wrappedHandler.setLevel(Level.parse(System.getProperty("fml.log.level", "INFO")));
        FMLRelaunchLog.log.myLog.addHandler(new ConsoleLogWrapper());
        ConsoleLogThread.wrappedHandler.setFormatter(formatter);
        fileHandler.setLevel(Level.ALL);
        fileHandler.setFormatter(formatter);
        FMLRelaunchLog.log.myLog.addHandler(fileHandler);
    }

    public static void loadLogConfiguration(File logConfigFile) {
        if (logConfigFile != null && logConfigFile.exists() && logConfigFile.canRead()) {
            try {
                LogManager.getLogManager().readConfiguration(new FileInputStream(logConfigFile));
                FMLRelaunchLog.resetLoggingHandlers();
            }
            catch (Exception e) {
                FMLRelaunchLog.log(Level.SEVERE, e, "Error reading logging configuration file %s", logConfigFile.getName());
            }
        }
    }

    public static void log(String logChannel, Level level, String format, Object ... data) {
        FMLRelaunchLog.makeLog(logChannel);
        Logger.getLogger(logChannel).log(level, String.format(format, data));
    }

    public static void log(Level level, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data));
    }

    public static void log(String logChannel, Level level, Throwable ex, String format, Object ... data) {
        FMLRelaunchLog.makeLog(logChannel);
        Logger.getLogger(logChannel).log(level, String.format(format, data), ex);
    }

    public static void log(Level level, Throwable ex, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data), ex);
    }

    public static void severe(String format, Object ... data) {
        FMLRelaunchLog.log(Level.SEVERE, format, data);
    }

    public static void warning(String format, Object ... data) {
        FMLRelaunchLog.log(Level.WARNING, format, data);
    }

    public static void info(String format, Object ... data) {
        FMLRelaunchLog.log(Level.INFO, format, data);
    }

    public static void fine(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINE, format, data);
    }

    public static void finer(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINER, format, data);
    }

    public static void finest(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINEST, format, data);
    }

    public Logger getLogger() {
        return this.myLog;
    }

    public static void makeLog(String logChannel) {
        Logger l = Logger.getLogger(logChannel);
        l.setParent(FMLRelaunchLog.log.myLog);
    }

    private static class LoggingOutStream
    extends ByteArrayOutputStream {
        private Logger log;
        private StringBuilder currentMessage;

        public LoggingOutStream(Logger log) {
            this.log = log;
            this.currentMessage = new StringBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Class<FMLRelaunchLog> clazz = FMLRelaunchLog.class;
            synchronized (FMLRelaunchLog.class) {
                super.flush();
                String record = this.toString();
                super.reset();
                this.currentMessage.append(record.replace(FMLLogFormatter.LINE_SEPARATOR, "\n"));
                int lastIdx = -1;
                int idx = this.currentMessage.indexOf("\n", lastIdx + 1);
                while (idx >= 0) {
                    this.log.log(Level.INFO, this.currentMessage.substring(lastIdx + 1, idx));
                    lastIdx = idx;
                    idx = this.currentMessage.indexOf("\n", lastIdx + 1);
                }
                if (lastIdx >= 0) {
                    String rem = this.currentMessage.substring(lastIdx + 1);
                    this.currentMessage.setLength(0);
                    this.currentMessage.append(rem);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class ConsoleLogThread
    implements Runnable {
        static ConsoleHandler wrappedHandler = new ConsoleHandler();
        static LinkedBlockingQueue<LogRecord> recordQueue = new LinkedBlockingQueue();

        private ConsoleLogThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    LogRecord lr = recordQueue.take();
                    wrappedHandler.publish(lr);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace(errCache);
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
    }

    private static class ConsoleLogWrapper
    extends Handler {
        private ConsoleLogWrapper() {
        }

        @Override
        public void publish(LogRecord record) {
            boolean currInt = Thread.interrupted();
            try {
                ConsoleLogThread.recordQueue.put(record);
            }
            catch (InterruptedException e) {
                e.printStackTrace(errCache);
            }
            if (currInt) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

