/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.asm.FMLSanityChecker;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dh getDataForWriting(ayq handler, ays info) {
        dh fmlData = new dh();
        dq list = new dq();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dh mod = new dh();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            list.a((dy)mod);
        }
        fmlData.a("ModList", (dy)list);
        dq dataList = new dq();
        FMLLog.fine("Gathering id map for writing to world save %s", info.k());
        GameData.GameDataSnapshot dataSnapshot = GameData.buildItemDataList();
        for (Map.Entry<String, Integer> item : dataSnapshot.idMap.entrySet()) {
            dh tag = new dh();
            tag.a("K", item.getKey());
            tag.a("V", item.getValue().intValue());
            dataList.a((dy)tag);
        }
        fmlData.a("ItemData", (dy)dataList);
        fmlData.a("BlockedItemIds", GameData.getBlockedIds());
        dq blockAliasList = new dq();
        for (Map.Entry<String, String> entry : GameData.getBlockRegistry().getAliases().entrySet()) {
            dh tag = new dh();
            tag.a("K", entry.getKey());
            tag.a("V", entry.getValue());
            blockAliasList.a((dy)tag);
        }
        fmlData.a("BlockAliases", (dy)blockAliasList);
        dq blockSubstitutionsList = new dq();
        for (String entry : dataSnapshot.blockSubstitutions) {
            dh tag = new dh();
            tag.a("K", entry);
            blockSubstitutionsList.a((dy)tag);
        }
        fmlData.a("BlockSubstitutions", (dy)blockSubstitutionsList);
        dq itemAliasList = new dq();
        for (Map.Entry<String, String> entry : GameData.getItemRegistry().getAliases().entrySet()) {
            dh tag = new dh();
            tag.a("K", entry.getKey());
            tag.a("V", entry.getValue());
            itemAliasList.a((dy)tag);
        }
        fmlData.a("ItemAliases", (dy)itemAliasList);
        dq itemSubstitutionsList = new dq();
        for (String entry : dataSnapshot.itemSubstitutions) {
            dh tag = new dh();
            tag.a("K", entry);
            itemSubstitutionsList.a((dy)tag);
        }
        fmlData.a("ItemSubstitutions", (dy)itemSubstitutionsList);
        return fmlData;
    }

    @Override
    public void readData(ayq handler, ays info, Map<String, dy> propertyMap, dh tag) {
        LinkedHashMap dataList;
        if (tag.c("ModList")) {
            dq modList = tag.c("ModList", 10);
            for (int i = 0; i < modList.c(); ++i) {
                dh mod = modList.b(i);
                String modId = mod.j("ModId");
                String modVersion = mod.j("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.c("ModItemData")) {
            FMLLog.info("Attempting to convert old world data to new system. This may be trouble!", new Object[0]);
            dq modList = tag.c("ModItemData", 10);
            dataList = Maps.newLinkedHashMap();
            for (int i = 0; i < modList.c(); ++i) {
                String forcedName;
                dh itemTag = modList.b(i);
                String modId = itemTag.j("ModId");
                String itemType = itemTag.j("ItemType");
                int itemId = itemTag.f("ItemId");
                int ordinal = itemTag.f("ordinal");
                String forcedModId = itemTag.c("ForcedModId") ? itemTag.j("ForcedModId") : null;
                String string = forcedName = itemTag.c("ForcedName") ? itemTag.j("ForcedName") : null;
                if (forcedName == null) {
                    FMLLog.warning("Found unlabelled item in world save, this may cause problems. The item type %s:%d will not be present", itemType, ordinal);
                    continue;
                }
                String itemLabel = String.format("%c%s:%s", Character.valueOf('\u0002'), forcedModId != null ? forcedModId : modId, forcedName);
                dataList.put(itemLabel, itemId);
            }
            failedElements = GameData.injectWorldIDMap(dataList, (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), true, true);
        } else if (tag.c("ItemData")) {
            dq list = tag.c("ItemData", 10);
            dataList = Maps.newLinkedHashMap();
            for (int i = 0; i < list.c(); ++i) {
                dh dataTag = list.b(i);
                dataList.put(dataTag.j("K"), dataTag.f("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            if (!tag.c("BlockedItemIds")) {
                GameData.fixBrokenIds(dataList, blockedIds);
            }
            for (int id : tag.l("BlockedItemIds")) {
                blockedIds.add(id);
            }
            HashMap<String, String> blockAliases = new HashMap<String, String>();
            list = tag.c("BlockAliases", 10);
            for (int i = 0; i < list.c(); ++i) {
                dh dataTag = list.b(i);
                blockAliases.put(dataTag.j("K"), dataTag.j("V"));
            }
            HashSet blockSubstitutions = Sets.newHashSet();
            if (tag.b("BlockSubstitutions", 9)) {
                list = tag.c("BlockSubstitutions", 10);
                for (int i = 0; i < list.c(); ++i) {
                    dh dataTag = list.b(i);
                    blockSubstitutions.add(dataTag.j("K"));
                }
            }
            HashMap<String, String> itemAliases = new HashMap<String, String>();
            list = tag.c("ItemAliases", 10);
            for (int i = 0; i < list.c(); ++i) {
                dh dataTag = list.b(i);
                itemAliases.put(dataTag.j("K"), dataTag.j("V"));
            }
            HashSet itemSubstitutions = Sets.newHashSet();
            if (tag.b("ItemSubstitutions", 9)) {
                list = tag.c("ItemSubstitutions", 10);
                for (int i = 0; i < list.c(); ++i) {
                    dh dataTag = list.b(i);
                    itemSubstitutions.add(dataTag.j("K"));
                }
            }
            try {
                failedElements = GameData.injectWorldIDMap(dataList, blockedIds, blockAliases, itemAliases, blockSubstitutions, itemSubstitutions, true, true);
            }
            catch (IllegalStateException ex) {
                String msg = "The world state is utterly corrupted and this save is NOT loadable\n\nThere is a high probability that a mod has broken the\nID map and there is\nNOTHING FML or Forge can do to recover this save.\n\nIf you changed your mods, try reverting the change";
                FMLLog.log(Level.FATAL, ex, msg, new Object[0]);
                StartupQuery.notify(msg);
                StartupQuery.abort();
            }
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "cpw.mods.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

