/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.network.handshake.IHandshakeState;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;

enum FMLHandshakeServerState implements IHandshakeState<FMLHandshakeServerState>
{
    START{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            int overrideDim = dispatcher.serverInitiateHandshake();
            ctx.writeAndFlush((Object)FMLHandshakeMessage.makeCustomChannelRegistration(NetworkRegistry.INSTANCE.channelNamesFor(Side.SERVER))).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ServerHello(overrideDim)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return HELLO;
        }
    }
    ,
    HELLO{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            if (msg instanceof FMLHandshakeMessage.ClientHello) {
                FMLLog.info("Client protocol version %x", ((FMLHandshakeMessage.ClientHello)msg).protocolVersion());
                return this;
            }
            FMLHandshakeMessage.ModList client = (FMLHandshakeMessage.ModList)msg;
            FMLLog.info("Client attempting to join with %d mods : %s", client.modListSize(), client.modListAsString());
            String result = FMLNetworkHandler.checkModList(client, Side.CLIENT);
            if (result != null) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake(result);
                return ERROR;
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModList(Loader.instance().getActiveModList()));
            return WAITINGCACK;
        }
    }
    ,
    WAITINGCACK{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            if (!((Boolean)ctx.channel().attr(NetworkDispatcher.IS_LOCAL).get()).booleanValue()) {
                ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModIdData(GameData.buildItemDataList())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            NetworkRegistry.INSTANCE.fireNetworkHandshake((NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get()), Side.SERVER);
            return COMPLETE;
        }
    }
    ,
    COMPLETE{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            FMLMessage.CompleteHandshake complete = new FMLMessage.CompleteHandshake(Side.SERVER);
            ctx.fireChannelRead((Object)complete);
            return DONE;
        }
    }
    ,
    DONE{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            return this;
        }
    }
    ,
    ERROR{

        @Override
        public FMLHandshakeServerState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            return this;
        }
    };

}

