/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemStackHolderRef;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;

public enum ItemStackHolderInjector {
    INSTANCE;

    private List<ItemStackHolderRef> itemStackHolders = Lists.newArrayList();

    public void inject() {
        FMLLog.getLogger().log(Level.INFO, "Injecting itemstacks");
        for (ItemStackHolderRef ishr : this.itemStackHolders) {
            ishr.apply();
        }
        FMLLog.getLogger().log(Level.INFO, "Itemstack injection complete");
    }

    public void findHolders(ASMDataTable table) {
        FMLLog.info("Identifying ItemStackHolder annotations", new Object[0]);
        Set<ASMDataTable.ASMData> allItemStackHolders = table.getAll(GameRegistry.ItemStackHolder.class.getName());
        HashMap classCache = Maps.newHashMap();
        for (ASMDataTable.ASMData data : allItemStackHolders) {
            String className = data.getClassName();
            String annotationTarget = data.getObjectName();
            String value = (String)data.getAnnotationInfo().get("value");
            int meta = data.getAnnotationInfo().containsKey("meta") ? (Integer)data.getAnnotationInfo().get("meta") : 0;
            String nbt = data.getAnnotationInfo().containsKey("nbt") ? (String)data.getAnnotationInfo().get("nbt") : "";
            this.addHolder(classCache, className, annotationTarget, value, meta, nbt);
        }
        FMLLog.info("Found %d ItemStackHolder annotations", allItemStackHolders.size());
    }

    private void addHolder(Map<String, Class<?>> classCache, String className, String annotationTarget, String value, Integer meta, String nbt) {
        Class<?> clazz;
        if (classCache.containsKey(className)) {
            clazz = classCache.get(className);
        } else {
            try {
                clazz = Class.forName(className, true, ((Object)((Object)this)).getClass().getClassLoader());
                classCache.put(className, clazz);
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
        try {
            Field f = clazz.getField(annotationTarget);
            this.itemStackHolders.add(new ItemStackHolderRef(f, value, meta, nbt));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

