/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class ItemLayerModel
implements IRetexturableModel {
    public static final ItemLayerModel instance = new ItemLayerModel((ImmutableList<jy>)ImmutableList.of());
    private final ImmutableList<jy> textures;

    public ItemLayerModel(ImmutableList<jy> textures) {
        this.textures = textures;
    }

    public ItemLayerModel(bgl model) {
        this(ItemLayerModel.getTextures(model));
    }

    private static ImmutableList<jy> getTextures(bgl model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.b("layer" + i)) {
            builder.add((Object)new jy(model.c("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    @Override
    public Collection<jy> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<jy> getTextures() {
        return this.textures;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public IModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size(); ++i) {
            if (!textures.containsKey((Object)("layer" + i))) continue;
            builder.add((Object)new jy((String)textures.get((Object)("layer" + i))));
        }
        return new ItemLayerModel((ImmutableList<jy>)builder.build());
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply((Optional<? extends IModelPart>)Optional.absent());
        for (int i = 0; i < this.textures.size(); ++i) {
            bmi sprite = (bmi)bakedTextureGetter.apply(this.textures.get(i));
            builder.addAll(this.getQuadsForSprite(i, sprite, format, transform));
        }
        bmi particle = (bmi)bakedTextureGetter.apply((Object)(this.textures.isEmpty() ? new jy("missingno") : (jy)this.textures.get(0)));
        ImmutableMap<bgr.b, TRSRTransformation> map = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        BakedModel ret = new BakedModel((ImmutableList<bgg>)builder.build(), particle, format);
        if (map.isEmpty()) {
            return ret;
        }
        return new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)ret, map);
    }

    public ImmutableList<bgg> getQuadsForSprite(int tint, bmi sprite, bmu format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.c();
        int vMax = sprite.d();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f = 0; f < sprite.k(); ++f) {
            int[] pixels = sprite.a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = this.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.e, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptu && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.f, tint, sprite, uMax, vMax, u, v);
                    }
                    if (ptv[u] && !t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.b, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptv[u] && t) {
                        ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.a, tint, sprite, uMax, vMax, u, v);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.f, tint, sprite, uMax, vMax, uMax, v);
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                ItemLayerModel.addSideQuad((ImmutableList.Builder<bgg>)builder, faces, format, transform, cq.a, tint, sprite, uMax, vMax, u, vMax);
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cq.c, tint, 0.0f, 0.0f, 0.46875f, sprite.e(), sprite.h(), 0.0f, 1.0f, 0.46875f, sprite.e(), sprite.g(), 1.0f, 1.0f, 0.46875f, sprite.f(), sprite.g(), 1.0f, 0.0f, 0.46875f, sprite.f(), sprite.h()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, cq.d, tint, 0.0f, 0.0f, 0.53125f, sprite.e(), sprite.h(), 1.0f, 0.0f, 0.53125f, sprite.f(), sprite.h(), 1.0f, 1.0f, 0.53125f, sprite.f(), sprite.g(), 0.0f, 1.0f, 0.53125f, sprite.e(), sprite.g()));
        return builder.build();
    }

    protected boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<bgg> builder, BitSet faces, bmu format, Optional<TRSRTransformation> transform, cq side, int tint, bmi sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static bgg buildSideQuad(bmu format, Optional<TRSRTransformation> transform, cq side, int tint, bmi sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.c();
        float y0 = (float)v / (float)sprite.d();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case e: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case f: {
                y1 = ((float)v + 1.0f) / (float)sprite.d();
                break;
            }
            case a: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case b: {
                x1 = ((float)u + 1.0f) / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.m().n() * 0.5f / (float)sprite.c());
        float u1 = 16.0f * (x1 - (float)side.m().n() * 0.5f / (float)sprite.c());
        float v0 = 16.0f * (1.0f - y0 - (float)side.m().o() * 0.5f / (float)sprite.d());
        float v1 = 16.0f * (1.0f - y1 - (float)side.m().o() * 0.5f / (float)sprite.d());
        switch (side) {
            case e: 
            case f: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.d();
                v1 += 0.5f / (float)sprite.d();
                break;
            }
            case a: 
            case b: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.c();
                u1 -= 0.5f / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case e: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case f: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case a: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case b: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModel.buildQuad(format, transform, side.d(), tint, x0, y0, z1, sprite.a((double)u0), sprite.b((double)v0), x1, y1, z1, sprite.a((double)u1), sprite.b((double)v1), x1, y1, z2, sprite.a((double)u1), sprite.b((double)v1), x0, y0, z2, sprite.a((double)u0), sprite.b((double)v0));
    }

    private static final bgg buildQuad(bmu format, Optional<TRSRTransformation> transform, cq side, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, bmu format, Optional<TRSRTransformation> transform, cq side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.i(); ++e) {
            switch (format.c(e).b()) {
                case a: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        ((TRSRTransformation)transform.get()).getMatrix().transform((Tuple4f)vec);
                        builder.put(e, vec.x, vec.y, vec.z, vec.w);
                        continue block6;
                    }
                    builder.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case c: {
                    builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e).d() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        instance;


        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("item-layer") || modelLocation.a().equals("models/block/item-layer") || modelLocation.a().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(jy modelLocation) {
            return instance;
        }
    }

    public static class BakedModel
    implements IFlexibleBakedModel {
        private final ImmutableList<bgg> quads;
        private final bmi particle;
        private final bmu format;

        public BakedModel(ImmutableList<bgg> quads, bmi particle, bmu format) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
        }

        public boolean b() {
            return true;
        }

        public boolean c() {
            return false;
        }

        public boolean d() {
            return false;
        }

        public bmi e() {
            return this.particle;
        }

        public bgr f() {
            return bgr.a;
        }

        public List<bgg> a(cq side) {
            return ImmutableList.of();
        }

        public List<bgg> a() {
            return this.quads;
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }
    }
}

