/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel instance = new MultiLayerModel((ImmutableMap<Optional<adf>, bov>)ImmutableMap.of());
    private final ImmutableMap<Optional<adf>, bov> models;

    public MultiLayerModel(ImmutableMap<Optional<adf>, bov> models) {
        this.models = models;
    }

    @Override
    public Collection<jy> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<jy> getTextures() {
        return ImmutableList.of();
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        return new MultiLayerBakedModel(this.models, format, IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (adf layer : adf.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return instance;
        }
        return new MultiLayerModel((ImmutableMap<Optional<adf>, bov>)models);
    }

    private bov getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new bov(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new bov("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        instance;


        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(jy modelLocation) {
            return instance;
        }
    }

    public static class MultiLayerBakedModel
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    IPerspectiveAwareModel {
        private final ImmutableMap<Optional<adf>, bov> models;
        private final bmu format;
        private final ImmutableMap<bgr.b, TRSRTransformation> cameraTransforms;
        private boq missing;
        private boq base;
        private ImmutableMap<adf, boq> bakedModels;
        private ImmutableMap<Optional<cq>, ImmutableList<bgg>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<adf>, bov> models, bmu format, ImmutableMap<bgr.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.format = format;
            this.cameraTransforms = cameraTransforms;
        }

        private void compute() {
            if (this.base == null) {
                bou manager = ave.A().ae().a().b();
                this.missing = manager.a();
                this.base = this.getModel(manager, (Optional<adf>)Optional.absent());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (adf layer : adf.values()) {
                    if (!this.models.containsKey((Object)Optional.of((Object)layer))) continue;
                    builder.put((Object)layer, (Object)this.getModel(manager, (Optional<adf>)Optional.of((Object)layer)));
                }
                this.bakedModels = builder.build();
                ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
                quadBuilder.put((Object)Optional.absent(), this.buildQuads((Optional<cq>)Optional.absent()));
                for (cq side : cq.values()) {
                    quadBuilder.put((Object)Optional.of((Object)side), this.buildQuads((Optional<cq>)Optional.of((Object)side)));
                }
                this.quads = quadBuilder.build();
            }
        }

        private boq getModel(bou manager, Optional<adf> layer) {
            bov loc = (bov)this.models.get(layer);
            if (loc == null) {
                loc = new bov("builtin/missing", "missing");
            }
            return manager.a(loc);
        }

        private ImmutableList<bgg> buildQuads(Optional<cq> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (boq model : this.bakedModels.values()) {
                if (side.isPresent()) {
                    builder.addAll((Iterable)model.a((cq)side.get()));
                    continue;
                }
                builder.addAll((Iterable)model.a());
            }
            return builder.build();
        }

        public List<bgg> a(cq side) {
            this.compute();
            return (List)this.quads.get((Object)Optional.of((Object)side));
        }

        public List<bgg> a() {
            this.compute();
            return (List)this.quads.get((Object)Optional.absent());
        }

        public boolean b() {
            this.compute();
            return this.base.b();
        }

        public boolean c() {
            this.compute();
            return this.base.c();
        }

        public boolean d() {
            this.compute();
            return this.base.d();
        }

        public bmi e() {
            this.compute();
            return this.base.e();
        }

        public bgr f() {
            return bgr.a;
        }

        @Override
        public boq handleBlockState(alz state) {
            this.compute();
            adf layer = MinecraftForgeClient.getRenderLayer();
            if (!this.bakedModels.containsKey((Object)layer)) {
                return this.missing;
            }
            return (boq)this.bakedModels.get((Object)layer);
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.cameraTransforms, cameraTransformType);
        }
    }
}

