/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemFluidContainer
extends zw
implements IFluidContainerItem {
    protected int capacity;

    public ItemFluidContainer(int itemID) {
    }

    public ItemFluidContainer(int itemID, int capacity) {
        this.capacity = capacity;
    }

    public ItemFluidContainer setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public FluidStack getFluid(zx container) {
        if (!container.n() || !container.o().c("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT(container.o().m("Fluid"));
    }

    @Override
    public int getCapacity(zx container) {
        return this.capacity;
    }

    @Override
    public int fill(zx container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (!container.n() || !container.o().c("Fluid")) {
                return Math.min(this.capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT(container.o().m("Fluid"));
            if (stack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - stack.amount, resource.amount);
        }
        if (!container.n()) {
            container.d(new dn());
        }
        if (!container.o().c("Fluid")) {
            dn fluidTag = resource.writeToNBT(new dn());
            if (this.capacity < resource.amount) {
                fluidTag.a("Amount", this.capacity);
                container.o().a("Fluid", (eb)fluidTag);
                return this.capacity;
            }
            container.o().a("Fluid", (eb)fluidTag);
            return resource.amount;
        }
        dn fluidTag = container.o().m("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT(fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.capacity;
        }
        container.o().a("Fluid", (eb)stack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public FluidStack drain(zx container, int maxDrain, boolean doDrain) {
        if (!container.n() || !container.o().c("Fluid")) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT(container.o().m("Fluid"));
        if (stack == null) {
            return null;
        }
        int currentAmount = stack.amount;
        stack.amount = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (currentAmount == stack.amount) {
                container.o().o("Fluid");
                if (container.o().c_()) {
                    container.d(null);
                }
                return stack;
            }
            dn fluidTag = container.o().m("Fluid");
            fluidTag.a("Amount", currentAmount - stack.amount);
            container.o().a("Fluid", (eb)fluidTag);
        }
        return stack;
    }
}

