/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class FMLContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw", "LexManos", "Player");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. ";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), null, evt.getASMHarvestedData());
        FMLNetworkHandler.registerChannel(this, evt.getSide());
    }

    @Subscribe
    public void modPreinitialization(FMLPreInitializationEvent evt) {
        VillagerRegistry.instance();
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return Loader.instance().checkRemoteModList(modList, side);
    }

    @Override
    public dn getDataForWriting(atm handler, ato info) {
        dn fmlData = new dn();
        du modList = new du();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            dn mod = new dn();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            modList.a((eb)mod);
        }
        fmlData.a("ModList", (eb)modList);
        dn registries = new dn();
        fmlData.a("Registries", (eb)registries);
        FMLLog.fine("Gathering id map for writing to world save %s", info.k());
        PersistentRegistryManager.GameDataSnapshot dataSnapshot = PersistentRegistryManager.takeSnapshot();
        for (Map.Entry<jy, PersistentRegistryManager.GameDataSnapshot.Entry> e2 : dataSnapshot.entries.entrySet()) {
            dn data = new dn();
            registries.a(e2.getKey().toString(), (eb)data);
            du ids = new du();
            for (Map.Entry<jy, Integer> item : e2.getValue().ids.entrySet()) {
                dn tag = new dn();
                tag.a("K", item.getKey().toString());
                tag.a("V", item.getValue().intValue());
                ids.a((eb)tag);
            }
            data.a("ids", (eb)ids);
            du aliases = new du();
            for (Map.Entry<jy, jy> entry : e2.getValue().aliases.entrySet()) {
                dn tag = new dn();
                tag.a("K", entry.getKey().toString());
                tag.a("V", entry.getValue().toString());
                aliases.a((eb)tag);
            }
            data.a("aliases", (eb)aliases);
            du subs = new du();
            for (jy entry : e2.getValue().substitutions) {
                dn tag = new dn();
                tag.a("K", entry.toString());
                subs.a((eb)tag);
            }
            data.a("substitutions", (eb)subs);
            int[] blocked = new int[e2.getValue().blocked.size()];
            int idx = 0;
            for (Integer i2 : e2.getValue().blocked) {
                blocked[idx++] = i2;
            }
            data.a("blocked", blocked);
        }
        return fmlData;
    }

    @Override
    public void readData(atm handler, ato info, Map<String, eb> propertyMap, dn tag) {
        if (tag.c("ModList")) {
            du modList = tag.c("ModList", 10);
            for (int i2 = 0; i2 < modList.c(); ++i2) {
                dn mod = modList.b(i2);
                String modId = mod.j("ModId");
                String modVersion = mod.j("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.ERROR, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        List<String> failedElements = null;
        if (tag.c("ModItemData")) {
            StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
            StartupQuery.abort();
        } else if (tag.c("ItemData")) {
            int i3;
            if (!tag.c("BlockedItemIds")) {
                StartupQuery.notify("This save predates 1.7.10, it can no longer be loaded here. Please load in 1.7.10 or 1.8 first");
                StartupQuery.abort();
            }
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            PersistentRegistryManager.GameDataSnapshot.Entry blocks = new PersistentRegistryManager.GameDataSnapshot.Entry();
            PersistentRegistryManager.GameDataSnapshot.Entry items = new PersistentRegistryManager.GameDataSnapshot.Entry();
            snapshot.entries.put(PersistentRegistryManager.BLOCKS, blocks);
            snapshot.entries.put(PersistentRegistryManager.ITEMS, items);
            du list = tag.c("ItemData", 10);
            for (int i4 = 0; i4 < list.c(); ++i4) {
                dn e2 = list.b(i4);
                String name = e2.j("K");
                if (name.charAt(0) == '\u0001') {
                    blocks.ids.put(new jy(name.substring(1)), e2.f("V"));
                    continue;
                }
                if (name.charAt(0) != '\u0002') continue;
                items.ids.put(new jy(name.substring(1)), e2.f("V"));
            }
            HashSet<Integer> blockedIds = new HashSet<Integer>();
            for (int id : tag.l("BlockedItemIds")) {
                blockedIds.add(id);
            }
            blocks.blocked.addAll(blockedIds);
            items.blocked.addAll(blockedIds);
            list = tag.c("BlockAliases", 10);
            for (i3 = 0; i3 < list.c(); ++i3) {
                dn dataTag = list.b(i3);
                blocks.aliases.put(new jy(dataTag.j("K")), new jy(dataTag.j("V")));
            }
            if (tag.b("BlockSubstitutions", 9)) {
                list = tag.c("BlockSubstitutions", 10);
                for (i3 = 0; i3 < list.c(); ++i3) {
                    dn dataTag = list.b(i3);
                    blocks.substitutions.add(new jy(dataTag.j("K")));
                }
            }
            list = tag.c("ItemAliases", 10);
            for (i3 = 0; i3 < list.c(); ++i3) {
                dn dataTag = list.b(i3);
                items.aliases.put(new jy(dataTag.j("K")), new jy(dataTag.j("V")));
            }
            if (tag.b("ItemSubstitutions", 9)) {
                list = tag.c("ItemSubstitutions", 10);
                for (i3 = 0; i3 < list.c(); ++i3) {
                    dn dataTag = list.b(i3);
                    items.substitutions.add(new jy(dataTag.j("K")));
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        } else if (tag.c("Registries")) {
            PersistentRegistryManager.GameDataSnapshot snapshot = new PersistentRegistryManager.GameDataSnapshot();
            dn regs = tag.m("Registries");
            for (String key : regs.c()) {
                int[] blocked;
                dn e3;
                int x;
                PersistentRegistryManager.GameDataSnapshot.Entry entry = new PersistentRegistryManager.GameDataSnapshot.Entry();
                jy entryLoc = "fml:blocks".equals(key) ? PersistentRegistryManager.BLOCKS : ("fml:items".equals(key) ? PersistentRegistryManager.ITEMS : ("fmlgr:villagerprofessions".equals(key) ? VillagerRegistry.PROFESSIONS : new jy(key)));
                snapshot.entries.put(entryLoc, entry);
                du list = regs.m(key).c("ids", 10);
                for (x = 0; x < list.c(); ++x) {
                    e3 = list.b(x);
                    entry.ids.put(new jy(e3.j("K")), e3.f("V"));
                }
                list = regs.m(key).c("aliases", 10);
                for (x = 0; x < list.c(); ++x) {
                    e3 = list.b(x);
                    entry.aliases.put(new jy(e3.j("K")), new jy(e3.j("V")));
                }
                list = regs.m(key).c("substitutions", 10);
                for (x = 0; x < list.c(); ++x) {
                    e3 = list.b(x);
                    entry.substitutions.add(new jy(e3.j("K")));
                }
                for (int i5 : blocked = regs.m(key).l("blocked")) {
                    entry.blocked.add(i5);
                }
            }
            failedElements = PersistentRegistryManager.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            String text = "Forge Mod Loader could not load this save.\n\nThere are " + failedElements.size() + " unassigned blocks and items in this save.\n" + "You will not be able to load until they are present again.\n\n" + "Missing Blocks/Items:\n";
            for (String s : failedElements) {
                text = text + s + "\n";
            }
            StartupQuery.notify(text);
            StartupQuery.abort();
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }

    @Override
    public File getSource() {
        return FMLSanityChecker.fmlLocation;
    }

    @Override
    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    @Override
    public String getGuiClassName() {
        return "net.minecraftforge.fml.client.FMLConfigGuiFactory";
    }

    @Override
    public Object getMod() {
        return this;
    }
}

