/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.IHandshakeState;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.relauncher.Side;

enum FMLHandshakeClientState implements IHandshakeState<FMLHandshakeClientState>
{
    START{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.clientListenForServerHandshake();
            return HELLO;
        }
    }
    ,
    HELLO{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            ctx.writeAndFlush((Object)FMLHandshakeMessage.makeCustomChannelRegistration(NetworkRegistry.INSTANCE.channelNamesFor(Side.CLIENT)));
            if (msg == null) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.abortClientHandshake("VANILLA");
                return DONE;
            }
            FMLHandshakeMessage.ServerHello serverHelloPacket = (FMLHandshakeMessage.ServerHello)msg;
            FMLLog.info("Server protocol version %x", serverHelloPacket.protocolVersion());
            if (serverHelloPacket.protocolVersion() > 1) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.setOverrideDimension(serverHelloPacket.overrideDim());
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ClientHello()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.ModList(Loader.instance().getActiveModList())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return WAITINGSERVERDATA;
        }
    }
    ,
    WAITINGSERVERDATA{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            String result = FMLNetworkHandler.checkModList((FMLHandshakeMessage.ModList)msg, Side.SERVER);
            if (result != null) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake(result);
                return ERROR;
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            if (!((Boolean)ctx.channel().attr(NetworkDispatcher.IS_LOCAL).get()).booleanValue()) {
                return WAITINGSERVERCOMPLETE;
            }
            return PENDINGCOMPLETE;
        }
    }
    ,
    WAITINGSERVERCOMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            FMLHandshakeMessage.RegistryData pkt = (FMLHandshakeMessage.RegistryData)msg;
            PersistentRegistryManager.GameDataSnapshot snap = (PersistentRegistryManager.GameDataSnapshot)ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).get();
            if (snap == null) {
                snap = new PersistentRegistryManager.GameDataSnapshot();
                ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).set((Object)snap);
            }
            PersistentRegistryManager.GameDataSnapshot.Entry entry = new PersistentRegistryManager.GameDataSnapshot.Entry();
            entry.ids.putAll(pkt.getIdMap());
            entry.substitutions.addAll(pkt.getSubstitutions());
            snap.entries.put(pkt.getName(), entry);
            if (pkt.hasMore()) {
                FMLLog.fine("Received Mod Registry mapping for %s: %d IDs %d subs", pkt.getName(), entry.ids.size(), entry.substitutions.size());
                return WAITINGSERVERCOMPLETE;
            }
            ctx.channel().attr(NetworkDispatcher.FML_GAMEDATA_SNAPSHOT).remove();
            List<String> locallyMissing = PersistentRegistryManager.injectSnapshot(snap, false, false);
            if (!locallyMissing.isEmpty()) {
                NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
                dispatcher.rejectHandshake("Fatally missing blocks and items");
                FMLLog.severe("Failed to connect to server: there are %d missing blocks and items", locallyMissing.size());
                FMLLog.fine("Missing list: %s", locallyMissing);
                return ERROR;
            }
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return PENDINGCOMPLETE;
        }
    }
    ,
    PENDINGCOMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return COMPLETE;
        }
    }
    ,
    COMPLETE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            NetworkDispatcher dispatcher = (NetworkDispatcher)((Object)ctx.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
            dispatcher.completeClientHandshake();
            FMLMessage.CompleteHandshake complete = new FMLMessage.CompleteHandshake(Side.CLIENT);
            ctx.fireChannelRead((Object)complete);
            ctx.writeAndFlush((Object)new FMLHandshakeMessage.HandshakeAck(this.ordinal())).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            return DONE;
        }
    }
    ,
    DONE{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            if (msg instanceof FMLHandshakeMessage.HandshakeReset) {
                PersistentRegistryManager.revertToFrozen();
                return HELLO;
            }
            return this;
        }
    }
    ,
    ERROR{

        @Override
        public FMLHandshakeClientState accept(ChannelHandlerContext ctx, FMLHandshakeMessage msg) {
            return this;
        }
    };

}

