/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>();
    private static List<List<zx>> idToStack = Lists.newArrayList();
    private static List<List<zx>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMap();
    public static final ImmutableList<zx> EMPTY_LIST = ImmutableList.of();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new zx(afi.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new zx(afi.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new zx(afi.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new zx((afh)afi.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", afi.ad);
            OreDictionary.registerOre("stairWood", afi.bU);
            OreDictionary.registerOre("stairWood", afi.bV);
            OreDictionary.registerOre("stairWood", afi.bW);
            OreDictionary.registerOre("stairWood", afi.cC);
            OreDictionary.registerOre("stairWood", afi.cD);
            OreDictionary.registerOre("stickWood", zy.y);
            OreDictionary.registerOre("treeSapling", new zx(afi.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new zx((afh)afi.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new zx((afh)afi.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", afi.o);
            OreDictionary.registerOre("oreIron", afi.p);
            OreDictionary.registerOre("oreLapis", afi.x);
            OreDictionary.registerOre("oreDiamond", afi.ag);
            OreDictionary.registerOre("oreRedstone", afi.aC);
            OreDictionary.registerOre("oreEmerald", afi.bP);
            OreDictionary.registerOre("oreQuartz", afi.co);
            OreDictionary.registerOre("oreCoal", afi.q);
            OreDictionary.registerOre("blockGold", afi.R);
            OreDictionary.registerOre("blockIron", afi.S);
            OreDictionary.registerOre("blockLapis", afi.y);
            OreDictionary.registerOre("blockDiamond", afi.ah);
            OreDictionary.registerOre("blockRedstone", afi.cn);
            OreDictionary.registerOre("blockEmerald", afi.bT);
            OreDictionary.registerOre("blockQuartz", afi.cq);
            OreDictionary.registerOre("blockCoal", afi.cA);
            OreDictionary.registerOre("blockGlassColorless", afi.w);
            OreDictionary.registerOre("blockGlass", afi.w);
            OreDictionary.registerOre("blockGlass", new zx((afh)afi.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", afi.bj);
            OreDictionary.registerOre("paneGlass", afi.bj);
            OreDictionary.registerOre("paneGlass", new zx((afh)afi.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("ingotIron", zy.j);
            OreDictionary.registerOre("ingotGold", zy.k);
            OreDictionary.registerOre("ingotBrick", zy.aH);
            OreDictionary.registerOre("ingotBrickNether", zy.cf);
            OreDictionary.registerOre("nuggetGold", zy.bx);
            OreDictionary.registerOre("gemDiamond", zy.i);
            OreDictionary.registerOre("gemEmerald", zy.bO);
            OreDictionary.registerOre("gemQuartz", zy.cg);
            OreDictionary.registerOre("dustRedstone", zy.aC);
            OreDictionary.registerOre("dustGlowstone", zy.aT);
            OreDictionary.registerOre("gemLapis", new zx(zy.aW, 1, 4));
            OreDictionary.registerOre("slimeball", zy.aM);
            OreDictionary.registerOre("glowstone", afi.aX);
            OreDictionary.registerOre("cropWheat", zy.O);
            OreDictionary.registerOre("cropPotato", zy.bS);
            OreDictionary.registerOre("cropCarrot", zy.bR);
            OreDictionary.registerOre("stone", afi.b);
            OreDictionary.registerOre("cobblestone", afi.e);
            OreDictionary.registerOre("sandstone", new zx(afi.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sand", new zx((afh)afi.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("dye", new zx(zy.aW, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("record", zy.cq);
            OreDictionary.registerOre("record", zy.cr);
            OreDictionary.registerOre("record", zy.cs);
            OreDictionary.registerOre("record", zy.ct);
            OreDictionary.registerOre("record", zy.cu);
            OreDictionary.registerOre("record", zy.cv);
            OreDictionary.registerOre("record", zy.cw);
            OreDictionary.registerOre("record", zy.cx);
            OreDictionary.registerOre("record", zy.cy);
            OreDictionary.registerOre("record", zy.cz);
            OreDictionary.registerOre("record", zy.cA);
            OreDictionary.registerOre("record", zy.cB);
            OreDictionary.registerOre("chest", (afh)afi.ae);
            OreDictionary.registerOre("chest", afi.bQ);
            OreDictionary.registerOre("chest", afi.cg);
            OreDictionary.registerOre("chestWood", (afh)afi.ae);
            OreDictionary.registerOre("chestEnder", afi.bQ);
            OreDictionary.registerOre("chestTrapped", afi.cg);
        }
        HashMap<zx, String> replacements = new HashMap<zx, String>();
        replacements.put(new zx(zy.y), "stickWood");
        replacements.put(new zx(afi.f), "plankWood");
        replacements.put(new zx(afi.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new zx((afh)afi.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new zx(afi.b), "stone");
        replacements.put(new zx(afi.e), "cobblestone");
        replacements.put(new zx(afi.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new zx(zy.k), "ingotGold");
        replacements.put(new zx(zy.j), "ingotIron");
        replacements.put(new zx(zy.i), "gemDiamond");
        replacements.put(new zx(zy.bO), "gemEmerald");
        replacements.put(new zx(zy.aC), "dustRedstone");
        replacements.put(new zx(zy.aT), "dustGlowstone");
        replacements.put(new zx(afi.aX), "glowstone");
        replacements.put(new zx(zy.aM), "slimeball");
        replacements.put(new zx(afi.w), "blockGlassColorless");
        replacements.put(new zx((afh)afi.ae), "chestWood");
        replacements.put(new zx(afi.bQ), "chestEnder");
        replacements.put(new zx(afi.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i2 = 0; i2 < 16; ++i2) {
            zx dye = new zx(zy.aW, 1, i2);
            zx block = new zx((afh)afi.cG, 1, 15 - i2);
            zx pane = new zx((afh)afi.cH, 1, 15 - i2);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i2], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i2], block);
                OreDictionary.registerOre("paneGlass" + dyes[i2], pane);
            }
            replacements.put(dye, "dye" + dyes[i2]);
            replacements.put(block, "blockGlass" + dyes[i2]);
            replacements.put(pane, "paneGlass" + dyes[i2]);
        }
        hasInit = true;
        zx[] replaceStacks = replacements.keySet().toArray(new zx[replacements.keySet().size()]);
        zx[] exclusions = new zx[]{new zx(afi.y), new zx(zy.bc), new zx(afi.bf), new zx((afh)afi.U, 1, Short.MAX_VALUE), new zx(afi.aw), new zx(afi.bZ), new zx(afi.aO), new zx(afi.bo), new zx(afi.ad), new zx(afi.aP), new zx(afi.bp), new zx(afi.bU), new zx(afi.aQ), new zx(afi.bq), new zx(afi.bV), new zx(afi.aR), new zx(afi.br), new zx(afi.bW), new zx(afi.aT), new zx(afi.bt), new zx(afi.cC), new zx(afi.aS), new zx(afi.bs), new zx(afi.cD), new zx((afh)afi.bM), new zx(afi.bj), null};
        List recipes = abt.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            zx output;
            abv recipe;
            if (obj instanceof abv) {
                recipe = (abv)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof abw) || (output = (recipe = (abw)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new zx[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((abs)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((abw)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipies", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            ArrayList back = Lists.newArrayList();
            idToStack.add(back);
            idToStackUn.add(Collections.unmodifiableList(back));
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(zx stack) {
        if (stack == null || stack.b() == null) {
            throw new IllegalArgumentException("Stack can not be null!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        jy registryName = stack.b().delegate.getResourceName();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.h() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static List<zx> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static List<zx> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, zx[] inputs, zx ... targets) {
        for (zx input : inputs) {
            for (zx target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, List<zx> inputs, zx ... targets) {
        for (zx input : inputs) {
            for (zx target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(zx target, zx input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.h() == Short.MAX_VALUE && !strict || target.h() == input.h());
    }

    public static void registerOre(String name, zw ore) {
        OreDictionary.registerOre(name, new zx(ore));
    }

    public static void registerOre(String name, afh ore) {
        OreDictionary.registerOre(name, new zx(ore));
    }

    public static void registerOre(String name, zx ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, zx ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore == null || ore.b() == null) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        jy registryName = ore.b().delegate.getResourceName();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.b().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.h() != Short.MAX_VALUE) {
            hash |= ore.h() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.k();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            List<zx> ores = idToStack.get(id);
            if (ores == null) continue;
            for (zx ore : ores) {
                ArrayList ids;
                int hash;
                jy name = ore.b().delegate.getResourceName();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id), ore.b().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.h() != Short.MAX_VALUE) {
                    hash |= ore.h() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final zx Ore;

        public OreRegisterEvent(String name, zx ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

