/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public class OBJModel
implements IRetexturableModel<OBJModel>,
IModelCustomData<OBJModel> {
    private MaterialLibrary matLib;
    private final jy modelLocation;
    private CustomData customData;

    public OBJModel(MaterialLibrary matLib, jy modelLocation) {
        this(matLib, modelLocation, new CustomData());
    }

    public OBJModel(MaterialLibrary matLib, jy modelLocation, CustomData customData) {
        this.matLib = matLib;
        this.modelLocation = modelLocation;
        this.customData = customData;
    }

    @Override
    public Collection<jy> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public Collection<jy> getTextures() {
        Iterator materialIterator = this.matLib.materials.values().iterator();
        ArrayList textures = Lists.newArrayList();
        while (materialIterator.hasNext()) {
            Material mat = (Material)materialIterator.next();
            jy textureLoc = new jy(mat.getTexture().getPath());
            if (textures.contains(textureLoc) || mat.isWhite()) continue;
            textures.add(textureLoc);
        }
        return textures;
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)ModelLoader.White.loc.toString(), (Object)ModelLoader.White.instance);
        bmi missing = (bmi)bakedTextureGetter.apply((Object)new jy("missingno"));
        for (Map.Entry e : this.matLib.materials.entrySet()) {
            if (((Material)e.getValue()).getTexture().getTextureLocation().a().startsWith("#")) {
                FMLLog.severe("OBJLoader: Unresolved texture '%s' for obj model '%s'", ((Material)e.getValue()).getTexture().getTextureLocation().a(), this.modelLocation);
                builder.put(e.getKey(), (Object)missing);
                continue;
            }
            builder.put(e.getKey(), bakedTextureGetter.apply((Object)((Material)e.getValue()).getTexture().getTextureLocation()));
        }
        builder.put((Object)"missingno", (Object)missing);
        return new OBJBakedModel(this, state, format, (ImmutableMap<String, bmi>)builder.build());
    }

    public MaterialLibrary getMatLib() {
        return this.matLib;
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        OBJModel ret = new OBJModel(this.matLib, this.modelLocation, new CustomData(this.customData, customData));
        return ret;
    }

    @Override
    public IModel retexture(ImmutableMap<String, String> textures) {
        OBJModel ret = new OBJModel(this.matLib.makeLibWithReplacements(textures), this.modelLocation, this.customData);
        return ret;
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class UVsOutOfBoundsException
    extends RuntimeException {
        public jy modelLocation;

        public UVsOutOfBoundsException(jy modelLocation) {
            super(String.format("Model '%s' has UVs ('vt') out of bounds 0-1! The missing model will be used instead. Support for UV processing will be added to the OBJ loader in the future.", modelLocation));
            this.modelLocation = modelLocation;
        }
    }

    public class OBJBakedModel
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    ISmartItemModel,
    IPerspectiveAwareModel {
        private final OBJModel model;
        private IModelState state;
        private final bmu format;
        private Set<bgg> quads;
        private ImmutableMap<String, bmi> textures;
        private bmi sprite = ModelLoader.White.instance;
        private final LoadingCache<IModelState, OBJBakedModel> cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<IModelState, OBJBakedModel>(){

            public OBJBakedModel load(IModelState state) throws Exception {
                return new OBJBakedModel(OBJBakedModel.this.model, state, OBJBakedModel.this.format, (ImmutableMap<String, bmi>)OBJBakedModel.this.textures);
            }
        });

        public OBJBakedModel(OBJModel model, IModelState state, bmu format, ImmutableMap<String, bmi> textures) {
            this.model = model;
            this.state = state;
            if (this.state instanceof OBJState) {
                this.updateStateVisibilityMap((OBJState)this.state);
            }
            this.format = format;
            this.textures = textures;
        }

        public void scheduleRebake() {
            this.quads = null;
        }

        public List<bgg> a(cq side) {
            return Collections.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        public List<bgg> a() {
            if (this.quads == null) {
                Vertex[] state;
                this.quads = Collections.synchronizedSet(new LinkedHashSet());
                Set<Face> faces = Collections.synchronizedSet(new LinkedHashSet());
                Optional<TRSRTransformation> transform = Optional.absent();
                for (Group g2 : this.model.getMatLib().getGroups().values()) {
                    if (this.state instanceof OBJState) {
                        state = (Vertex[])this.state;
                        if (state.parent != null) {
                            transform = state.parent.apply((Optional<? extends IModelPart>)Optional.absent());
                        }
                        if (state.getGroupNamesFromMap().contains("OBJModel.Group.All.Key")) {
                            state.visibilityMap.clear();
                            for (String string : this.model.getMatLib().getGroups().keySet()) {
                                state.visibilityMap.put(string, state.operation.performOperation(true));
                            }
                        } else if (state.getGroupNamesFromMap().contains("OBJModel.Group.All.Except.Key")) {
                            List<String> exceptList = state.getGroupNamesFromMap().subList(1, state.getGroupNamesFromMap().size());
                            state.visibilityMap.clear();
                            for (String s2 : this.model.getMatLib().getGroups().keySet()) {
                                if (exceptList.contains(s2)) continue;
                                state.visibilityMap.put(s2, state.operation.performOperation(true));
                            }
                        } else {
                            for (String string : state.visibilityMap.keySet()) {
                                state.visibilityMap.put(string, state.operation.performOperation(state.visibilityMap.get(string)));
                            }
                        }
                        if (!state.getGroupsWithVisibility(true).contains(g2.getName())) continue;
                        faces.addAll(g2.applyTransform(transform));
                        continue;
                    }
                    transform = this.state.apply((Optional<? extends IModelPart>)Optional.absent());
                    faces.addAll(g2.applyTransform(transform));
                }
                for (Face f : faces) {
                    if (((Material)this.model.getMatLib().materials.get(f.getMaterialName())).isWhite()) {
                        void var7_14;
                        state = f.getVertices();
                        int exceptList = state.length;
                        boolean bl = false;
                        while (var7_14 < exceptList) {
                            Vertex v = state[var7_14];
                            if (!v.getMaterial().equals(this.model.getMatLib().getMaterial(v.getMaterial().getName()))) {
                                v.setMaterial(this.model.getMatLib().getMaterial(v.getMaterial().getName()));
                            }
                            ++var7_14;
                        }
                        this.sprite = ModelLoader.White.instance;
                    } else {
                        this.sprite = (bmi)this.textures.get((Object)f.getMaterialName());
                    }
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
                    builder.setQuadOrientation(cq.a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                    builder.setQuadColored();
                    Normal faceNormal = f.getNormal();
                    this.putVertexData(builder, f.verts[0], faceNormal, TextureCoordinate.getDefaultUVs()[0], this.sprite);
                    this.putVertexData(builder, f.verts[1], faceNormal, TextureCoordinate.getDefaultUVs()[1], this.sprite);
                    this.putVertexData(builder, f.verts[2], faceNormal, TextureCoordinate.getDefaultUVs()[2], this.sprite);
                    this.putVertexData(builder, f.verts[3], faceNormal, TextureCoordinate.getDefaultUVs()[3], this.sprite);
                    this.quads.add(builder.build());
                }
            }
            List<bgg> quadList = Collections.synchronizedList(Lists.newArrayList(this.quads));
            return quadList;
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, Vertex v, Normal faceNormal, TextureCoordinate defUV, bmi sprite) {
            block6: for (int e = 0; e < this.format.i(); ++e) {
                switch (this.format.c(e).b()) {
                    case a: {
                        builder.put(e, v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w);
                        continue block6;
                    }
                    case c: {
                        float d2 = v.hasNormal() ? LightUtil.diffuseLight(v.getNormal().x, v.getNormal().y, v.getNormal().z) : LightUtil.diffuseLight(faceNormal.x, faceNormal.y, faceNormal.z);
                        if (v.getMaterial() != null) {
                            builder.put(e, d2 * v.getMaterial().getColor().x, d2 * v.getMaterial().getColor().y, d2 * v.getMaterial().getColor().z, v.getMaterial().getColor().w);
                            continue block6;
                        }
                        builder.put(e, d2, d2, d2, 1.0f);
                        continue block6;
                    }
                    case d: {
                        if (!v.hasTextureCoordinate()) {
                            builder.put(e, sprite.a((double)(defUV.u * 16.0f)), sprite.b((double)((((OBJModel)this.model).customData.flipV ? 1.0f - defUV.v : defUV.v) * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        builder.put(e, sprite.a((double)(v.getTextureCoordinate().u * 16.0f)), sprite.b((double)((((OBJModel)this.model).customData.flipV ? 1.0f - v.getTextureCoordinate().v : v.getTextureCoordinate().v) * 16.0f)), 0.0f, 1.0f);
                        continue block6;
                    }
                    case b: {
                        if (!v.hasNormal()) {
                            builder.put(e, faceNormal.x, faceNormal.y, faceNormal.z, 0.0f);
                            continue block6;
                        }
                        builder.put(e, v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean b() {
            return this.model != null ? ((OBJModel)this.model).customData.ambientOcclusion : true;
        }

        public boolean c() {
            return this.model != null ? ((OBJModel)this.model).customData.gui3d : true;
        }

        public boolean d() {
            return false;
        }

        public bmi e() {
            return this.sprite;
        }

        public bgr f() {
            return bgr.a;
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }

        @Override
        public boq handleItemState(zx stack) {
            return this;
        }

        @Override
        public OBJBakedModel handleBlockState(alz state) {
            OBJState s;
            IExtendedBlockState exState;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(OBJProperty.instance) && (s = exState.getValue(OBJProperty.instance)) != null) {
                if (s.visibilityMap.containsKey("OBJModel.Group.All.Key") || s.visibilityMap.containsKey("OBJModel.Group.All.Except.Key")) {
                    this.updateStateVisibilityMap(s);
                }
                return this.getCachedModel(s);
            }
            return this;
        }

        private void updateStateVisibilityMap(OBJState state) {
            if (state.visibilityMap.containsKey("OBJModel.Group.All.Key")) {
                boolean operation = state.visibilityMap.get("OBJModel.Group.All.Key");
                state.visibilityMap.clear();
                for (String s : this.model.getMatLib().getGroups().keySet()) {
                    state.visibilityMap.put(s, state.operation.performOperation(operation));
                }
            } else if (state.visibilityMap.containsKey("OBJModel.Group.All.Except.Key")) {
                List<String> exceptList = state.getGroupNamesFromMap().subList(1, state.getGroupNamesFromMap().size());
                state.visibilityMap.remove("OBJModel.Group.All.Except.Key");
                for (String s : this.model.getMatLib().getGroups().keySet()) {
                    if (exceptList.contains(s)) continue;
                    state.visibilityMap.put(s, state.operation.performOperation(state.visibilityMap.get(s)));
                }
            } else {
                for (String s : state.visibilityMap.keySet()) {
                    state.visibilityMap.put(s, state.operation.performOperation(state.visibilityMap.get(s)));
                }
            }
        }

        public OBJBakedModel getCachedModel(IModelState state) {
            return (OBJBakedModel)this.cache.getUnchecked((Object)state);
        }

        public OBJModel getModel() {
            return this.model;
        }

        public IModelState getState() {
            return this.state;
        }

        public OBJBakedModel getBakedModel() {
            return new OBJBakedModel(this.model, this.state, this.format, this.textures);
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.state, cameraTransformType);
        }

        public String toString() {
            return this.model.modelLocation.toString();
        }
    }

    public static enum OBJProperty implements IUnlistedProperty<OBJState>
    {
        instance;


        @Override
        public String getName() {
            return "OBJPropery";
        }

        @Override
        public boolean isValid(OBJState value) {
            return value instanceof OBJState;
        }

        @Override
        public Class<OBJState> getType() {
            return OBJState.class;
        }

        @Override
        public String valueToString(OBJState value) {
            return value.toString();
        }
    }

    public static class OBJState
    implements IModelState {
        protected Map<String, Boolean> visibilityMap = Maps.newHashMap();
        public IModelState parent;
        protected Operation operation = Operation.SET_TRUE;

        public OBJState(List<String> visibleGroups, boolean visibility) {
            this(visibleGroups, visibility, TRSRTransformation.identity());
        }

        public OBJState(List<String> visibleGroups, boolean visibility, IModelState parent) {
            this.parent = parent;
            for (String s : visibleGroups) {
                this.visibilityMap.put(s, visibility);
            }
        }

        public IModelState getParent(IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof OBJState) {
                return ((OBJState)parent).parent;
            }
            return parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            if (this.parent != null) {
                return this.parent.apply(part);
            }
            return Optional.absent();
        }

        public Map<String, Boolean> getVisibilityMap() {
            return this.visibilityMap;
        }

        public List<String> getGroupsWithVisibility(boolean visibility) {
            ArrayList ret = Lists.newArrayList();
            for (Map.Entry<String, Boolean> e : this.visibilityMap.entrySet()) {
                if (e.getValue() != visibility) continue;
                ret.add(e.getKey());
            }
            return ret;
        }

        public List<String> getGroupNamesFromMap() {
            return Lists.newArrayList(this.visibilityMap.keySet());
        }

        public void changeGroupVisibilities(List<String> names, Operation operation) {
            if (names == null || names.isEmpty()) {
                return;
            }
            this.operation = operation;
            if (names.get(0).equals("OBJModel.Group.All.Key")) {
                for (String s : this.visibilityMap.keySet()) {
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            } else if (names.get(0).equals("OBJModel.Group.All.Except.Key")) {
                for (String s : this.visibilityMap.keySet()) {
                    if (names.subList(1, names.size()).contains(s)) continue;
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            } else {
                for (String s : names) {
                    this.visibilityMap.put(s, this.operation.performOperation(this.visibilityMap.get(s)));
                }
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("OBJState: ");
            builder.append(String.format("%n    parent: %s%n", this.parent.toString()));
            builder.append(String.format("    visibility map: %n", new Object[0]));
            for (Map.Entry<String, Boolean> e : this.visibilityMap.entrySet()) {
                builder.append(String.format("        name: %s visible: %b%n", e.getKey(), e.getValue()));
            }
            return builder.toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.visibilityMap, this.parent, this.operation});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OBJState other = (OBJState)obj;
            return Objects.equal(this.visibilityMap, other.visibilityMap) && Objects.equal((Object)this.parent, (Object)other.parent) && this.operation == other.operation;
        }

        public static enum Operation {
            SET_TRUE,
            SET_FALSE,
            TOGGLE;


            public boolean performOperation(boolean valueToToggle) {
                switch (this) {
                    default: {
                        return true;
                    }
                    case SET_FALSE: {
                        return false;
                    }
                    case TOGGLE: 
                }
                return !valueToToggle;
            }
        }
    }

    public static class Group
    implements IModelPart {
        public static final String DEFAULT_NAME = "OBJModel.Default.Element.Name";
        public static final String ALL = "OBJModel.Group.All.Key";
        public static final String ALL_EXCEPT = "OBJModel.Group.All.Except.Key";
        private String name = "OBJModel.Default.Element.Name";
        private LinkedHashSet<Face> faces = new LinkedHashSet();
        public float[] minUVBounds = new float[]{0.0f, 0.0f};
        public float[] maxUVBounds = new float[]{1.0f, 1.0f};

        public Group(String name, LinkedHashSet<Face> faces) {
            this.name = name != null ? name : DEFAULT_NAME;
            this.faces = faces == null ? new LinkedHashSet() : faces;
        }

        public LinkedHashSet<Face> applyTransform(Optional<TRSRTransformation> transform) {
            LinkedHashSet<Face> faceSet = new LinkedHashSet<Face>();
            for (Face f : this.faces) {
                faceSet.add(f.bake((TRSRTransformation)transform.or((Object)TRSRTransformation.identity())));
            }
            return faceSet;
        }

        public String getName() {
            return this.name;
        }

        public LinkedHashSet<Face> getFaces() {
            return this.faces;
        }

        public void setFaces(LinkedHashSet<Face> faces) {
            this.faces = faces;
        }

        public void addFace(Face face) {
            this.faces.add(face);
        }

        public void addFaces(List<Face> faces) {
            this.faces.addAll(faces);
        }
    }

    public static class TextureCoordinate {
        public float u;
        public float v;
        public float w;

        public TextureCoordinate() {
            this(0.0f, 0.0f, 1.0f);
        }

        public TextureCoordinate(float[] data) {
            this(data[0], data[1], data[2]);
        }

        public TextureCoordinate(Vector3f data) {
            this(data.x, data.y, data.z);
        }

        public TextureCoordinate(float u, float v, float w) {
            this.u = u;
            this.v = v;
            this.w = w;
        }

        public Vector3f getData() {
            return new Vector3f(this.u, this.v, this.w);
        }

        public static TextureCoordinate[] getDefaultUVs() {
            TextureCoordinate[] texCoords = new TextureCoordinate[]{new TextureCoordinate(0.0f, 0.0f, 1.0f), new TextureCoordinate(1.0f, 0.0f, 1.0f), new TextureCoordinate(1.0f, 1.0f, 1.0f), new TextureCoordinate(0.0f, 1.0f, 1.0f)};
            return texCoords;
        }
    }

    public static class Normal {
        public float x;
        public float y;
        public float z;

        public Normal() {
            this(0.0f, 0.0f, 0.0f);
        }

        public Normal(float[] data) {
            this(data[0], data[1], data[2]);
        }

        public Normal(Vector3f vector3f) {
            this(vector3f.x, vector3f.y, vector3f.z);
        }

        public Normal(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3f getData() {
            return new Vector3f(this.x, this.y, this.z);
        }
    }

    public static class Vertex {
        private Vector4f position;
        private Normal normal;
        private TextureCoordinate texCoord;
        private Material material = new Material();

        public Vertex(Vector4f position, Material material) {
            this.position = position;
            this.material = material;
        }

        public void setPos(Vector4f position) {
            this.position = position;
        }

        public Vector4f getPos() {
            return this.position;
        }

        public Vector3f getPos3() {
            return new Vector3f(this.position.x, this.position.y, this.position.z);
        }

        public boolean hasNormal() {
            return this.normal != null;
        }

        public void setNormal(Normal normal) {
            this.normal = normal;
        }

        public Normal getNormal() {
            return this.normal;
        }

        public boolean hasTextureCoordinate() {
            return this.texCoord != null;
        }

        public void setTextureCoordinate(TextureCoordinate texCoord) {
            this.texCoord = texCoord;
        }

        public TextureCoordinate getTextureCoordinate() {
            return this.texCoord;
        }

        public void setMaterial(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("v:%n", new Object[0]));
            builder.append(String.format("    position: %s %s %s%n", Float.valueOf(this.position.x), Float.valueOf(this.position.y), Float.valueOf(this.position.z)));
            builder.append(String.format("    material: %s %s %s %s %s%n", this.material.getName(), Float.valueOf(this.material.getColor().x), Float.valueOf(this.material.getColor().y), Float.valueOf(this.material.getColor().z), Float.valueOf(this.material.getColor().w)));
            return builder.toString();
        }
    }

    public static class Face {
        private Vertex[] verts = new Vertex[4];
        private String materialName = "OBJModel.Default.Texture.Name";
        private boolean isTri = false;

        public Face(Vertex[] verts) {
            this(verts, "OBJModel.Default.Texture.Name");
        }

        public Face(Vertex[] verts, String materialName) {
            this.verts = verts != null && verts.length > 2 ? verts : null;
            this.setMaterialName(materialName);
            this.checkData();
        }

        private void checkData() {
            if (this.verts != null && this.verts.length == 3) {
                this.isTri = true;
                this.verts = new Vertex[]{this.verts[0], this.verts[1], this.verts[2], this.verts[2]};
            }
        }

        public void setMaterialName(String materialName) {
            this.materialName = materialName != null && !materialName.isEmpty() ? materialName : this.materialName;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public boolean isTriangles() {
            return this.isTri;
        }

        public boolean setVertices(Vertex[] verts) {
            if (verts == null) {
                return false;
            }
            this.verts = verts;
            this.checkData();
            return true;
        }

        public Vertex[] getVertices() {
            return this.verts;
        }

        public Face bake(TRSRTransformation transform) {
            Matrix4f m2 = transform.getMatrix();
            Matrix3f mn = null;
            Vertex[] vertices = new Vertex[this.verts.length];
            for (int i = 0; i < this.verts.length; ++i) {
                Vertex v = this.verts[i];
                Vector4f pos = new Vector4f(v.getPos());
                Vector4f newPos = new Vector4f();
                pos.w = 1.0f;
                m2.transform((Tuple4f)pos, (Tuple4f)newPos);
                vertices[i] = new Vertex(newPos, v.getMaterial());
                if (v.hasNormal()) {
                    if (mn == null) {
                        mn = new Matrix3f();
                        m2.getRotationScale(mn);
                        mn.invert();
                        mn.transpose();
                    }
                    Vector3f normal = new Vector3f(v.getNormal().getData());
                    Vector3f newNormal = new Vector3f();
                    mn.transform((Tuple3f)normal, (Tuple3f)newNormal);
                    newNormal.normalize();
                    vertices[i].setNormal(new Normal(newNormal));
                }
                if (v.hasTextureCoordinate()) {
                    vertices[i].setTextureCoordinate(v.getTextureCoordinate());
                    continue;
                }
                v.setTextureCoordinate(TextureCoordinate.getDefaultUVs()[i]);
            }
            return new Face(vertices, this.materialName);
        }

        public Normal getNormal() {
            Vector3f a2 = this.verts[2].getPos3();
            a2.sub((Tuple3f)this.verts[0].getPos3());
            Vector3f b2 = this.verts[3].getPos3();
            b2.sub((Tuple3f)this.verts[1].getPos3());
            a2.cross(a2, b2);
            a2.normalize();
            return new Normal(a2);
        }
    }

    public static class Texture {
        public static Texture WHITE = new Texture("builtin/white", new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        private String path;
        private Vector2f position;
        private Vector2f scale;
        private float rotation;

        public Texture(String path) {
            this(path, new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 1.0f), 0.0f);
        }

        public Texture(String path, Vector2f position, Vector2f scale, float rotation) {
            this.path = path;
            this.position = position;
            this.scale = scale;
            this.rotation = rotation;
        }

        public jy getTextureLocation() {
            jy loc = new jy(this.path);
            return loc;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPosition(Vector2f position) {
            this.position = position;
        }

        public Vector2f getPosition() {
            return this.position;
        }

        public void setScale(Vector2f scale) {
            this.scale = scale;
        }

        public Vector2f getScale() {
            return this.scale;
        }

        public void setRotation(float rotation) {
            this.rotation = rotation;
        }

        public float getRotation() {
            return this.rotation;
        }
    }

    public static class Material {
        public static final String WHITE_NAME = "OBJModel.White.Texture.Name";
        public static final String DEFAULT_NAME = "OBJModel.Default.Texture.Name";
        private Vector4f color;
        private Texture texture = Texture.WHITE;
        private String name = "OBJModel.Default.Texture.Name";

        public Material() {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
        }

        public Material(Vector4f color) {
            this(color, Texture.WHITE, WHITE_NAME);
        }

        public Material(Texture texture) {
            this(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), texture, DEFAULT_NAME);
        }

        public Material(Vector4f color, Texture texture, String name) {
            this.color = color;
            this.texture = texture;
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public void setName(String name) {
            this.name = name != null ? name : DEFAULT_NAME;
        }

        public String getName() {
            return this.name;
        }

        public void setColor(Vector4f color) {
            this.color = color;
        }

        public Vector4f getColor() {
            return this.color;
        }

        public void setTexture(Texture texture) {
            this.texture = texture;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public boolean isWhite() {
            return this.texture.equals(Texture.WHITE);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("%nMaterial:%n", new Object[0]));
            builder.append(String.format("    Name: %s%n", this.name));
            builder.append(String.format("    Color: %s%n", this.color.toString()));
            builder.append(String.format("    Is White: %b%n", this.isWhite()));
            return builder.toString();
        }
    }

    public static class MaterialLibrary {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private Set<String> unknownMaterialCommands = new HashSet<String>();
        private Map<String, Material> materials = new HashMap<String, Material>();
        private Map<String, Group> groups = new HashMap<String, Group>();
        private InputStreamReader mtlStream;
        private BufferedReader mtlReader;

        public MaterialLibrary() {
            this.groups.put("OBJModel.Default.Element.Name", new Group("OBJModel.Default.Element.Name", null));
            Material def = new Material();
            def.setName("OBJModel.Default.Texture.Name");
            this.materials.put("OBJModel.Default.Texture.Name", def);
        }

        public MaterialLibrary makeLibWithReplacements(ImmutableMap<String, String> replacements) {
            HashMap<String, Material> mats = new HashMap<String, Material>();
            for (Map.Entry<String, Material> e : this.materials.entrySet()) {
                Material replacementMaterial;
                Texture replacementTexture;
                Texture currentTexture;
                String keyTex;
                String keyMat = e.getKey();
                if (!keyMat.startsWith("#")) {
                    keyMat = "#" + keyMat;
                }
                if ((keyTex = e.getValue().getTexture().getPath()).endsWith(".png")) {
                    keyTex = keyTex.substring(0, keyTex.length() - ".png".length());
                }
                if (!keyTex.startsWith("#")) {
                    keyTex = "#" + keyTex;
                }
                if (replacements.containsKey((Object)keyMat)) {
                    currentTexture = e.getValue().texture;
                    replacementTexture = new Texture((String)replacements.get((Object)keyMat), currentTexture.position, currentTexture.scale, currentTexture.rotation);
                    replacementMaterial = new Material(e.getValue().color, replacementTexture, e.getValue().name);
                    mats.put(e.getKey(), replacementMaterial);
                    continue;
                }
                if (replacements.containsKey((Object)keyTex)) {
                    currentTexture = e.getValue().texture;
                    replacementTexture = new Texture((String)replacements.get((Object)keyTex), currentTexture.position, currentTexture.scale, currentTexture.rotation);
                    replacementMaterial = new Material(e.getValue().color, replacementTexture, e.getValue().name);
                    mats.put(e.getKey(), replacementMaterial);
                    continue;
                }
                mats.put(e.getKey(), e.getValue());
            }
            MaterialLibrary ret = new MaterialLibrary();
            ret.unknownMaterialCommands = this.unknownMaterialCommands;
            ret.materials = mats;
            ret.groups = this.groups;
            ret.mtlStream = this.mtlStream;
            ret.mtlReader = this.mtlReader;
            return ret;
        }

        public Map<String, Group> getGroups() {
            return this.groups;
        }

        public List<Group> getGroupsContainingFace(Face f) {
            ArrayList groupList = Lists.newArrayList();
            for (Group g2 : this.groups.values()) {
                if (!g2.faces.contains(f)) continue;
                groupList.add(g2);
            }
            return groupList;
        }

        public void changeMaterialColor(String name, int color) {
            Vector4f colorVec = new Vector4f();
            colorVec.w = (color >> 24 & 0xFF) / 255;
            colorVec.x = (color >> 16 & 0xFF) / 255;
            colorVec.y = (color >> 8 & 0xFF) / 255;
            colorVec.z = (color & 0xFF) / 255;
            this.materials.get(name).setColor(colorVec);
        }

        public Material getMaterial(String name) {
            return this.materials.get(name);
        }

        public ImmutableList<String> getMaterialNames() {
            return ImmutableList.copyOf(this.materials.keySet());
        }

        public void parseMaterials(bni manager, String path, jy from) throws IOException {
            this.materials.clear();
            boolean hasSetTexture = false;
            boolean hasSetColor = false;
            String domain = from.b();
            if (!path.contains("/")) {
                path = from.a().substring(0, from.a().lastIndexOf("/") + 1) + path;
            }
            this.mtlStream = new InputStreamReader(manager.a(new jy(domain, path)).b(), Charsets.UTF_8);
            this.mtlReader = new BufferedReader(this.mtlStream);
            String currentLine = "";
            Material material = new Material();
            material.setName("OBJModel.White.Texture.Name");
            material.setTexture(Texture.WHITE);
            this.materials.put("OBJModel.White.Texture.Name", material);
            this.materials.put("OBJModel.Default.Texture.Name", new Material(Texture.WHITE));
            while ((currentLine = this.mtlReader.readLine()) != null) {
                currentLine.trim();
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = WHITE_SPACE.split(currentLine, 2);
                String key = fields[0];
                String data = fields[1];
                if (key.equalsIgnoreCase("newmtl")) {
                    hasSetColor = false;
                    hasSetTexture = false;
                    material = new Material();
                    material.setName(data);
                    this.materials.put(data, material);
                    continue;
                }
                if (key.equalsIgnoreCase("Ka") || key.equalsIgnoreCase("Kd") || key.equalsIgnoreCase("Ks")) {
                    if (key.equalsIgnoreCase("Kd") || !hasSetColor) {
                        String[] rgbStrings = WHITE_SPACE.split(data, 3);
                        Vector4f color = new Vector4f(Float.parseFloat(rgbStrings[0]), Float.parseFloat(rgbStrings[1]), Float.parseFloat(rgbStrings[2]), 1.0f);
                        hasSetColor = true;
                        material.setColor(color);
                        continue;
                    }
                    FMLLog.info("OBJModel: A color has already been defined for material '%s' in '%s'. The color defined by key '%s' will not be applied!", material.getName(), new jy(domain, path).toString(), key);
                    continue;
                }
                if (key.equalsIgnoreCase("map_Ka") || key.equalsIgnoreCase("map_Kd") || key.equalsIgnoreCase("map_Ks")) {
                    if (key.equalsIgnoreCase("map_Kd") || !hasSetTexture) {
                        if (data.contains(" ")) {
                            String[] mapStrings = WHITE_SPACE.split(data);
                            String texturePath = mapStrings[mapStrings.length - 1];
                            Texture texture = new Texture(texturePath);
                            hasSetTexture = true;
                            material.setTexture(texture);
                            continue;
                        }
                        Texture texture = new Texture(data);
                        hasSetTexture = true;
                        material.setTexture(texture);
                        continue;
                    }
                    FMLLog.info("OBJModel: A texture has already been defined for material '%s' in '%s'. The texture defined by key '%s' will not be applied!", material.getName(), new jy(domain, path).toString(), key);
                    continue;
                }
                if (key.equalsIgnoreCase("d") || key.equalsIgnoreCase("Tr")) {
                    String[] splitData = WHITE_SPACE.split(data);
                    float alpha = Float.parseFloat(splitData[splitData.length - 1]);
                    material.getColor().setW(alpha);
                    continue;
                }
                if (this.unknownMaterialCommands.contains(key)) continue;
                this.unknownMaterialCommands.add(key);
                FMLLog.info("OBJLoader.MaterialLibrary: key '%s' (model: '%s') is not currently supported, skipping", key, new jy(domain, path));
            }
        }
    }

    public static class Parser {
        private static final Pattern WHITE_SPACE = Pattern.compile("\\s+");
        private static Set<String> unknownObjectCommands = new HashSet<String>();
        public MaterialLibrary materialLibrary = new MaterialLibrary();
        private bni manager;
        private InputStreamReader objStream;
        private BufferedReader objReader;
        private jy objFrom;
        private List<String> groupList = Lists.newArrayList();
        private List<Vertex> vertices = Lists.newArrayList();
        private List<Normal> normals = Lists.newArrayList();
        private List<TextureCoordinate> texCoords = Lists.newArrayList();

        public Parser(bnh from, bni manager) throws IOException {
            this.manager = manager;
            this.objFrom = from.a();
            this.objStream = new InputStreamReader(from.b(), Charsets.UTF_8);
            this.objReader = new BufferedReader(this.objStream);
        }

        public List<String> getElements() {
            return this.groupList;
        }

        public OBJModel parse() throws IOException {
            String currentLine = "";
            Material material = new Material();
            material.setName("OBJModel.Default.Texture.Name");
            int usemtlCounter = 0;
            while ((currentLine = this.objReader.readLine()) != null) {
                float[] floatSplitData;
                currentLine.trim();
                if (currentLine.isEmpty() || currentLine.startsWith("#")) continue;
                String[] fields = WHITE_SPACE.split(currentLine, 2);
                String key = fields[0];
                String data = fields[1];
                String[] splitData = WHITE_SPACE.split(data);
                if (key.equalsIgnoreCase("mtllib")) {
                    this.materialLibrary.parseMaterials(this.manager, data, this.objFrom);
                    continue;
                }
                if (key.equalsIgnoreCase("usemtl")) {
                    material = (Material)this.materialLibrary.materials.get(data);
                    ++usemtlCounter;
                    continue;
                }
                if (key.equalsIgnoreCase("v")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Vector4f pos = new Vector4f(floatSplitData[0], floatSplitData[1], floatSplitData[2], floatSplitData.length == 4 ? floatSplitData[3] : 1.0f);
                    Vertex vertex = new Vertex(pos, material);
                    this.vertices.add(vertex);
                    continue;
                }
                if (key.equalsIgnoreCase("vn")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    Normal normal = new Normal(floatSplitData);
                    this.normals.add(normal);
                    continue;
                }
                if (key.equalsIgnoreCase("vt")) {
                    floatSplitData = new float[splitData.length];
                    for (int i = 0; i < splitData.length; ++i) {
                        floatSplitData[i] = Float.parseFloat(splitData[i]);
                    }
                    TextureCoordinate texCoord = new TextureCoordinate(new Vector3f(floatSplitData[0], floatSplitData[1], floatSplitData.length == 3 ? floatSplitData[2] : 1.0f));
                    if (texCoord.u < 0.0f || texCoord.u > 1.0f || texCoord.v < 0.0f || texCoord.v > 1.0f) {
                        throw new UVsOutOfBoundsException(this.objFrom);
                    }
                    this.texCoords.add(texCoord);
                    continue;
                }
                if (key.equalsIgnoreCase("f")) {
                    String[][] splitSlash = new String[splitData.length][];
                    if (splitData.length > 4) {
                        FMLLog.warning("OBJModel.Parser: found a face ('f') with more than 4 vertices, only the first 4 of these vertices will be rendered!", new Object[0]);
                    }
                    int vert = 0;
                    int texCoord = 0;
                    int norm = 0;
                    ArrayList v = Lists.newArrayListWithCapacity((int)splitData.length);
                    for (int i = 0; i < splitData.length; ++i) {
                        Vertex newV;
                        if (splitData[i].contains("//")) {
                            splitSlash[i] = splitData[i].split("//");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            norm = Integer.parseInt(splitSlash[i][1]);
                            norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                            newV.setNormal(this.normals.get(norm));
                            v.add(newV);
                            continue;
                        }
                        if (splitData[i].contains("/")) {
                            splitSlash[i] = splitData[i].split("/");
                            vert = Integer.parseInt(splitSlash[i][0]);
                            vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                            texCoord = Integer.parseInt(splitSlash[i][1]);
                            int n = texCoord = texCoord < 0 ? this.texCoords.size() - 1 : texCoord - 1;
                            if (splitSlash[i].length > 2) {
                                norm = Integer.parseInt(splitSlash[i][2]);
                                norm = norm < 0 ? this.normals.size() - 1 : norm - 1;
                            }
                            newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                            newV.setTextureCoordinate(this.texCoords.get(texCoord));
                            newV.setNormal(splitSlash[i].length > 2 ? this.normals.get(norm) : null);
                            v.add(newV);
                            continue;
                        }
                        splitSlash[i] = splitData[i].split("");
                        vert = Integer.parseInt(splitSlash[i][0]);
                        vert = vert < 0 ? this.vertices.size() - 1 : vert - 1;
                        newV = new Vertex(new Vector4f(this.vertices.get(vert).getPos()), this.vertices.get(vert).getMaterial());
                        v.add(newV);
                    }
                    Vertex[] va = new Vertex[v.size()];
                    v.toArray(va);
                    Face face = new Face(va, material.name);
                    if (usemtlCounter < this.vertices.size()) {
                        for (Vertex ver : face.getVertices()) {
                            ver.setMaterial(material);
                        }
                    }
                    if (this.groupList.isEmpty()) {
                        if (this.materialLibrary.getGroups().containsKey("OBJModel.Default.Element.Name")) {
                            this.materialLibrary.getGroups().get("OBJModel.Default.Element.Name").addFace(face);
                            continue;
                        }
                        Group def = new Group("OBJModel.Default.Element.Name", null);
                        def.addFace(face);
                        this.materialLibrary.getGroups().put("OBJModel.Default.Element.Name", def);
                        continue;
                    }
                    for (String s : this.groupList) {
                        if (this.materialLibrary.getGroups().containsKey(s)) {
                            this.materialLibrary.getGroups().get(s).addFace(face);
                            continue;
                        }
                        Group e = new Group(s, null);
                        e.addFace(face);
                        this.materialLibrary.getGroups().put(s, e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("g") || key.equalsIgnoreCase("o")) {
                    this.groupList.clear();
                    if (key.equalsIgnoreCase("g")) {
                        String[] splitSpace;
                        for (String s : splitSpace = data.split(" ")) {
                            this.groupList.add(s);
                        }
                        continue;
                    }
                    this.groupList.add(data);
                    continue;
                }
                if (unknownObjectCommands.contains(key)) continue;
                unknownObjectCommands.add(key);
                FMLLog.info("OBJLoader.Parser: command '%s' (model: '%s') is not currently supported, skipping", key, this.objFrom);
            }
            OBJModel model = new OBJModel(this.materialLibrary, this.objFrom);
            return model;
        }
    }

    static class CustomData {
        public boolean ambientOcclusion = true;
        public boolean gui3d = true;
        public boolean flipV = false;

        public CustomData(CustomData parent, ImmutableMap<String, String> customData) {
            this.ambientOcclusion = parent.ambientOcclusion;
            this.gui3d = parent.gui3d;
            this.flipV = parent.flipV;
            this.process(customData);
        }

        public CustomData() {
        }

        public void process(ImmutableMap<String, String> customData) {
            for (Map.Entry e : customData.entrySet()) {
                if (((String)e.getKey()).equals("ambient")) {
                    this.ambientOcclusion = Boolean.valueOf((String)e.getValue());
                    continue;
                }
                if (((String)e.getKey()).equals("gui3d")) {
                    this.gui3d = Boolean.valueOf((String)e.getValue());
                    continue;
                }
                if (!((String)e.getKey()).equals("flip-v")) continue;
                this.flipV = Boolean.valueOf((String)e.getValue());
            }
        }
    }
}

