/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;

public class StartupQuery {
    private static volatile StartupQuery pending;
    private static volatile boolean aborted;
    private String text;
    private AtomicBoolean result;
    private CountDownLatch signal = new CountDownLatch(1);
    private volatile boolean synchronous;

    public static boolean confirm(String text) {
        StartupQuery query = new StartupQuery(text, new AtomicBoolean());
        query.execute();
        return query.getResult();
    }

    public static void notify(String text) {
        StartupQuery query = new StartupQuery(text, null);
        query.execute();
    }

    public static void abort() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            server.w();
        }
        aborted = true;
        throw new AbortedException();
    }

    public static void reset() {
        pending = null;
        aborted = false;
    }

    public static boolean check() {
        if (pending != null) {
            try {
                FMLCommonHandler.instance().queryUser(pending);
            }
            catch (InterruptedException e2) {
                FMLLog.warning("query interrupted", new Object[0]);
                StartupQuery.abort();
            }
            pending = null;
        }
        return !aborted;
    }

    private StartupQuery(String text, AtomicBoolean result) {
        this.text = text;
        this.result = result;
    }

    public Boolean getResult() {
        return this.result == null ? null : Boolean.valueOf(this.result.get());
    }

    public void setResult(boolean result) {
        this.result.set(result);
    }

    public String getText() {
        return this.text;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void finish() {
        this.signal.countDown();
    }

    private void execute() {
        String prop = System.getProperty("fml.queryResult");
        if (this.result != null && prop != null) {
            FMLLog.info("Using fml.queryResult %s to answer the following query:\n%s", prop, this.text);
            if (prop.equalsIgnoreCase("confirm")) {
                this.setResult(true);
                return;
            }
            if (prop.equalsIgnoreCase("cancel")) {
                this.setResult(false);
                return;
            }
            FMLLog.warning("Invalid value for fml.queryResult: %s, expected confirm or cancel", prop);
        }
        this.synchronous = false;
        pending = this;
        if (FMLCommonHandler.instance().getSide().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.synchronous = true;
            StartupQuery.check();
        }
        try {
            this.signal.await();
            StartupQuery.reset();
        }
        catch (InterruptedException e2) {
            FMLLog.warning("query interrupted", new Object[0]);
            StartupQuery.abort();
        }
    }

    static {
        aborted = false;
    }

    public static class AbortedException
    extends RuntimeException {
        private static final long serialVersionUID = -5933665223696833921L;

        private AbortedException() {
        }
    }
}

