/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import net.minecraftforge.items.IItemHandler;

public class VanillaDoubleChestItemHandler
extends WeakReference<aky>
implements IItemHandler {
    public static final VanillaDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new VanillaDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final aky mainChest;
    private final int hashCode;

    public VanillaDoubleChestItemHandler(aky mainChest, aky other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    public static VanillaDoubleChestItemHandler get(aky chest) {
        adm world = chest.z();
        cj pos = chest.v();
        if (world == null || pos == null || !world.e(pos)) {
            return null;
        }
        afh blockType = chest.w();
        cq[] horizontals = cq.o;
        for (int i2 = horizontals.length - 1; i2 >= 0; --i2) {
            akw otherTE;
            cq enumfacing = horizontals[i2];
            cj blockpos = pos.a(enumfacing);
            afh block = world.p(blockpos).c();
            if (block != blockType || !((otherTE = world.s(blockpos)) instanceof aky)) continue;
            aky otherChest = (aky)otherTE;
            return new VanillaDoubleChestItemHandler(chest, otherChest, enumfacing != cq.e && enumfacing != cq.c);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public aky getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    private aky getOtherChest() {
        aky tileEntityChest = (aky)this.get();
        return tileEntityChest != null && !tileEntityChest.x() ? tileEntityChest : null;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public zx getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aky chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.a(targetSlot) : null;
    }

    @Override
    public zx insertItem(int slot, zx stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aky chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate) : stack;
    }

    @Override
    public zx extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        aky chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaDoubleChestItemHandler that = (VanillaDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        aky otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)this.mainChest, (Object)that.mainChest) && Objects.equal((Object)otherChest, (Object)that.getOtherChest());
        }
        return Objects.equal((Object)this.mainChest, (Object)that.getOtherChest()) && Objects.equal((Object)otherChest, (Object)that.mainChest);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        aky tileEntityChest = (aky)this.get();
        return tileEntityChest == null || tileEntityChest.x();
    }
}

