/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.TRSRTransformation;

public interface IPerspectiveState
extends IModelState {
    public IModelState forPerspective(cmz var1);

    public static class Impl
    implements IPerspectiveState {
        private final IModelState parent;
        private final ImmutableMap<cmz, IModelState> states;

        public Impl(IModelState parent, ImmutableMap<cmz, IModelState> states) {
            this.parent = parent;
            this.states = states;
        }

        public Impl(IModelState parent, cmx transforms) {
            this(parent, Impl.getMap(transforms));
        }

        private static ImmutableMap<cmz, IModelState> getMap(cmx transforms) {
            HashMap map = Maps.newHashMap();
            map.put(cmz.a, TRSRTransformation.identity());
            map.put(cmz.b, transforms.b);
            map.put(cmz.c, transforms.c);
            map.put(cmz.e, transforms.e);
            map.put(cmz.d, transforms.d);
            return Maps.immutableEnumMap((Map)map);
        }

        @Override
        public TRSRTransformation apply(IModelPart part) {
            return this.parent.apply(part);
        }

        @Override
        public IModelState forPerspective(cmz type) {
            IModelState state = (IModelState)this.states.get((Object)type);
            if (state == null) {
                state = TRSRTransformation.identity();
            }
            return state;
        }

        public String toString() {
            return Objects.toStringHelper(this.getClass()).add("parent", (Object)this.parent).add("states", this.states).toString();
        }
    }
}

