/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;

public class ModelFluid
implements IModelCustomData {
    public static final ModelFluid waterModel = new ModelFluid(FluidRegistry.WATER);
    public static final ModelFluid lavaModel = new ModelFluid(FluidRegistry.LAVA);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<oa> getDependencies() {
        return Collections.emptySet();
    }

    @Override
    public Collection<oa> getTextures() {
        return ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
        return new BakedFluid(state.apply(this), format, this.fluid.getColor(), (cue)bakedTextureGetter.apply((Object)this.fluid.getStill()), (cue)bakedTextureGetter.apply((Object)this.fluid.getFlowing()), this.fluid.isGaseous());
    }

    @Override
    public IModelState getDefaultState() {
        return cxf.a;
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e = new JsonParser().parse(fluidStr);
        String fluid = e.getAsString();
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.severe("fluid '%s' not found", fluid);
            return waterModel;
        }
        return new ModelFluid(FluidRegistry.getFluid(fluid));
    }

    public static class BakedFluid
    implements IFlexibleBakedModel,
    ISmartBlockModel {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        private final TRSRTransformation transformation;
        private final cus format;
        private final int color;
        private final cue still;
        private final cue flowing;
        private final boolean gas;
        private final Optional<IExtendedBlockState> state;
        private final EnumMap<ej, List<clt>> faceQuads;

        public BakedFluid(TRSRTransformation transformation, cus format, int color, cue still, cue flowing, boolean gas) {
            this(transformation, format, color, still, flowing, gas, (Optional<IExtendedBlockState>)Optional.absent());
        }

        public BakedFluid(TRSRTransformation transformation, cus format, int color, cue still, cue flowing, boolean gas, Optional<IExtendedBlockState> stateOption) {
            this.transformation = transformation;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.gas = gas;
            this.state = stateOption;
            this.faceQuads = Maps.newEnumMap(ej.class);
            for (ej side : ej.values()) {
                this.faceQuads.put(side, (List<clt>)ImmutableList.of());
            }
            if (this.state.isPresent()) {
                int i;
                IExtendedBlockState state = (IExtendedBlockState)this.state.get();
                float[] y = new float[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    y[i2] = gas ? 1.0f - state.getValue(BlockFluidBase.LEVEL_CORNERS[i2]).floatValue() : state.getValue(BlockFluidBase.LEVEL_CORNERS[i2]).floatValue();
                }
                float flow = state.getValue(BlockFluidBase.FLOW_DIRECTION).floatValue();
                cue topSprite = flowing;
                float scale = 4.0f;
                if (flow < -999.0f) {
                    flow = 0.0f;
                    scale = 8.0f;
                    topSprite = still;
                }
                float c = uv.b((float)flow) * scale;
                float s = uv.a((float)flow) * scale;
                ej side = gas ? ej.a : ej.b;
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setQuadColored();
                for (i = gas ? 3 : 0; i != (gas ? -1 : 4); i += gas ? -1 : 1) {
                    this.putVertex(builder, side, x[i], y[i], z[i], topSprite.a((double)(8.0f + c * (float)(x[i] * 2 - 1) + s * (float)(z[i] * 2 - 1))), topSprite.b((double)(8.0f + c * (float)(x[(i + 1) % 4] * 2 - 1) + s * (float)(z[(i + 1) % 4] * 2 - 1))));
                }
                this.faceQuads.put(side, (List<clt>)ImmutableList.of((Object)((Object)builder.build())));
                side = side.d();
                builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(side);
                builder.setQuadColored();
                for (i = gas ? 3 : 0; i != (gas ? -1 : 4); i += gas ? -1 : 1) {
                    this.putVertex(builder, side, z[i], gas ? 1.0f : 0.0f, x[i], still.a((double)(z[i] * 16)), still.b((double)(x[i] * 16)));
                }
                this.faceQuads.put(side, (List<clt>)ImmutableList.of((Object)((Object)builder.build())));
                for (i = 0; i < 4; ++i) {
                    side = ej.b((int)((5 - i) % 4));
                    clt[] q = new clt[2];
                    for (int k = 0; k < 2; ++k) {
                        builder = new UnpackedBakedQuad.Builder(format);
                        builder.setQuadOrientation(side);
                        builder.setQuadColored();
                        for (int j = 0; j < 4; ++j) {
                            int l = k * 3 + (1 - 2 * k) * j;
                            float yl = (float)z[l] * y[(i + x[l]) % 4];
                            if (gas && z[l] == 0) {
                                yl = 1.0f;
                            }
                            this.putVertex(builder, side, x[(i + x[l]) % 4], yl, z[(i + x[l]) % 4], flowing.a((double)(x[l] * 8)), flowing.b((double)((gas ? yl : 1.0f - yl) * 8.0f)));
                        }
                        q[k] = builder.build();
                    }
                    this.faceQuads.put(side, (List<clt>)ImmutableList.of((Object)q[0], (Object)q[1]));
                }
            } else {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
                builder.setQuadOrientation(ej.b);
                builder.setQuadColored();
                for (int i = 0; i < 4; ++i) {
                    this.putVertex(builder, ej.b, z[i], x[i], 0.0f, still.a((double)(x[i] * 16)), still.b((double)(z[i] * 16)));
                }
                this.faceQuads.put(ej.d, (List<clt>)ImmutableList.of((Object)((Object)builder.build())));
            }
        }

        private void putVertex(UnpackedBakedQuad.Builder builder, ej side, float x2, float y, float z, float u, float v) {
            block6: for (int e = 0; e < this.format.h(); ++e) {
                switch (this.format.c(e).c()) {
                    case a: {
                        builder.put(e, x2 - (float)side.m().n() * 0.001f, y, z - (float)side.m().p() * 0.001f, 1.0f);
                        continue block6;
                    }
                    case c: {
                        float d = LightUtil.diffuseLight(side);
                        builder.put(e, d * (float)(this.color >> 16 & 0xFF) / 255.0f, d * (float)(this.color >> 8 & 0xFF) / 255.0f, d * (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e).e() == 0) {
                            builder.put(e, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    case b: {
                        builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public boolean d() {
            return false;
        }

        public cue e() {
            return this.still;
        }

        public cmx f() {
            return cmx.a;
        }

        @Override
        public List<clt> a(ej side) {
            return this.faceQuads.get(side);
        }

        @Override
        public List<clt> a() {
            return ImmutableList.of();
        }

        @Override
        public cus getFormat() {
            return this.format;
        }

        @Override
        public cxe handleBlockState(bec state) {
            return new BakedFluid(this.transformation, this.format, this.color, this.still, this.flowing, this.gas, (Optional<IExtendedBlockState>)Optional.of((Object)((IExtendedBlockState)state)));
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        instance;


        public void a(cvk resourceManager) {
        }

        @Override
        public boolean accepts(oa modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("fluid") || modelLocation.a().equals("models/block/fluid") || modelLocation.a().equals("models/item/fluid"));
        }

        @Override
        public IModel loadModel(oa modelLocation) {
            return waterModel;
        }
    }
}

