/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IPerspectiveState;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class B3DLoader
implements ICustomModelLoader {
    public static final B3DLoader instance = new B3DLoader();
    private cvk manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<oa, B3DModel> cache = new HashMap<oa, B3DModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    public void a(cvk manager) {
        this.manager = manager;
        this.cache.clear();
    }

    @Override
    public boolean accepts(oa modelLocation) {
        return this.enabledDomains.contains(modelLocation.b()) && modelLocation.a().endsWith(".b3d");
    }

    @Override
    public IModel loadModel(oa modelLocation) throws IOException {
        B3DModel model;
        oa file = new oa(modelLocation.b(), modelLocation.a());
        if (!this.cache.containsKey(file)) {
            try {
                cvj resource = null;
                try {
                    resource = this.manager.a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.a().startsWith("models/block/")) {
                        resource = this.manager.a(new oa(file.b(), "models/item/" + file.a().substring("models/block/".length())));
                    }
                    if (modelLocation.a().startsWith("models/item/")) {
                        resource = this.manager.a(new oa(file.b(), "models/block/" + file.a().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.b());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                this.cache.put(file, null);
                throw e;
            }
        }
        if ((model = this.cache.get(file)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        if (modelLocation instanceof B3DMeshLocation) {
            String mesh = ((B3DMeshLocation)modelLocation).getMesh();
            if (!model.getMeshes().containsKey((Object)mesh)) {
                FMLLog.severe("No mesh named %s in model %s, skipping", mesh, modelLocation);
                return ModelLoaderRegistry.getMissingModel();
            }
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)mesh), 1);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), 1);
    }

    private static class BakedWrapper
    implements IFlexibleBakedModel,
    ISmartBlockModel,
    ISmartItemModel,
    IPerspectiveAwareModel {
        private final B3DModel.Node<?> node;
        private final IModelState state;
        private final cus format;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, cue> textures;
        private final LoadingCache<Integer, BakedWrapper> cache;
        private ImmutableList<clt> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final IModelState state, final cus format, final ImmutableSet<String> meshes, final ImmutableMap<String, cue> textures) {
            this(node, state, format, meshes, textures, (LoadingCache<Integer, BakedWrapper>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, BakedWrapper>(){

                public BakedWrapper load(Integer frame) throws Exception {
                    IModelState parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new BakedWrapper(node, new B3DState(newAnimation, frame, frame, 0.0f, parent), format, (ImmutableSet<String>)meshes, (ImmutableMap<String, cue>)textures);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, IModelState state, cus format, ImmutableSet<String> meshes, ImmutableMap<String, cue> textures, LoadingCache<Integer, BakedWrapper> cache) {
            this.node = node;
            this.state = state;
            this.format = format;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        @Override
        public List<clt> a(ej side) {
            return Collections.emptyList();
        }

        @Override
        public List<clt> a() {
            if (this.quads == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (B3DModel.Node child : this.node.getNodes().values()) {
                    builder.addAll(new BakedWrapper(child, this.state, this.format, this.meshes, this.textures).a());
                }
                if (this.node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)this.node.getName())) {
                    B3DModel.Mesh mesh = (B3DModel.Mesh)this.node.getKind();
                    ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){

                        public Matrix4f apply(B3DModel.Node<?> node) {
                            return BakedWrapper.this.state.apply(PartWrapper.create(node)).getMatrix();
                        }
                    });
                    for (B3DModel.Face f : faces) {
                        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
                        quadBuilder.setQuadOrientation(ej.a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z));
                        quadBuilder.setQuadColored();
                        List<B3DModel.Texture> textures = null;
                        if (f.getBrush() != null) {
                            textures = f.getBrush().getTextures();
                        }
                        Object sprite = textures == null || textures.isEmpty() ? (cue)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.instance : (cue)this.textures.get((Object)textures.get(0).getPath()));
                        this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), (cue)sprite);
                        this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), (cue)sprite);
                        this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), (cue)sprite);
                        this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), (cue)sprite);
                        builder.add((Object)quadBuilder.build());
                    }
                }
                this.quads = builder.build();
            }
            return this.quads;
        }

        private final void putVertexData(UnpackedBakedQuad.Builder builder, B3DModel.Vertex v, Vector3f faceNormal, cue sprite) {
            block6: for (int e = 0; e < this.format.h(); ++e) {
                switch (this.format.c(e).c()) {
                    case a: {
                        builder.put(e, v.getPos().x, v.getPos().y, v.getPos().z, 1.0f);
                        continue block6;
                    }
                    case c: {
                        float d = LightUtil.diffuseLight(faceNormal.x, faceNormal.y, faceNormal.z);
                        if (v.getColor() != null) {
                            builder.put(e, d * v.getColor().x, d * v.getColor().y, d * v.getColor().z, v.getColor().w);
                            continue block6;
                        }
                        builder.put(e, d, d, d, 1.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e).e() < v.getTexCoords().length) {
                            builder.put(e, sprite.a((double)(v.getTexCoords()[0].x * 16.0f)), sprite.b((double)(v.getTexCoords()[0].y * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        builder.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case b: {
                        if (v.getNormal() != null) {
                            builder.put(e, v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f);
                            continue block6;
                        }
                        builder.put(e, faceNormal.x, faceNormal.y, faceNormal.z, 0.0f);
                        continue block6;
                    }
                    default: {
                        builder.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean b() {
            return true;
        }

        public boolean c() {
            return true;
        }

        public boolean d() {
            return false;
        }

        public cue e() {
            return (cue)this.textures.values().asList().get(0);
        }

        public cmx f() {
            return cmx.a;
        }

        @Override
        public BakedWrapper handleBlockState(bec state) {
            B3DState s;
            IExtendedBlockState exState;
            if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(B3DFrameProperty.instance) && (s = exState.getValue(B3DFrameProperty.instance)) != null) {
                IModelState parent = this.state;
                B3DModel.Animation newAnimation = s.getAnimation();
                if (parent instanceof B3DState) {
                    B3DState ps = (B3DState)parent;
                    parent = ps.getParent();
                }
                if (newAnimation == null) {
                    newAnimation = this.node.getAnimation();
                }
                if (s.getFrame() == s.getNextFrame()) {
                    return (BakedWrapper)this.cache.getUnchecked((Object)s.getFrame());
                }
                B3DState newState = new B3DState(newAnimation, s.getFrame(), s.getNextFrame(), s.getProgress(), parent);
                return new BakedWrapper(this.node, newState, this.format, this.meshes, this.textures);
            }
            return this;
        }

        @Override
        public cus getFormat() {
            return this.format;
        }

        @Override
        public BakedWrapper handleItemState(amj stack) {
            return this;
        }

        @Override
        public Pair<cxe, Matrix4f> handlePerspective(cmz cameraTransformType) {
            if (this.state instanceof IPerspectiveState) {
                return Pair.of((Object)this, (Object)TRSRTransformation.blockCornerToCenter(((IPerspectiveState)this.state).forPerspective(cameraTransformType).apply(PartWrapper.create(this.node))).getMatrix());
            }
            return Pair.of((Object)this, null);
        }
    }

    public static class ModelWrapper
    implements IRetexturableModel,
    IModelCustomData {
        private final oa modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, oa> textures;
        private final int defaultKey;

        public ModelWrapper(oa modelLocation, B3DModel model, ImmutableSet<String> meshes, int defaultKey) {
            this(modelLocation, model, meshes, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(oa modelLocation, B3DModel model, ImmutableSet<String> meshes, int defaultKey, ImmutableMap<String, oa> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.textures = textures;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, oa> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = ModelWrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)new oa(location));
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        @Override
        public Collection<oa> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Collection<oa> getTextures() {
            return Collections2.filter((Collection)this.textures.values(), (Predicate)new Predicate<oa>(){

                public boolean apply(oa loc) {
                    return !loc.a().startsWith("#");
                }
            });
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            cue missing = (cue)bakedTextureGetter.apply((Object)new oa("missingno"));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((oa)e.getValue()).a().startsWith("#")) {
                    FMLLog.severe("unresolved texture '%s' for b3d model '%s'", ((oa)e.getValue()).a(), this.modelLocation);
                    builder.put(e.getKey(), (Object)missing);
                    continue;
                }
                builder.put(e.getKey(), bakedTextureGetter.apply(e.getValue()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), state, format, this.meshes, (ImmutableMap<String, cue>)builder.build());
        }

        @Override
        public IModelState getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (textures.containsKey((Object)loc)) {
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = ModelWrapper.getLocation(path);
                    }
                    builder.put(e.getKey(), (Object)new oa(newLoc));
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.defaultKey, (ImmutableMap<String, oa>)builder.build());
        }

        @Override
        public IModel process(ImmutableMap<String, String> data) {
            if (data.containsKey((Object)"mesh")) {
                JsonElement e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        FMLLog.severe("unknown mesh definition '%s' in array for b3d model '%s'", s.toString(), this.modelLocation);
                        return this;
                    }
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)builder.build(), this.defaultKey, this.textures);
                }
                FMLLog.severe("unknown mesh definition '%s' for b3d model '%s'", e.toString(), this.modelLocation);
                return this;
            }
            if (data.containsKey((Object)"key")) {
                JsonElement e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    return new ModelWrapper(this.modelLocation, this.model, this.meshes, e.getAsNumber().intValue(), this.textures);
                }
                FMLLog.severe("unknown keyframe definition '%s' for b3d model '%s'", e.toString(), this.modelLocation);
                return this;
            }
            return this;
        }
    }

    @Deprecated
    public static class Wrapper
    extends PartWrapper<B3DModel.Mesh>
    implements IRetexturableModel,
    IModelCustomData {
        private final oa location;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, oa> textures;

        public Wrapper(oa location, List<B3DModel.Texture> textures, B3DModel.Node<B3DModel.Mesh> mesh) {
            this(location, (ImmutableSet<String>)ImmutableSet.of(), Wrapper.buildTextures(textures), mesh);
        }

        public Wrapper(oa location, ImmutableMap<String, oa> textures, B3DModel.Node<B3DModel.Mesh> mesh) {
            this(location, (ImmutableSet<String>)ImmutableSet.of(), textures, mesh);
        }

        public Wrapper(oa location, ImmutableSet<String> meshes, List<B3DModel.Texture> textures, B3DModel.Node<B3DModel.Mesh> mesh) {
            this(location, meshes, Wrapper.buildTextures(textures), mesh);
        }

        public Wrapper(oa location, ImmutableSet<String> meshes, ImmutableMap<String, oa> textures, B3DModel.Node<B3DModel.Mesh> mesh) {
            super(mesh);
            this.location = location;
            this.meshes = meshes;
            this.textures = textures;
        }

        private static ImmutableMap<String, oa> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                String location = Wrapper.getLocation(path);
                if (!location.startsWith("#")) {
                    location = "#" + location;
                }
                builder.put((Object)path, (Object)new oa(location));
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        @Override
        public Collection<oa> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public Collection<oa> getTextures() {
            return Collections2.filter((Collection)this.textures.values(), (Predicate)new Predicate<oa>(){

                public boolean apply(oa loc) {
                    return !loc.a().startsWith("#");
                }
            });
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, cus format, Function<oa, cue> bakedTextureGetter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            cue missing = (cue)bakedTextureGetter.apply((Object)new oa("missingno"));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((oa)e.getValue()).a().startsWith("#")) {
                    FMLLog.severe("unresolved texture '%s' for b3d model '%s'", ((oa)e.getValue()).a(), this.location);
                    builder.put(e.getKey(), (Object)missing);
                    continue;
                }
                builder.put(e.getKey(), bakedTextureGetter.apply(e.getValue()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.getNode(), state, format, this.meshes, (ImmutableMap<String, cue>)builder.build());
        }

        @Override
        public B3DState getDefaultState() {
            return new B3DState(this.getNode().getAnimation(), 1);
        }

        public oa getLocation() {
            return this.location;
        }

        public ImmutableMap<String, oa> getTextureMap() {
            return this.textures;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Wrapper other = (Wrapper)obj;
            return !(this.location == null ? other.location != null : !this.location.equals((Object)other.location));
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = Wrapper.getLocation(path);
                if (textures.containsKey((Object)loc)) {
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = Wrapper.getLocation(path);
                    }
                    builder.put(e.getKey(), (Object)new oa(newLoc));
                    continue;
                }
                builder.put(e);
            }
            return new Wrapper(this.location, (ImmutableMap<String, oa>)builder.build(), this.getNode());
        }

        @Override
        public IModel process(ImmutableMap<String, String> customData) {
            return this;
        }
    }

    public static class PartWrapper<K extends B3DModel.IKind<K>>
    implements IModelPart {
        private final B3DModel.Node<K> node;

        public static <K extends B3DModel.IKind<K>> PartWrapper<K> create(B3DModel.Node<K> node) {
            return new PartWrapper<K>(node);
        }

        public PartWrapper(B3DModel.Node<K> node) {
            this.node = node;
        }

        public B3DModel.Node<K> getNode() {
            return this.node;
        }
    }

    public static enum B3DFrameProperty implements IUnlistedProperty<B3DState>
    {
        instance;


        @Override
        public String getName() {
            return "B3DFrame";
        }

        @Override
        public boolean isValid(B3DState value) {
            return value instanceof B3DState;
        }

        @Override
        public Class<B3DState> getType() {
            return B3DState.class;
        }

        @Override
        public String valueToString(B3DState value) {
            return value.toString();
        }
    }

    public static class B3DState
    implements IModelState {
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        private final IModelState parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, TRSRTransformation>(){

            public TRSRTransformation load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(B3DModel.Animation animation, int frame, IModelState parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(B3DModel.Animation animation, int frame, int nextFrame, float progress, IModelState parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = uv.a((float)progress, (float)0.0f, (float)1.0f);
            this.parent = this.getParent(parent);
        }

        private IModelState getParent(IModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public TRSRTransformation apply(IModelPart part) {
            TRSRTransformation nodeTransform;
            if (!(part instanceof PartWrapper)) {
                throw new IllegalArgumentException("B3DState can only be applied to b3d models");
            }
            B3DModel.Node node = ((PartWrapper)part).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = nodeTransform.slerp(this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null) {
                return this.parent.apply(part).compose(nodeTransform);
            }
            return nodeTransform;
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node) {
            return (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)this.frame));
        }

        public TRSRTransformation getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static TRSRTransformation getNodeMatrix(B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            TRSRTransformation ret = TRSRTransformation.identity();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null && node.getAnimation() != animation) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    TRSRTransformation pm = (TRSRTransformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.compose(pm);
                    ret = ret.compose(new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.compose(new TRSRTransformation(key.getPos(), key.getRot(), key.getScale(), null));
                Matrix4f rm = new TRSRTransformation(node.getPos(), node.getRot(), node.getScale(), null).getMatrix();
                rm.invert();
                ret = ret.compose(new TRSRTransformation(rm));
                if (parent != null) {
                    rm = new TRSRTransformation(parent.getPos(), parent.getRot(), parent.getScale(), null).getMatrix();
                    rm.invert();
                    ret = ret.compose(new TRSRTransformation(rm));
                }
            }
            return ret;
        }
    }

    @Deprecated
    public static class B3DMeshLocation
    extends oa {
        public final String mesh;

        public B3DMeshLocation(String domain, String path, String mesh) {
            super(domain, path);
            this.mesh = mesh;
        }

        public String getMesh() {
            return this.mesh;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.mesh == null ? 0 : this.mesh.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            B3DMeshLocation other = (B3DMeshLocation)((Object)obj);
            return !(this.mesh == null ? other.mesh != null : !this.mesh.equals(other.mesh));
        }
    }
}

