/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Level;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>();
    private static List<List<amj>> idToStack = Lists.newArrayList();
    private static List<List<amj>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMap();
    public static final ImmutableList<amj> EMPTY_LIST = ImmutableList.of();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new amj(aty.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new amj(aty.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new amj(aty.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new amj((atr)aty.bM, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", aty.ad);
            OreDictionary.registerOre("stairWood", aty.bU);
            OreDictionary.registerOre("stairWood", aty.bV);
            OreDictionary.registerOre("stairWood", aty.bW);
            OreDictionary.registerOre("stairWood", aty.cC);
            OreDictionary.registerOre("stairWood", aty.cD);
            OreDictionary.registerOre("stickWood", amk.y);
            OreDictionary.registerOre("treeSapling", new amj(aty.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new amj((atr)aty.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new amj((atr)aty.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", aty.o);
            OreDictionary.registerOre("oreIron", aty.p);
            OreDictionary.registerOre("oreLapis", aty.x);
            OreDictionary.registerOre("oreDiamond", aty.ag);
            OreDictionary.registerOre("oreRedstone", aty.aC);
            OreDictionary.registerOre("oreEmerald", aty.bP);
            OreDictionary.registerOre("oreQuartz", aty.co);
            OreDictionary.registerOre("oreCoal", aty.q);
            OreDictionary.registerOre("blockGold", aty.R);
            OreDictionary.registerOre("blockIron", aty.S);
            OreDictionary.registerOre("blockLapis", aty.y);
            OreDictionary.registerOre("blockDiamond", aty.ah);
            OreDictionary.registerOre("blockRedstone", aty.cn);
            OreDictionary.registerOre("blockEmerald", aty.bT);
            OreDictionary.registerOre("blockQuartz", aty.cq);
            OreDictionary.registerOre("blockCoal", aty.cA);
            OreDictionary.registerOre("blockGlassColorless", aty.w);
            OreDictionary.registerOre("blockGlass", aty.w);
            OreDictionary.registerOre("blockGlass", new amj((atr)aty.cG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", aty.bj);
            OreDictionary.registerOre("paneGlass", aty.bj);
            OreDictionary.registerOre("paneGlass", new amj((atr)aty.cH, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("ingotIron", amk.j);
            OreDictionary.registerOre("ingotGold", amk.k);
            OreDictionary.registerOre("ingotBrick", amk.aH);
            OreDictionary.registerOre("ingotBrickNether", amk.cf);
            OreDictionary.registerOre("nuggetGold", amk.bx);
            OreDictionary.registerOre("gemDiamond", amk.i);
            OreDictionary.registerOre("gemEmerald", amk.bO);
            OreDictionary.registerOre("gemQuartz", amk.cg);
            OreDictionary.registerOre("dustRedstone", amk.aC);
            OreDictionary.registerOre("dustGlowstone", amk.aT);
            OreDictionary.registerOre("gemLapis", new amj(amk.aW, 1, 4));
            OreDictionary.registerOre("slimeball", amk.aM);
            OreDictionary.registerOre("glowstone", aty.aX);
            OreDictionary.registerOre("cropWheat", amk.O);
            OreDictionary.registerOre("cropPotato", amk.bS);
            OreDictionary.registerOre("cropCarrot", amk.bR);
            OreDictionary.registerOre("stone", aty.b);
            OreDictionary.registerOre("cobblestone", aty.e);
            OreDictionary.registerOre("sandstone", new amj(aty.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sand", new amj((atr)aty.m, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("dye", new amj(amk.aW, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("record", amk.cq);
            OreDictionary.registerOre("record", amk.cr);
            OreDictionary.registerOre("record", amk.cs);
            OreDictionary.registerOre("record", amk.ct);
            OreDictionary.registerOre("record", amk.cu);
            OreDictionary.registerOre("record", amk.cv);
            OreDictionary.registerOre("record", amk.cw);
            OreDictionary.registerOre("record", amk.cx);
            OreDictionary.registerOre("record", amk.cy);
            OreDictionary.registerOre("record", amk.cz);
            OreDictionary.registerOre("record", amk.cA);
            OreDictionary.registerOre("record", amk.cB);
            OreDictionary.registerOre("chest", (atr)aty.ae);
            OreDictionary.registerOre("chest", aty.bQ);
            OreDictionary.registerOre("chest", aty.cg);
            OreDictionary.registerOre("chestWood", (atr)aty.ae);
            OreDictionary.registerOre("chestEnder", aty.bQ);
            OreDictionary.registerOre("chestTrapped", aty.cg);
        }
        HashMap<amj, String> replacements = new HashMap<amj, String>();
        replacements.put(new amj(amk.y), "stickWood");
        replacements.put(new amj(aty.f), "plankWood");
        replacements.put(new amj(aty.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new amj((atr)aty.bM, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new amj(aty.b), "stone");
        replacements.put(new amj(aty.e), "cobblestone");
        replacements.put(new amj(aty.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new amj(amk.k), "ingotGold");
        replacements.put(new amj(amk.j), "ingotIron");
        replacements.put(new amj(amk.i), "gemDiamond");
        replacements.put(new amj(amk.bO), "gemEmerald");
        replacements.put(new amj(amk.aC), "dustRedstone");
        replacements.put(new amj(amk.aT), "dustGlowstone");
        replacements.put(new amj(aty.aX), "glowstone");
        replacements.put(new amj(amk.aM), "slimeball");
        replacements.put(new amj(aty.w), "blockGlassColorless");
        replacements.put(new amj((atr)aty.ae), "chestWood");
        replacements.put(new amj(aty.bQ), "chestEnder");
        replacements.put(new amj(aty.cg), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            amj dye = new amj(amk.aW, 1, i);
            amj block = new amj((atr)aty.cG, 1, 15 - i);
            amj pane = new amj((atr)aty.cH, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        amj[] replaceStacks = replacements.keySet().toArray(new amj[replacements.keySet().size()]);
        amj[] exclusions = new amj[]{new amj(aty.y), new amj(amk.bc), new amj(aty.bf), new amj((atr)aty.U, 1, Short.MAX_VALUE), new amj(aty.aw), new amj(aty.bZ), new amj(aty.aO), new amj(aty.bo), new amj(aty.ad), new amj(aty.aP), new amj(aty.bp), new amj(aty.bU), new amj(aty.aQ), new amj(aty.bq), new amj(aty.bV), new amj(aty.aR), new amj(aty.br), new amj(aty.bW), new amj(aty.aT), new amj(aty.bt), new amj(aty.cC), new amj(aty.aS), new amj(aty.bs), new amj(aty.cD), new amj((atr)aty.bM), new amj(aty.bj), null};
        List recipes = aop.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            amj output;
            aos recipe;
            if (obj instanceof aos) {
                recipe = (aos)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof aot) || (output = (recipe = (aot)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new amj[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((aoo)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((aot)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipies", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            ArrayList back = Lists.newArrayList();
            idToStack.add(back);
            idToStackUn.add(Collections.unmodifiableList(back));
        }
        return val;
    }

    public static String getOreName(int id2) {
        return id2 >= 0 && id2 < idToName.size() ? idToName.get(id2) : "Unknown";
    }

    public static int[] getOreIDs(amj stack) {
        if (stack == null || stack.b() == null) {
            throw new IllegalArgumentException("Stack can not be null!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        String registryName = stack.b().delegate.name();
        if (registryName == null) {
            FMLLog.log(Level.DEBUG, "Attempted to find the oreIDs for an unregistered object (%s). This won't work very well.", stack);
            return new int[0];
        }
        int id2 = GameData.getItemRegistry().getId(registryName);
        List<Integer> ids = stackToId.get(id2);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id2 | stack.h() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x2 = 0; x2 < tmp.length; ++x2) {
            ret[x2] = tmp[x2];
        }
        return ret;
    }

    public static List<amj> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static List<amj> getOres(int id2) {
        return idToStackUn.size() > id2 ? idToStackUn.get(id2) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, amj[] inputs, amj ... targets) {
        for (amj input : inputs) {
            for (amj target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsMatch(boolean strict, List<amj> inputs, amj ... targets) {
        for (amj input : inputs) {
            for (amj target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(amj target, amj input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.h() == Short.MAX_VALUE && !strict || target.h() == input.h());
    }

    public static void registerOre(String name, alq ore) {
        OreDictionary.registerOre(name, new amj(ore));
    }

    public static void registerOre(String name, atr ore) {
        OreDictionary.registerOre(name, new amj(ore));
    }

    public static void registerOre(String name, amj ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, amj ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore == null || ore.b() == null) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        String registryName = ore.b().delegate.name();
        if (registryName == null) {
            FMLLog.bigWarning("A broken ore dictionary registration with name %s has occurred. It adds an item (type: %s) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + Loader.instance().activeModContainer().getName() + " report it to them!", name, ore.b().getClass());
            hash = -1;
        } else {
            hash = GameData.getItemRegistry().getId(registryName);
        }
        if (ore.h() != Short.MAX_VALUE) {
            hash |= ore.h() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.k();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id2 = 0; id2 < idToStack.size(); ++id2) {
            List<amj> ores = idToStack.get(id2);
            if (ores == null) continue;
            for (amj ore : ores) {
                ArrayList ids;
                int hash;
                String name = ore.b().delegate.name();
                if (name == null) {
                    FMLLog.log(Level.DEBUG, "Defaulting unregistered ore dictionary entry for ore dictionary %s: type %s to -1", OreDictionary.getOreName(id2), ore.b().getClass());
                    hash = -1;
                } else {
                    hash = GameData.getItemRegistry().getId(name);
                }
                if (ore.h() != Short.MAX_VALUE) {
                    hash |= ore.h() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id2);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final amj Ore;

        public OreRegisterEvent(String name, amj ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

