/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelDynBucket
implements IModel,
IModelCustomData,
IRetexturableModel {
    public static final bxq LOCATION = new bxq(new kl("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynBucket();
    private final kl baseLocation;
    private final kl liquidLocation;
    private final kl coverLocation;
    private final Fluid fluid;
    private final boolean flipGas;

    public ModelDynBucket() {
        this(null, null, null, null, false);
    }

    public ModelDynBucket(kl baseLocation, kl liquidLocation, kl coverLocation, Fluid fluid, boolean flipGas) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
    }

    @Override
    public Collection<kl> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<kl> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        return builder.build();
    }

    @Override
    public bxl bake(IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
        ImmutableMap<bop.b, TRSRTransformation> transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity());
        bve fluidSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = (bve)bakedTextureGetter.apply((Object)this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            bxl model = new ItemLayerModel((ImmutableList<kl>)ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            bve liquid = (bve)bakedTextureGetter.apply((Object)this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, cs.c, this.fluid.getColor()));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, cs.d, this.fluid.getColor()));
        }
        if (this.coverLocation != null) {
            bve base = (bve)bakedTextureGetter.apply((Object)this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, base, cs.c, -1));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, base, cs.d, -1));
        }
        return new BakedDynBucket(this, (ImmutableList<boc>)builder.build(), fluidSprite, format, (ImmutableMap<bop.b, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap());
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip);
    }

    @Override
    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        kl base = this.baseLocation;
        kl liquid = this.liquidLocation;
        kl cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new kl((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new kl((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new kl((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas);
    }

    private static final class BakedDynBucket
    implements IPerspectiveAwareModel {
        private final ModelDynBucket parent;
        private final Map<String, bxl> cache;
        private final ImmutableMap<bop.b, TRSRTransformation> transforms;
        private final ImmutableList<boc> quads;
        private final bve particle;
        private final bvo format;

        public BakedDynBucket(ModelDynBucket parent, ImmutableList<boc> quads, bve particle, bvo format, ImmutableMap<bop.b, TRSRTransformation> transforms, Map<String, bxl> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public bon f() {
            return BakedDynBucketOverrideHandler.INSTANCE;
        }

        @Override
        public Pair<? extends bxl, Matrix4f> handlePerspective(bop.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((bxl)this, this.transforms, cameraTransformType);
        }

        public List<boc> a(ard state, cs side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public bve d() {
            return this.particle;
        }

        public bop e() {
            return bop.a;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends bon {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public bxl handleItemState(bxl originalModel, adq stack, aht world, sa entity) {
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem(stack);
            if (fluidStack == null && stack.b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.b()).getFluid(stack);
            }
            if (fluidStack == null) {
                return originalModel;
            }
            BakedDynBucket model = (BakedDynBucket)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name));
                Function<kl, bve> textureGetter = new Function<kl, bve>(){

                    public bve apply(kl location) {
                        return bcd.z().R().a(location.toString());
                    }
                };
                bxl bakedModel = parent.bake(new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format, textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (bxl)model.cache.get(name);
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(kl modelLocation) {
            return modelLocation.b().equals("forge") && modelLocation.a().contains("forgebucket");
        }

        @Override
        public IModel loadModel(kl modelLocation) {
            return MODEL;
        }

        public void a(bwd resourceManager) {
        }
    }
}

