/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IModelUVLock;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.IAnimatedModel;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public final class ModelLoader
extends bxo {
    private final Map<bxq, IModel> stateModels = Maps.newHashMap();
    private final Set<bxq> missingVariants = Sets.newHashSet();
    private final Map<kl, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private final int verboseMissingInfoCount = Integer.parseInt(System.getProperty("forge.verboseMissingModelLoggingCount", "5"));
    private static final Map<RegistryDelegate<ajt>, bpf> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<ado>, bnj> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<ado>, Integer>, bxq> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(bwd manager, bvd map, bny shapes) {
        super(manager, map, shapes);
        VanillaLoader.INSTANCE.setLoader(this);
        VariantLoader.INSTANCE.setLoader(this);
        ModelLoaderRegistry.clearModelCache(manager);
    }

    public dd<bxq, bxl> a() {
        this.isLoading = true;
        this.b();
        this.c();
        this.missingModel = ModelLoaderRegistry.getMissingModel();
        this.stateModels.put(a, this.missingModel);
        final HashSet textures = Sets.newHashSet(ModelLoaderRegistry.getTextures());
        textures.remove(bvd.f);
        textures.addAll(b);
        this.l.a(this.g, new buw(){

            public void a(bvd map) {
                for (kl t : textures) {
                    map.a(t);
                }
            }
        });
        bxl missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), bvm.b, DefaultTextureGetter.INSTANCE);
        HashMap bakedModels = Maps.newHashMap();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.stateModels), (Multimap)models);
        ProgressManager.ProgressBar bakeBar = ProgressManager.push("ModelLoader: baking", models.keySet().size());
        for (IModel iModel : models.keySet()) {
            bakeBar.step("[" + Joiner.on((String)", ").join((Iterable)models.get((Object)iModel)) + "]");
            if (iModel == this.getMissingModel()) {
                bakedModels.put(iModel, missingBaked);
                continue;
            }
            bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), bvm.b, DefaultTextureGetter.INSTANCE));
        }
        ProgressManager.pop(bakeBar);
        for (Map.Entry entry : this.stateModels.entrySet()) {
            this.p.a(entry.getKey(), bakedModels.get(entry.getValue()));
        }
        return this.p;
    }

    protected void d() {
    }

    protected void e() {
    }

    protected void b() {
        ArrayList blocks = Lists.newArrayList((Iterable)Iterables.filter((Iterable)ajt.h, (Predicate)new Predicate<ajt>(){

            public boolean apply(ajt block) {
                return block.getRegistryName() != null;
            }
        }));
        Collections.sort(blocks, new Comparator<ajt>(){

            @Override
            public int compare(ajt b1, ajt b2) {
                return b1.getRegistryName().toString().compareTo(b2.getRegistryName().toString());
            }
        });
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", blocks.size());
        bpc mapper = this.m.a();
        for (ajt block : blocks) {
            blockBar.step(block.getRegistryName().toString());
            for (kl location : mapper.a(block)) {
                this.loadBlock(mapper, block, location);
            }
        }
        ProgressManager.pop(blockBar);
    }

    protected void a(boi definition, bxq location) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel((kl)location);
        }
        catch (Exception e) {
            this.storeException((kl)location, e);
            model = this.getMissingModel();
        }
        this.stateModels.put(location, model);
    }

    protected void registerMultipartVariant(boi definition, Collection<bxq> locations) {
        for (bxq location : locations) {
            this.a(null, location);
        }
    }

    private void storeException(kl location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    protected boi a(kl location) {
        try {
            return super.a(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + location, exception));
            return new boi(new ArrayList());
        }
    }

    protected void f() {
        if (FluidRegistry.isUniversalBucketEnabled()) {
            ModelLoader.setBucketModelDefinition(ForgeModContainer.getInstance().universalBucket);
        }
        this.g();
        ArrayList items = Lists.newArrayList((Iterable)Iterables.filter((Iterable)ado.g, (Predicate)new Predicate<ado>(){

            public boolean apply(ado item) {
                return item.getRegistryName() != null;
            }
        }));
        Collections.sort(items, new Comparator<ado>(){

            @Override
            public int compare(ado i1, ado i2) {
                return i1.getRegistryName().toString().compareTo(i2.getRegistryName().toString());
            }
        });
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", items.size());
        for (ado item : items) {
            itemBar.step(item.getRegistryName().toString());
            for (String s : this.a(item)) {
                kl file = this.a(s);
                bxq memory = ModelLoader.getInventoryVariant(s);
                IModel model = ModelLoaderRegistry.getMissingModel();
                ItemLoadingException exception = null;
                try {
                    model = ModelLoaderRegistry.getModel(file);
                }
                catch (Exception normalException) {
                    FMLLog.fine("Item json isn't found for '" + memory + "', trying to load the variant from the blockstate json", new Object[0]);
                    try {
                        model = ModelLoaderRegistry.getModel((kl)memory);
                    }
                    catch (Exception blockstateException) {
                        exception = new ItemLoadingException("Could not load item model either from the normal location " + file + " or from the blockstate", normalException, blockstateException);
                    }
                }
                this.stateModels.put(memory, model);
                if (exception == null) continue;
                this.storeException((kl)memory, exception);
            }
        }
        ProgressManager.pop(itemBar);
        if (ForgeModContainer.replaceVanillaBucketModel) {
            IModel model;
            bxq memory;
            if (!this.stateModels.containsKey(ModelDynBucket.LOCATION)) {
                try {
                    this.a(this.a((kl)ModelDynBucket.LOCATION), ModelDynBucket.LOCATION);
                }
                catch (Exception exception) {
                    FMLLog.getLogger().error("Could not load the forge bucket model from the blockstate", (Throwable)exception);
                    return;
                }
            }
            for (String s : this.a(ads.ay)) {
                memory = ModelLoader.getInventoryVariant(s);
                model = ModelLoaderRegistry.getModelOrMissing(new kl("forge", "item/bucket"));
                if (model == this.getMissingModel()) continue;
                this.stateModels.put(memory, model);
            }
            this.setBucketModel(ads.az);
            this.setBucketModel(ads.aA);
            if (FluidRegistry.isFluidRegistered("milk")) {
                Fluid milk = FluidRegistry.getFluid("milk");
                FluidStack milkStack = new FluidStack(milk, 1000);
                if (FluidContainerRegistry.getContainerCapacity(milkStack, new adq(ads.ay)) == 1000) {
                    this.setBucketModel(ads.aN);
                }
            } else {
                for (String s : this.a(ads.aN)) {
                    memory = ModelLoader.getInventoryVariant(s);
                    model = ModelLoaderRegistry.getModelOrMissing(new kl("forge", "item/bucket_milk"));
                    if (model == this.getMissingModel()) continue;
                    this.stateModels.put(memory, model);
                }
            }
        }
    }

    private void setBucketModel(ado item) {
        for (String s : this.a(item)) {
            bxq memory = ModelLoader.getInventoryVariant(s);
            IModel model = this.stateModels.get(ModelDynBucket.LOCATION);
            if (model == null) continue;
            this.stateModels.put(memory, model);
        }
    }

    public static bxq getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new bxq(s);
        }
        return new bxq(s, "inventory");
    }

    protected kl d(kl model) {
        return new kl(model.b(), model.a() + ".json");
    }

    protected IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.INSTANCE.loadModel(new kl(a.b(), a.a()));
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(dd<bxq, bxl> modelRegistry) {
        bxl missingModel = (bxl)modelRegistry.c((Object)a);
        HashMap modelErrors = Maps.newHashMap();
        HashSet printedBlockStateErrors = Sets.newHashSet();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = null;
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry<Object, Exception> entry : this.m.a().a().entrySet()) {
                reverseBlockMap.put((Object)entry.getValue(), entry.getKey());
            }
            reverseItemMap = HashMultimap.create();
            for (ado ado2 : GameData.getItemRegistry().typeSafeIterable()) {
                for (String s : this.a(ado2)) {
                    bxq memory = ModelLoader.getInventoryVariant(s);
                    reverseItemMap.put((Object)memory, (Object)ado2.getRegistryName().toString());
                }
            }
        }
        for (Map.Entry<Object, Exception> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof bxq)) continue;
            bxq location = (bxq)entry.getKey();
            bxl model = (bxl)modelRegistry.c((Object)location);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = ((kl)entry.getKey()).b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n2 = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    String errorMsg = "Exception loading model for variant " + entry.getKey();
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + blocks.iterator().next() + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    if (entry.getValue() instanceof ItemLoadingException) {
                        ItemLoadingException ex = (ItemLoadingException)entry.getValue();
                        FMLLog.getLogger().error(errorMsg + ", normal location exception: ", (Throwable)ex.normalException);
                        FMLLog.getLogger().error(errorMsg + ", blockstate location exception: ", (Throwable)ex.blockstateException);
                    } else {
                        FMLLog.getLogger().error(errorMsg, (Throwable)entry.getValue());
                    }
                    kl blockstateLocation = new kl(location.b(), location.a());
                    if (this.loadingExceptions.containsKey(blockstateLocation) && !printedBlockStateErrors.contains(blockstateLocation)) {
                        FMLLog.getLogger().error("Exception loading blockstate for the variant " + location + ": ", (Throwable)this.loadingExceptions.get(blockstateLocation));
                        printedBlockStateErrors.add(blockstateLocation);
                    }
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)location, (Object)missingModel);
        }
        for (bxq bxq2 : this.missingVariants) {
            bxl model = (bxl)modelRegistry.c((Object)bxq2);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = bxq2.b();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n3 = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    FMLLog.severe("Model definition for location %s not found", bxq2);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.a((Object)bxq2, (Object)missingModel);
        }
        for (Map.Entry<Object, Exception> entry : modelErrors.entrySet()) {
            if ((Integer)((Object)entry.getValue()) < this.verboseMissingInfoCount) continue;
            FMLLog.severe("Suppressed additional %s model loading errors for domain %s", (Integer)((Object)entry.getValue()) - this.verboseMissingInfoCount, entry.getKey());
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(ajt block, bpf mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bny shapes) {
        for (Map.Entry<RegistryDelegate<ajt>, bpf> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(ado item, int metadata, bxq model) {
        customModels.put((Pair<RegistryDelegate<ado>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        bxo.registerItemVariants((ado)item, (kl[])new kl[]{model});
    }

    public static void setCustomMeshDefinition(ado item, bnj meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(ado item) {
        ModelLoader.setCustomMeshDefinition(item, new bnj(){

            public bxq a(adq stack) {
                return ModelDynBucket.LOCATION;
            }
        });
        bxo.registerItemVariants((ado)item, (kl[])new kl[]{ModelDynBucket.LOCATION});
    }

    public static void onRegisterItems(bni mesher) {
        for (Map.Entry<RegistryDelegate<ado>, bnj> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<ado>, bnj> entry : customModels.entrySet()) {
            mesher.a((ado)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (bxq)entry.getValue());
        }
    }

    public static Function<kl, bve> defaultTextureGetter() {
        return DefaultTextureGetter.INSTANCE;
    }

    private static class MultipartModel
    implements IModel {
        private final kl location;
        private final bov multipart;
        private final ImmutableMap<box, IModel> partModels;

        public MultipartModel(kl location, bov multipart) throws Exception {
            this.location = location;
            this.multipart = multipart;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (box selector : multipart.a()) {
                builder.put((Object)selector, (Object)new WeightedRandomModel(location, selector.a()));
            }
            this.partModels = builder.build();
        }

        @Override
        public Collection<kl> getDependencies() {
            return ImmutableSet.of();
        }

        @Override
        public Collection<kl> getTextures() {
            return ImmutableSet.of();
        }

        @Override
        public bxl bake(IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
            bxr.a builder = new bxr.a();
            for (box selector : this.multipart.a()) {
                builder.a(selector.a(this.multipart.c()), ((IModel)this.partModels.get((Object)selector)).bake(((IModel)this.partModels.get((Object)selector)).getDefaultState(), format, bakedTextureGetter));
            }
            bxl bakedModel = builder.a();
            return bakedModel;
        }

        @Override
        public IModelState getDefaultState() {
            return TRSRTransformation.identity();
        }
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        public void a(bwd resourceManager) {
        }

        @Override
        public boolean accepts(kl modelLocation) {
            return modelLocation instanceof bxq;
        }

        @Override
        public IModel loadModel(kl modelLocation) throws Exception {
            bxq variant = (bxq)modelLocation;
            boi definition = this.loader.a((kl)variant);
            try {
                boq variants = definition.c(variant.c());
                return new WeightedRandomModel((kl)variant, variants);
            }
            catch (boi.b e) {
                if (definition.b()) {
                    return new MultipartModel(new kl(variant.b(), variant.a()), definition.c());
                }
                throw e;
            }
        }

        public String toString() {
            return "VariantLoader.INSTANCE";
        }
    }

    private static enum DefaultTextureGetter implements Function<kl, bve>
    {
        INSTANCE;


        public bve apply(kl location) {
            return bcd.z().R().a(location.toString());
        }
    }

    private static class ItemLoadingException
    extends ModelLoaderRegistry.LoaderException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    public static final class White
    extends bve {
        public static final kl LOCATION = new kl("white");
        public static final White INSTANCE = new White();

        private White() {
            super(LOCATION.toString());
        }

        public boolean hasCustomLoader(bwd manager, kl location) {
            return true;
        }

        public boolean load(bwd manager, kl location) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, 16, 16);
            int[][] pixels = new int[bcd.z().u.J + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.l();
            this.a.add(pixels);
            return false;
        }

        public void register(bvd map) {
            map.setTextureEntry(LOCATION.toString(), (bve)INSTANCE);
        }
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(bwd resourceManager) {
        }

        @Override
        public boolean accepts(kl modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(kl modelLocation) throws Exception {
            if (modelLocation.equals((Object)a) && this.loader.missingModel != null) {
                return this.loader.getMissingModel();
            }
            String modelPath = modelLocation.a();
            if (modelLocation.a().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            kl armatureLocation = new kl(modelLocation.b(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation(this.loader.g, armatureLocation);
            boh model = this.loader.c(modelLocation);
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            VanillaModelWrapper iModel = modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
            if (this.loader.missingModel == null && modelLocation.equals((Object)a)) {
                this.loader.missingModel = iModel;
            }
            return iModel;
        }

        public String toString() {
            return "VanillaLoader.INSTANCE";
        }
    }

    private static final class WeightedRandomModel
    implements IModel {
        private final List<bor> variants;
        private final List<kl> locations = new ArrayList<kl>();
        private final Set<kl> textures = Sets.newHashSet();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        public WeightedRandomModel(kl parent, boq variants) throws Exception {
            this.variants = variants.a();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bor v : this.variants) {
                kl loc = v.a();
                this.locations.add(loc);
                IModel model = loc.equals((Object)a) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel(loc);
                model = v.process(model);
                for (kl location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing(location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                builder.add((Object)Pair.of((Object)model, (Object)v.getState()));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        @Override
        public Collection<kl> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<kl> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        @Override
        public bxl bake(IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState(state, model, 0), format, bakedTextureGetter);
            }
            bxt.a builder = new bxt.a();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                builder.a(model.bake(MultiModelState.getPartState(state, model, i), format, bakedTextureGetter), this.variants.get(i).d());
            }
            return builder.a();
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private final class VanillaModelWrapper
    implements IRetexturableModel,
    IModelSimpleProperties,
    IModelUVLock,
    IAnimatedModel {
        private final kl location;
        private final boh model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(kl location, boh model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        @Override
        public Collection<kl> getDependencies() {
            HashSet set = Sets.newHashSet();
            for (kl dep : this.model.e()) {
                if (this.location.equals((Object)dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + dep + " for model " + this.location));
            }
            if (this.model.h() != null && !this.model.h().a().startsWith("builtin/")) {
                set.add(this.model.h());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        @Override
        public Collection<kl> getTextures() {
            if (this.model.h() != null) {
                if (this.model.h().a().equals("builtin/generated")) {
                    this.model.d = r;
                } else {
                    IModel parent = ModelLoaderRegistry.getModelOrLogError(this.model.h(), "Could not load vanilla model parent '" + this.model.h() + "' for '" + this.model);
                    if (parent instanceof VanillaModelWrapper) {
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    } else {
                        throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : bol.a) {
                    String r2 = this.model.c(s);
                    kl loc = new kl(r2);
                    if (r2.equals(s)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new kl(s));
            }
            return builder.build();
        }

        @Override
        public bxl bake(IModelState state, bvo format, Function<kl, bve> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            boh model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.a().size(); ++i) {
                bod part = (bod)model.a().get(i);
                newTransforms.add(this.animation.getPartTransform(state, part, i));
            }
            bop transforms = model.j();
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(transforms));
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new bxn(transforms, model.g());
            }
            return this.bakeNormal(model, perState, state, newTransforms, format, bakedTextureGetter, this.uvlock);
        }

        private bxl bakeNormal(boh model, IModelState perState, final IModelState modelState, List<TRSRTransformation> newTransforms, final bvo format, final Function<kl, bve> bakedTextureGetter, boolean uvLocked) {
            TRSRTransformation baseState = (TRSRTransformation)modelState.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity());
            bve particle = (bve)bakedTextureGetter.apply((Object)new kl(model.c("particle")));
            bxs.a builder = new bxs.a(model, model.g()).a(particle);
            for (int i = 0; i < model.a().size(); ++i) {
                if (modelState.apply((Optional<? extends IModelPart>)Optional.of((Object)Models.getHiddenModelPart((ImmutableList<String>)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
                bod part = (bod)model.a().get(i);
                TRSRTransformation transformation = baseState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                    bof rot = part.d;
                    if (rot == null) {
                        rot = new bof(new Vector3f(), cs.a.b, 0.0f, false);
                    }
                    part = new bod(part.a, part.b, part.c, rot, part.e);
                }
                for (Map.Entry e : part.c.entrySet()) {
                    bve textureatlassprite1 = (bve)bakedTextureGetter.apply((Object)new kl(model.c(((boe)e.getValue()).d)));
                    if (((boe)e.getValue()).b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, (boe)e.getValue(), textureatlassprite1, (cs)e.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(baseState.rotate(((boe)e.getValue()).b), ModelLoader.this.makeBakedQuad(part, (boe)e.getValue(), textureatlassprite1, (cs)e.getKey(), transformation, uvLocked));
                }
            }
            return new IPerspectiveAwareModel.MapWrapper(builder.b(), perState){
                private final bon overrides;
                {
                    super(parent, state);
                    this.overrides = new AnimationItemOverrideList((IModel)VanillaModelWrapper.this, modelState, format, (Function<kl, bve>)bakedTextureGetter, super.f());
                }

                @Override
                public List<boc> a(ard state, cs side, long rand) {
                    IExtendedBlockState exState;
                    if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                        IModelState newState = exState.getValue(Properties.AnimationProperty);
                        IExtendedBlockState newExState = exState.withProperty(Properties.AnimationProperty, null);
                        if (newState != null) {
                            return VanillaModelWrapper.this.bake(new ModelStateComposition(modelState, newState), format, (Function<kl, bve>)bakedTextureGetter).a((ard)newExState, side, rand);
                        }
                    }
                    return super.a(state, side, rand);
                }

                @Override
                public bon f() {
                    return this.overrides;
                }
            };
        }

        @Override
        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bod part : this.model.a()) {
                elements.add(new bod(part.a, part.b, (Map)Maps.newHashMap((Map)part.c), part.d, part.e));
            }
            boh newModel = new boh(this.model.h(), (List)elements, (Map)Maps.newHashMap((Map)this.model.c), this.model.b(), this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.b = this.model.b;
            newModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    newModel.c.remove(e.getKey());
                    continue;
                }
                newModel.c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : newModel.c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !newModel.c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), newModel.c.get(key));
            }
            newModel.c.putAll(remapped);
            for (bod part : newModel.a()) {
                Iterator itr = part.c.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (!removed.contains(((boe)entry.getValue()).d)) continue;
                    itr.remove();
                }
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.fromNullable((Object)this.animation.getClips().get((Object)name));
            }
            return Optional.absent();
        }

        @Override
        public IModelState getDefaultState() {
            return bxm.a;
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.i == value) {
                return this;
            }
            boh newModel = new boh(this.model.h(), this.model.a(), this.model.c, value, this.model.c(), this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.c() == value) {
                return this;
            }
            boh newModel = new boh(this.model.h(), this.model.a(), this.model.c, this.model.i, value, this.model.j(), (List)Lists.newArrayList((Iterable)this.model.f()));
            newModel.d = this.model.d;
            newModel.b = this.model.b;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public IModel uvlock(boolean value) {
            if (this.uvlock == value) {
                return this;
            }
            return new VanillaModelWrapper(this.location, this.model, value, this.animation);
        }
    }
}

