/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.io.IOException;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiScrollingList {
    private final bcd client;
    protected final int listWidth;
    protected final int listHeight;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int top;
    protected final int bottom;
    protected final int right;
    protected final int left;
    protected final int slotHeight;
    private int scrollUpActionId;
    private int scrollDownActionId;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    private float scrollDistance;
    protected int selectedIndex = -1;
    private long lastClickTime = 0L;
    private boolean highlightSelected = true;
    private boolean hasHeader;
    private int headerHeight;
    protected boolean captureMouse = true;

    @Deprecated
    public GuiScrollingList(bcd client, int width, int height, int top, int bottom, int left, int entryHeight) {
        this(client, width, height, top, bottom, left, entryHeight, width, height);
    }

    public GuiScrollingList(bcd client, int width, int height, int top, int bottom, int left, int entryHeight, int screenWidth, int screenHeight) {
        this.client = client;
        this.listWidth = width;
        this.listHeight = height;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Deprecated
    public void func_27258_a(boolean p_27258_1_) {
        this.highlightSelected = p_27258_1_;
    }

    @Deprecated
    protected void func_27259_a(boolean hasFooter, int footerHeight) {
        this.setHeaderInfo(hasFooter, footerHeight);
    }

    protected void setHeaderInfo(boolean hasHeader, int headerHeight) {
        this.hasHeader = hasHeader;
        this.headerHeight = headerHeight;
        if (!hasHeader) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, bnr var5);

    @Deprecated
    protected void func_27260_a(int entryRight, int relativeY, bnr tess) {
    }

    protected void drawHeader(int entryRight, int relativeY, bnr tess) {
        this.func_27260_a(entryRight, relativeY, tess);
    }

    @Deprecated
    protected void func_27255_a(int x, int y) {
    }

    protected void clickHeader(int x, int y) {
        this.func_27255_a(x, y);
    }

    @Deprecated
    protected void func_27257_b(int mouseX, int mouseY) {
    }

    protected void drawScreen(int mouseX, int mouseY) {
        this.func_27257_b(mouseX, mouseY);
    }

    @Deprecated
    public int func_27256_c(int x, int y) {
        int left = this.left + 1;
        int right = this.left + this.listWidth - 7;
        int relativeY = y - this.top - this.headerHeight + (int)this.scrollDistance - 4;
        int entryIndex = relativeY / this.slotHeight;
        return x >= left && x <= right && entryIndex >= 0 && relativeY >= 0 && entryIndex < this.getSize() ? entryIndex : -1;
    }

    public void registerScrollButtons(List<bcx> buttons, int upActionID, int downActionID) {
        this.scrollUpActionId = upActionID;
        this.scrollDownActionId = downActionID;
    }

    private void applyScrollLimits() {
        int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
        if (listHeight < 0) {
            listHeight /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)listHeight) {
            this.scrollDistance = listHeight;
        }
    }

    public void actionPerformed(bcx button) {
        if (button.l) {
            if (button.k == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.k == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void handleMouseInput(int mouseX, int mouseY) throws IOException {
        boolean isHovering;
        boolean bl = isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        if (!isHovering) {
            return;
        }
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            this.scrollDistance += (float)(-1 * scroll) / 120.0f * (float)this.slotHeight / 2.0f;
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackground();
        boolean isHovering = mouseX >= this.left && mouseX <= this.left + this.listWidth && mouseY >= this.top && mouseY <= this.bottom;
        int listLength = this.getSize();
        int scrollBarWidth = 6;
        int scrollBarRight = this.left + this.listWidth;
        int scrollBarLeft = scrollBarRight - scrollBarWidth;
        int entryLeft = this.left;
        int entryRight = scrollBarLeft - 1;
        int viewHeight = this.bottom - this.top;
        int border = 4;
        if (Mouse.isButtonDown((int)0)) {
            if (this.initialMouseClickY == -1.0f) {
                if (isHovering) {
                    int mouseListY = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - border;
                    int slotIndex = mouseListY / this.slotHeight;
                    if (mouseX >= entryLeft && mouseX <= entryRight && slotIndex >= 0 && mouseListY >= 0 && slotIndex < listLength) {
                        this.elementClicked(slotIndex, slotIndex == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L);
                        this.selectedIndex = slotIndex;
                        this.lastClickTime = System.currentTimeMillis();
                    } else if (mouseX >= entryLeft && mouseX <= entryRight && mouseListY < 0) {
                        this.clickHeader(mouseX - entryLeft, mouseY - this.top + (int)this.scrollDistance - border);
                    }
                    if (mouseX >= scrollBarLeft && mouseX <= scrollBarRight) {
                        int var13;
                        this.scrollFactor = -1.0f;
                        int scrollHeight = this.getContentHeight() - viewHeight - border;
                        if (scrollHeight < 1) {
                            scrollHeight = 1;
                        }
                        if ((var13 = (int)((float)(viewHeight * viewHeight) / (float)this.getContentHeight())) < 32) {
                            var13 = 32;
                        }
                        if (var13 > viewHeight - border * 2) {
                            var13 = viewHeight - border * 2;
                        }
                        this.scrollFactor /= (float)(viewHeight - var13) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.initialMouseClickY = mouseY;
                } else {
                    this.initialMouseClickY = -2.0f;
                }
            } else if (this.initialMouseClickY >= 0.0f) {
                this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                this.initialMouseClickY = mouseY;
            }
        } else {
            this.initialMouseClickY = -1.0f;
        }
        this.applyScrollLimits();
        bnr tess = bnr.a();
        bmx worldr = tess.c();
        bcv res = new bcv(this.client);
        double scaleW = (double)this.client.d / res.c();
        double scaleH = (double)this.client.e / res.d();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scaleW)), (int)((int)((double)this.client.e - (double)this.bottom * scaleH)), (int)((int)((double)this.listWidth * scaleW)), (int)((int)((double)viewHeight * scaleH)));
        if (this.client.f != null) {
            this.drawGradientRect(this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        } else {
            bnf.g();
            bnf.p();
            this.client.S.a(bct.b);
            bnf.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            worldr.a(7, bvm.i);
            worldr.b((double)this.left, (double)this.bottom, 0.0).a((double)((float)this.left / scale), (double)((float)(this.bottom + (int)this.scrollDistance) / scale)).b(32, 32, 32, 255).d();
            worldr.b((double)this.right, (double)this.bottom, 0.0).a((double)((float)this.right / scale), (double)((float)(this.bottom + (int)this.scrollDistance) / scale)).b(32, 32, 32, 255).d();
            worldr.b((double)this.right, (double)this.top, 0.0).a((double)((float)this.right / scale), (double)((float)(this.top + (int)this.scrollDistance) / scale)).b(32, 32, 32, 255).d();
            worldr.b((double)this.left, (double)this.top, 0.0).a((double)((float)this.left / scale), (double)((float)(this.top + (int)this.scrollDistance) / scale)).b(32, 32, 32, 255).d();
            tess.b();
        }
        int baseY = this.top + border - (int)this.scrollDistance;
        if (this.hasHeader) {
            this.drawHeader(entryRight, baseY, tess);
        }
        for (int slotIdx = 0; slotIdx < listLength; ++slotIdx) {
            int slotTop = baseY + slotIdx * this.slotHeight + this.headerHeight;
            int slotBuffer = this.slotHeight - border;
            if (slotTop > this.bottom || slotTop + slotBuffer < this.top) continue;
            if (this.highlightSelected && this.isSelected(slotIdx)) {
                int min = this.left;
                int max = entryRight;
                bnf.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                bnf.z();
                worldr.a(7, bvm.i);
                worldr.b((double)min, (double)(slotTop + slotBuffer + 2), 0.0).a(0.0, 1.0).b(128, 128, 128, 255).d();
                worldr.b((double)max, (double)(slotTop + slotBuffer + 2), 0.0).a(1.0, 1.0).b(128, 128, 128, 255).d();
                worldr.b((double)max, (double)(slotTop - 2), 0.0).a(1.0, 0.0).b(128, 128, 128, 255).d();
                worldr.b((double)min, (double)(slotTop - 2), 0.0).a(0.0, 0.0).b(128, 128, 128, 255).d();
                worldr.b((double)(min + 1), (double)(slotTop + slotBuffer + 1), 0.0).a(0.0, 1.0).b(0, 0, 0, 255).d();
                worldr.b((double)(max - 1), (double)(slotTop + slotBuffer + 1), 0.0).a(1.0, 1.0).b(0, 0, 0, 255).d();
                worldr.b((double)(max - 1), (double)(slotTop - 1), 0.0).a(1.0, 0.0).b(0, 0, 0, 255).d();
                worldr.b((double)(min + 1), (double)(slotTop - 1), 0.0).a(0.0, 0.0).b(0, 0, 0, 255).d();
                tess.b();
                bnf.y();
            }
            this.drawSlot(slotIdx, entryRight, slotTop, slotBuffer, tess);
        }
        bnf.j();
        int extraHeight = this.getContentHeight() + border - viewHeight;
        if (extraHeight > 0) {
            int barTop;
            int height = viewHeight * viewHeight / this.getContentHeight();
            if (height < 32) {
                height = 32;
            }
            if (height > viewHeight - border * 2) {
                height = viewHeight - border * 2;
            }
            if ((barTop = (int)this.scrollDistance * (viewHeight - height) / extraHeight + this.top) < this.top) {
                barTop = this.top;
            }
            bnf.z();
            worldr.a(7, bvm.i);
            worldr.b((double)scrollBarLeft, (double)this.bottom, 0.0).a(0.0, 1.0).b(0, 0, 0, 255).d();
            worldr.b((double)scrollBarRight, (double)this.bottom, 0.0).a(1.0, 1.0).b(0, 0, 0, 255).d();
            worldr.b((double)scrollBarRight, (double)this.top, 0.0).a(1.0, 0.0).b(0, 0, 0, 255).d();
            worldr.b((double)scrollBarLeft, (double)this.top, 0.0).a(0.0, 0.0).b(0, 0, 0, 255).d();
            tess.b();
            worldr.a(7, bvm.i);
            worldr.b((double)scrollBarLeft, (double)(barTop + height), 0.0).a(0.0, 1.0).b(128, 128, 128, 255).d();
            worldr.b((double)scrollBarRight, (double)(barTop + height), 0.0).a(1.0, 1.0).b(128, 128, 128, 255).d();
            worldr.b((double)scrollBarRight, (double)barTop, 0.0).a(1.0, 0.0).b(128, 128, 128, 255).d();
            worldr.b((double)scrollBarLeft, (double)barTop, 0.0).a(0.0, 0.0).b(128, 128, 128, 255).d();
            tess.b();
            worldr.a(7, bvm.i);
            worldr.b((double)scrollBarLeft, (double)(barTop + height - 1), 0.0).a(0.0, 1.0).b(192, 192, 192, 255).d();
            worldr.b((double)(scrollBarRight - 1), (double)(barTop + height - 1), 0.0).a(1.0, 1.0).b(192, 192, 192, 255).d();
            worldr.b((double)(scrollBarRight - 1), (double)barTop, 0.0).a(1.0, 0.0).b(192, 192, 192, 255).d();
            worldr.b((double)scrollBarLeft, (double)barTop, 0.0).a(0.0, 0.0).b(192, 192, 192, 255).d();
            tess.b();
        }
        this.drawScreen(mouseX, mouseY);
        bnf.y();
        bnf.j((int)7424);
        bnf.e();
        bnf.l();
        GL11.glDisable((int)3089);
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int color1, int color2) {
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        bnf.z();
        bnf.m();
        bnf.d();
        bnf.a((int)770, (int)771, (int)1, (int)0);
        bnf.j((int)7425);
        bnr tessellator = bnr.a();
        bmx VertexBuffer = tessellator.c();
        VertexBuffer.a(7, bvm.f);
        VertexBuffer.b((double)right, (double)top, 0.0).a(r1, g1, b1, a1).d();
        VertexBuffer.b((double)left, (double)top, 0.0).a(r1, g1, b1, a1).d();
        VertexBuffer.b((double)left, (double)bottom, 0.0).a(r2, g2, b2, a2).d();
        VertexBuffer.b((double)right, (double)bottom, 0.0).a(r2, g2, b2, a2).d();
        tessellator.b();
        bnf.j((int)7424);
        bnf.l();
        bnf.e();
        bnf.y();
    }
}

