/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiJava8Error;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Java8VersionException;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    static int renderPass = -1;
    static final ThreadLocal<ahm> renderLayer = new ThreadLocal();
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    private static int updatescrollcounter;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final FloatBuffer matrixBuf;
    private static Map<Pair<ado, Integer>, Class<? extends apv>> tileItemMap;
    private static int slotMainHand;

    static bvi engine() {
        return FMLClientHandler.instance().getClient().S;
    }

    public static String getArmorTexture(rr entity, adq armor, String _default, rw slot, String type) {
        String result = armor.b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static void orientBedCamera(ahx world, cj pos, arc state, rr entity) {
        ajt block = state.t();
        if (block != null && block.isBed(state, world, pos, entity)) {
            GL11.glRotatef((float)(block.getBedDirection(state, world, pos).b() * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(bno context, zj player, bbi target, int subID, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post(new DrawBlockHighlightEvent(context, player, target, subID, partialTicks));
    }

    public static void dispatchRenderLast(bno context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post(new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(bno context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post(new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static void onTextureStitchedPre(bvg map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Pre(map));
        ModelLoader.White.INSTANCE.register(map);
    }

    public static void onTextureStitchedPost(bvg map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Post(map));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(ahm layer) {
        renderLayer.set(layer);
    }

    public static bix getArmorModel(sa entityLiving, adq itemStack, rw slot, bix _default) {
        bix model = itemStack.b().getArmorModel(entityLiving, itemStack, slot, _default);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post(new MouseEvent());
    }

    public static float getOffsetFOV(zj entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post(fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static float getFOVModifier(bng renderer, rr entity, arc state, double renderPartialTicks, float fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, entity, state, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getFOV();
    }

    public static int getSkyBlendColour(aht world, cj center) {
        if (center.p() == skyX && center.r() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        bch settings = bcf.z().u;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.i && settings.c >= 0 && settings.c < ranges.length) {
            distance = ranges[settings.c];
        }
        int r = 0;
        int g2 = 0;
        int b2 = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                cj pos = center.a(x, 0, z);
                aig biome = world.b(pos);
                int colour = biome.a(biome.a(pos));
                r += (colour & 0xFF0000) >> 16;
                g2 += (colour & 0xFF00) >> 8;
                b2 += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g2 / divider & 0xFF) << 8 | b2 / divider & 0xFF;
        skyX = center.p();
        skyZ = center.q();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static String renderMainMenu(bfi gui, bct font, int width, int height, String splashText) {
        String line;
        ForgeVersion.Status status = ForgeVersion.getStatus();
        if (status == ForgeVersion.Status.BETA || status == ForgeVersion.Status.BETA_OUTDATED) {
            line = bwo.a((String)"forge.update.beta.1", (Object[])new Object[]{a.m, a.v});
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 0 * (font.a + 1), -1);
            line = bwo.a((String)"forge.update.beta.2", (Object[])new Object[0]);
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 1 * (font.a + 1), -1);
        }
        if (!Loader.instance().java8) {
            line = bwo.a((String)"fml.messages.java8warning.1", (Object[])new Object[]{a.m, a.v});
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 8 * (font.a + 1), -1);
            line = bwo.a((String)"fml.messages.java8warning.2", (Object[])new Object[0]);
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 9 * (font.a + 1), -1);
            splashText = updatescrollcounter < 50 ? "UPDATE!" : "JAVA!";
            ++updatescrollcounter;
            updatescrollcounter %= 100;
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = bwo.a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        if (line != null) {
            gui.c(font, line, width - font.a(line) - 2, height - 2 * (font.a + 1), -1);
        }
        return splashText;
    }

    public static void mainMenuMouseClick(int mouseX, int mouseY, int mouseButton, bct font, int width) {
        if (!Loader.instance().java8 && mouseY >= 84 && mouseY < 104) {
            int w = font.a(bwo.a((String)"fml.messages.java8warning.1", (Object[])new Object[]{a.m, a.v}));
            if (mouseX >= (width - (w = Math.max(w, font.a(bwo.a((String)"fml.messages.java8warning.2", (Object[])new Object[0]))))) / 2 && mouseX <= (width + w) / 2) {
                FMLClientHandler.instance().showGuiScreen((Object)new GuiJava8Error(new Java8VersionException(Collections.<ModContainer>emptyList())));
            }
        }
    }

    public static byi playSound(byv manager, byi sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(bfb screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.a(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(bng renderer, rr entity, arc state, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(renderer, entity, state, partial, density);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(bng renderer, rr entity, arc state, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post(new EntityViewRenderEvent.RenderFogEvent(renderer, entity, state, partial, mode, distance));
    }

    public static void onModelBake(bxs modelManager, db<bxt, bxo> modelRegistry, ModelLoader modelLoader) {
        MinecraftForge.EVENT_BUS.post(new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static Matrix4f getMatrix(bor transform) {
        Matrix4f m2 = new Matrix4f();
        Matrix4f t = new Matrix4f();
        m2.setIdentity();
        m2.setTranslation(TRSRTransformation.toVecmath(transform.c));
        t.setIdentity();
        t.rotY(transform.b.y);
        m2.mul(t);
        t.setIdentity();
        t.rotX(transform.b.x);
        m2.mul(t);
        t.setIdentity();
        t.rotZ(transform.b.z);
        m2.mul(t);
        t.setIdentity();
        t.m00 = transform.d.x;
        t.m11 = transform.d.y;
        t.m22 = transform.d.z;
        m2.mul(t);
        return m2;
    }

    public static bxo handleCameraTransforms(bxo model, bos.b cameraTransformType, boolean leftHandHackery) {
        if (model instanceof IPerspectiveAwareModel) {
            Pair<? extends bxo, Matrix4f> pair = ((IPerspectiveAwareModel)model).handlePerspective(cameraTransformType);
            if (pair.getRight() != null) {
                Matrix4f matrix = new Matrix4f((Matrix4f)pair.getRight());
                if (leftHandHackery) {
                    matrix.mul(flipX, matrix);
                    matrix.mul(matrix, flipX);
                }
                ForgeHooksClient.multiplyCurrentGlMatrix(matrix);
            }
            return (bxo)pair.getLeft();
        }
        bos.a((bor)model.e().b(cameraTransformType), (boolean)leftHandHackery);
        return model;
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrix((FloatBuffer)matrixBuf);
    }

    public static void preDraw(bvs.b attrType, bvr format, int element, int stride, ByteBuffer buffer) {
        bvs attr = format.c(element);
        int count = attr.c();
        int constant = attr.a().c();
        buffer.position(format.d(element));
        switch (attrType) {
            case a: {
                GL11.glVertexPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32884);
                break;
            }
            case b: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL11.glNormalPointer((int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glColorPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32886);
                break;
            }
            case d: {
                bzg.l((int)(bzg.q + attr.d()));
                GL11.glTexCoordPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32888);
                bzg.l((int)bzg.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.d());
                GL20.glVertexAttribPointer((int)attr.d(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void postDraw(bvs.b attrType, bvr format, int element, int stride, ByteBuffer buffer) {
        bvs attr = format.c(element);
        switch (attrType) {
            case a: {
                GL11.glDisableClientState((int)32884);
                break;
            }
            case b: {
                GL11.glDisableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glDisableClientState((int)32886);
                bni.I();
                break;
            }
            case d: {
                bzg.l((int)(bzg.q + attr.d()));
                GL11.glDisableClientState((int)32888);
                bzg.l((int)bzg.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.d());
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void transform(org.lwjgl.util.vector.Vector3f vec, Matrix4f m2) {
        Vector4f tmp = new Vector4f(vec.x, vec.y, vec.z, 1.0f);
        m2.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.set(tmp.x, tmp.y, tmp.z);
    }

    public static Matrix4f getMatrix(bxp modelRotation) {
        Matrix4f ret = new Matrix4f(TRSRTransformation.toVecmath(modelRotation.a()));
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(bmz renderer, bof quad, int color) {
        float cb = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cr = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        bvr format = quad.getFormat();
        int size = format.f();
        int offset = format.e() / 4;
        for (int i = 0; i < 4; ++i) {
            int vc = quad.b()[offset + size * i];
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.a(renderer.c(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderTileItem(ado item, int metadata) {
        bpn r;
        Class<? extends apv> tileClass = tileItemMap.get(Pair.of((Object)item, (Object)metadata));
        if (tileClass != null && (r = bpm.a.a(tileClass)) != null) {
            r.a(null, 0.0, 0.0, 0.0, 0.0f, -1);
        }
    }

    @Deprecated
    public static void registerTESRItemStack(ado item, int metadata, Class<? extends apv> TileClass) {
        tileItemMap.put((Pair<ado, Integer>)Pair.of((Object)item, (Object)metadata), TileClass);
    }

    public static void fillNormal(int[] faceData, cq facing) {
        Vector3f v1 = new Vector3f((float)faceData[21], (float)faceData[22], (float)faceData[23]);
        Vector3f t = new Vector3f((float)faceData[7], (float)faceData[8], (float)faceData[9]);
        Vector3f v2 = new Vector3f((float)faceData[14], (float)faceData[15], (float)faceData[16]);
        v1.sub((Tuple3f)t);
        t.set((float)faceData[0], (float)faceData[1], (float)faceData[2]);
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x = (byte)(v1.x * 127.0f) & 0xFF;
        int y = (byte)(v1.y * 127.0f) & 0xFF;
        int z = (byte)(v1.z * 127.0f) & 0xFF;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = x | y << 8 | z << 16;
        }
    }

    public static Optional<TRSRTransformation> applyTransform(bor transform, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)TRSRTransformation.blockCenterToCorner(new TRSRTransformation(transform)));
    }

    public static Optional<TRSRTransformation> applyTransform(Matrix4f matrix, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new TRSRTransformation(matrix));
    }

    public static void loadEntityShader(rr entity, bng entityRenderer) {
        kk shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.a(shader);
        }
    }

    public static bxo getDamageModel(bxo ibakedmodel, bvh texture, arc state, ahx world, cj pos) {
        return new bxv.a(state, ibakedmodel, texture, pos).b();
    }

    public static boolean shouldCauseReequipAnimation(adq from, adq to, int slot) {
        if (from == null && to != null) {
            return true;
        }
        if (from == null && to == null) {
            return false;
        }
        if (from != null && to == null) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.b().shouldCauseReequipAnimation(from, to, changed);
    }

    public static boj applyUVLock(boj blockFaceUV, cq originalSide, ITransformation rotation) {
        float t;
        TRSRTransformation global = new TRSRTransformation(rotation.getMatrix());
        Matrix4f uv = global.getUVLockTransform(originalSide).getMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.x = blockFaceUV.a(blockFaceUV.c(0)) / 16.0f;
        vec.y = blockFaceUV.b(blockFaceUV.c(0)) / 16.0f;
        uv.transform((Tuple4f)vec);
        float uMin = 16.0f * vec.x;
        float vMin = 16.0f * vec.y;
        vec.x = blockFaceUV.a(blockFaceUV.c(2)) / 16.0f;
        vec.y = blockFaceUV.b(blockFaceUV.c(2)) / 16.0f;
        vec.z = 0.0f;
        vec.w = 1.0f;
        uv.transform((Tuple4f)vec);
        float uMax = 16.0f * vec.x;
        float vMax = 16.0f * vec.y;
        if (uMin > uMax) {
            t = uMin;
            uMin = uMax;
            uMax = t;
        }
        if (vMin > vMax) {
            t = vMin;
            vMin = vMax;
            vMax = t;
        }
        float a2 = (float)Math.toRadians(blockFaceUV.b);
        Vector3f rv = new Vector3f(on.b((float)a2), on.a((float)a2), 0.0f);
        Matrix3f rot = new Matrix3f();
        uv.getRotationScale(rot);
        rot.transform((Tuple3f)rv);
        int angle = on.b((int)(-((int)Math.round(Math.toDegrees(Math.atan2(rv.y, rv.x)) / 90.0)) * 90), (int)360);
        return new boj(new float[]{uMin, vMin, uMax, vMax}, angle);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(bcx res, bdh bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void bossBarRenderPost(bcx res) {
        MinecraftForge.EVENT_BUS.post(new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(BufferedImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    static {
        updatescrollcounter = 0;
        flipX = new Matrix4f();
        flipX.setIdentity();
        ForgeHooksClient.flipX.m00 = -1.0f;
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
        tileItemMap = Maps.newHashMap();
        slotMainHand = 0;
    }
}

