/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public interface IPerspectiveAwareModel
extends bxo {
    public Pair<? extends bxo, Matrix4f> handlePerspective(bos.b var1);

    public static class MapWrapper
    implements IPerspectiveAwareModel {
        private final bxo parent;
        private final ImmutableMap<bos.b, TRSRTransformation> transforms;

        public MapWrapper(bxo parent, ImmutableMap<bos.b, TRSRTransformation> transforms) {
            this.parent = parent;
            this.transforms = transforms;
        }

        public MapWrapper(bxo parent, IModelState state) {
            this(parent, MapWrapper.getTransforms(state));
        }

        public static ImmutableMap<bos.b, TRSRTransformation> getTransforms(IModelState state) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bos.b type : bos.b.values()) {
                Optional<TRSRTransformation> tr = state.apply((Optional<? extends IModelPart>)Optional.of((Object)type));
                if (!tr.isPresent()) continue;
                builder.put((Object)type, tr.get());
            }
            return builder.build();
        }

        public static ImmutableMap<bos.b, TRSRTransformation> getTransforms(bos transforms) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bos.b type : bos.b.values()) {
                builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner(new TRSRTransformation(transforms.b(type))));
            }
            return builder.build();
        }

        public static Pair<? extends bxo, Matrix4f> handlePerspective(bxo model, ImmutableMap<bos.b, TRSRTransformation> transforms, bos.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)transforms.get((Object)cameraTransformType);
            Matrix4f mat = null;
            if (tr != null && !tr.equals(TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter(tr).getMatrix();
            }
            return Pair.of((Object)model, mat);
        }

        public static Pair<? extends bxo, Matrix4f> handlePerspective(bxo model, IModelState state, bos.b cameraTransformType) {
            TRSRTransformation tr = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.of((Object)cameraTransformType)).or((Object)TRSRTransformation.identity());
            if (tr != TRSRTransformation.identity()) {
                return Pair.of((Object)model, (Object)TRSRTransformation.blockCornerToCenter(tr).getMatrix());
            }
            return Pair.of((Object)model, null);
        }

        public boolean a() {
            return this.parent.a();
        }

        public boolean b() {
            return this.parent.b();
        }

        public boolean c() {
            return this.parent.c();
        }

        public bvh d() {
            return this.parent.d();
        }

        public bos e() {
            return this.parent.e();
        }

        public List<bof> a(arc state, cq side, long rand) {
            return this.parent.a(state, side, rand);
        }

        public boq f() {
            return this.parent.f();
        }

        @Override
        public Pair<? extends bxo, Matrix4f> handlePerspective(bos.b cameraTransformType) {
            return MapWrapper.handlePerspective((bxo)this, this.transforms, cameraTransformType);
        }
    }
}

