/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<ahm>, bxt>)ImmutableMap.of());
    private final ImmutableMap<Optional<ahm>, bxt> models;

    public MultiLayerModel(ImmutableMap<Optional<ahm>, bxt> models) {
        this.models = models;
    }

    @Override
    public Collection<kk> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<kk> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<ahm>, bxo> buildModels(ImmutableMap<Optional<ahm>, bxt> models, IModelState state, bvr format, Function<kk, bvh> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((kk)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public bxo bake(IModelState state, bvr format, Function<kk, bvh> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (ahm layer : ahm.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<ahm>, bxt>)models);
    }

    private bxt getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new bxt(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new bxt("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(bwg resourceManager) {
        }

        @Override
        public boolean accepts(kk modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(kk modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<ahm>, bxo> models;
        private final ImmutableMap<bos.b, TRSRTransformation> cameraTransforms;
        private final bxo base;
        private final bxo missing;
        private final ImmutableMap<Optional<cq>, ImmutableList<bof>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<ahm>, bxo> models, bxo missing, ImmutableMap<bos.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (bxo)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<cq>)Optional.absent()));
            for (cq side : cq.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<cq>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<bof> buildQuads(ImmutableMap<Optional<ahm>, bxo> models, Optional<cq> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (bxo model : models.values()) {
                builder.addAll((Iterable)model.a(null, (cq)side.orNull(), 0L));
            }
            return builder.build();
        }

        public List<bof> a(arc state, cq side, long rand) {
            ahm layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            bxo model = !this.models.containsKey((Object)Optional.of((Object)layer)) ? this.missing : (bxo)this.models.get((Object)Optional.of((Object)layer));
            return model.a(state, side, rand);
        }

        public boolean a() {
            return this.base.a();
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public bvh d() {
            return this.base.d();
        }

        public bos e() {
            return bos.a;
        }

        @Override
        public Pair<? extends bxo, Matrix4f> handlePerspective(bos.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((bxo)this, this.cameraTransforms, cameraTransformType);
        }

        public boq f() {
            return boq.a;
        }
    }
}

